/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Bignum")
public abstract class BignumNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"to_s", "inspect"}, optional=1)
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject value, NotProvided base) {
            return this.create7BitString(StringOperations.encodeByteList(Layouts.BIGNUM.getValue(value).toString(), (Encoding)USASCIIEncoding.INSTANCE));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject value, int base) {
            if (base < 2 || base > 36) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorInvalidRadix(base, this));
            }
            return this.create7BitString(StringOperations.encodeByteList(Layouts.BIGNUM.getValue(value).toString(base), (Encoding)USASCIIEncoding.INSTANCE));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double toF(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).doubleValue();
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(DynamicObject value) {
            return (Layouts.BIGNUM.getValue(value).bitLength() + 7) / 8;
        }
    }

    @CoreMethod(names={"odd?"})
    public static abstract class OddNode
    extends BignumCoreMethodNode {
        public OddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean odd(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).testBit(0);
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).hashCode();
        }
    }

    @CoreMethod(names={"even?"})
    public static abstract class EvenNode
    extends BignumCoreMethodNode {
        public EvenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean even(DynamicObject value) {
            return !Layouts.BIGNUM.getValue(value).testBit(0);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        @Specialization
        public DynamicObject divMod(DynamicObject a, long b) {
            return this.divModNode.execute(Layouts.BIGNUM.getValue(a), b);
        }

        @Specialization
        public DynamicObject divMod(DynamicObject a, double b) {
            return this.divModNode.execute(Layouts.BIGNUM.getValue(a), b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public DynamicObject divMod(DynamicObject a, DynamicObject b) {
            return this.divModNode.execute(Layouts.BIGNUM.getValue(a), Layouts.BIGNUM.getValue(b));
        }
    }

    @CoreMethod(names={"coerce"}, required=1)
    public static abstract class CoerceNode
    extends CoreMethodArrayArgumentsNode {
        public CoerceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject coerce(DynamicObject a, int b) {
            CompilerDirectives.transferToInterpreter();
            Object[] store = new Object[]{b, a};
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization
        public DynamicObject coerce(DynamicObject a, long b) {
            CompilerDirectives.transferToInterpreter();
            Object[] store = new Object[]{b, a};
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public DynamicObject coerce(DynamicObject a, DynamicObject b) {
            CompilerDirectives.transferToInterpreter();
            Object[] store = new Object[]{b, a};
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, store.length);
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodArrayArgumentsNode {
        public BitLengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int bitLength(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).bitLength();
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends BignumCoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object abs(DynamicObject value) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(value).abs());
        }
    }

    @CoreMethod(names={">>"}, required=1, lowerFixnumParameters={0})
    public static abstract class RightShiftNode
    extends BignumCoreMethodNode {
        private final BranchProfile bLessThanZero = BranchProfile.create();

        public RightShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object leftShift(DynamicObject a, int b) {
            if (b >= 0) {
                return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).shiftRight(b));
            }
            this.bLessThanZero.enter();
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).shiftLeft(-b));
        }
    }

    @CoreMethod(names={"<<"}, required=1, lowerFixnumParameters={0})
    public static abstract class LeftShiftNode
    extends BignumCoreMethodNode {
        private final BranchProfile bLessThanZero = BranchProfile.create();

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object leftShift(DynamicObject a, int b) {
            if (b >= 0) {
                return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).shiftLeft(b));
            }
            this.bLessThanZero.enter();
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).shiftRight(-b));
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumCoreMethodNode {
        public BitXOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object bitXOr(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).xor(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitXOr(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).xor(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumCoreMethodNode {
        public BitOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object bitOr(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).or(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitOr(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).or(Layouts.BIGNUM.getValue(a)));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumCoreMethodNode {
        public BitAndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object bitAnd(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).and(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitAnd(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).and(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"~"})
    public static abstract class ComplementNode
    extends BignumCoreMethodNode {
        public ComplementNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object complement(DynamicObject value) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(value).not());
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean greater(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b)) > 0;
        }

        @Specialization
        public boolean greater(DynamicObject a, double b) {
            return Double.compare(Layouts.BIGNUM.getValue(a).doubleValue(), b) > 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b)) > 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterCoerced(VirtualFrame frame, DynamicObject a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a > b", "other", b);
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean greaterEqual(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b)) >= 0;
        }

        @Specialization
        public boolean greaterEqual(DynamicObject a, double b) {
            return Double.compare(Layouts.BIGNUM.getValue(a).doubleValue(), b) >= 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b)) >= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterEqualCoerced(VirtualFrame frame, DynamicObject a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a >= b", "other", b);
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BooleanCastNode booleanCastNode;
        @Node.Child
        private CallDispatchHeadNode reverseCallNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean equal(DynamicObject a, int b) {
            return false;
        }

        @Specialization
        public boolean equal(DynamicObject a, long b) {
            return false;
        }

        @Specialization
        public boolean equal(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() == b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).equals(Layouts.BIGNUM.getValue(b));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public boolean equal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.reverseCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.reverseCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object reversedResult = this.reverseCallNode.call(frame, b, "==", null, a);
            return this.booleanCastNode.executeBoolean(frame, reversedResult);
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean lessEqual(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b)) <= 0;
        }

        @Specialization
        public boolean lessEqual(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf((long)b)) <= 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b)) <= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessEqualCoerced(VirtualFrame frame, DynamicObject a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a <= b", "other", b);
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean less(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b)) < 0;
        }

        @Specialization
        public boolean less(DynamicObject a, double b) {
            return Double.compare(Layouts.BIGNUM.getValue(a).doubleValue(), b) < 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean less(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b)) < 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessCoerced(VirtualFrame frame, DynamicObject a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }
    }

    @CoreMethod(names={"%", "modulo"}, required=1)
    public static abstract class ModNode
    extends BignumCoreMethodNode {
        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object mod(DynamicObject a, long b) {
            if (b == 0L) {
                throw new ArithmeticException("divide by zero");
            }
            if (b < 0L) {
                BigInteger bigint = BigInteger.valueOf(b);
                BigInteger mod = Layouts.BIGNUM.getValue(a).mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).mod(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object mod(DynamicObject a, DynamicObject b) {
            BigInteger bigint = Layouts.BIGNUM.getValue(b);
            int compare = bigint.compareTo(BigInteger.ZERO);
            if (compare == 0) {
                throw new ArithmeticException("divide by zero");
            }
            if (compare < 0) {
                BigInteger mod = Layouts.BIGNUM.getValue(a).mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).mod(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isRubyBignum(b)"})
        public Object mod(VirtualFrame frame, DynamicObject a, Object b) {
            return this.ruby(frame, "redo_coerced :%, other", "other", b);
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends BignumCoreMethodNode {
        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object div(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).divide(BigInteger.valueOf(b)));
        }

        @Specialization
        public double div(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() / b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object div(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).divide(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends BignumCoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mul(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).multiply(BigInteger.valueOf(b)));
        }

        @Specialization
        public double mul(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() * b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBignum(b)"})
        public Object mul(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).multiply(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isDouble(b)", "!isRubyBignum(b)"})
        public Object mul(VirtualFrame frame, DynamicObject a, Object b) {
            return this.ruby(frame, "redo_coerced :*, other", "other", b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object sub(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public double sub(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() - b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object sub(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).subtract(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumCoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object add(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).add(BigInteger.valueOf(b)));
        }

        @Specialization
        public double add(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() + b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object add(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).add(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BignumCoreMethodNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object neg(DynamicObject value) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(value).negate());
        }
    }

    public static abstract class BignumCoreMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public BignumCoreMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public Object fixnumOrBignum(BigInteger value) {
            if (this.fixnumOrBignum == null) {
                CompilerDirectives.transferToInterpreter();
                this.fixnumOrBignum = (FixnumOrBignumNode)this.insert(new FixnumOrBignumNode(this.getContext(), this.getSourceSection()));
            }
            return this.fixnumOrBignum.fixnumOrBignum(value);
        }
    }
}

