/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.format.nodes.type.ToIntegerNode;
import org.jruby.truffle.format.nodes.type.ToIntegerNodeGen;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadIntegerNode
extends PackNode {
    @Node.Child
    private ToIntegerNode toIntegerNode;

    public ReadIntegerNode(RubyContext context) {
        super(context);
    }

    @Specialization(guards={"isNull(source)"})
    public double read(VirtualFrame frame, Object source) {
        CompilerDirectives.transferToInterpreter();
        this.advanceSourcePosition(frame);
        throw new IllegalStateException();
    }

    @Specialization
    public int read(VirtualFrame frame, int[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public int read(VirtualFrame frame, long[] source) {
        return (int)source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public int read(VirtualFrame frame, double[] source) {
        return (int)source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public int read(VirtualFrame frame, Object[] source) {
        Object value;
        if (this.toIntegerNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toIntegerNode = (ToIntegerNode)this.insert(ToIntegerNodeGen.create(this.getContext(), null));
        }
        if ((value = this.toIntegerNode.executeToInteger(frame, source[this.advanceSourcePosition(frame)])) instanceof Long) {
            return (int)((Long)value).longValue();
        }
        return (Integer)value;
    }
}

