/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jcodings.Encoding;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.EncodingLayout;
import org.jruby.util.ByteList;

public class EncodingLayoutImpl
extends BasicObjectLayoutImpl
implements EncodingLayout {
    public static final EncodingLayout INSTANCE = new EncodingLayoutImpl();
    protected static final Shape.Allocator ENCODING_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ENCODING_IDENTIFIER = new HiddenKey("encoding");
    protected static final Property ENCODING_PROPERTY = Property.create((Object)ENCODING_IDENTIFIER, (Location)ENCODING_ALLOCATOR.locationForType(Encoding.class), (int)0);
    protected static final HiddenKey NAME_IDENTIFIER = new HiddenKey("name");
    protected static final Property NAME_PROPERTY = Property.create((Object)NAME_IDENTIFIER, (Location)ENCODING_ALLOCATOR.locationForType(ByteList.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);
    protected static final HiddenKey DUMMY_IDENTIFIER = new HiddenKey("dummy");
    protected static final Property DUMMY_PROPERTY = Property.create((Object)DUMMY_IDENTIFIER, (Location)ENCODING_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);

    protected EncodingLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createEncodingShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new EncodingType(logicalClass, metaClass)).addProperty(ENCODING_PROPERTY).addProperty(NAME_PROPERTY).addProperty(DUMMY_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createEncoding(DynamicObjectFactory factory, Encoding encoding, ByteList name, boolean dummy) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsEncoding(factory));
        assert (factory.getShape().hasProperty((Object)ENCODING_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)NAME_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)DUMMY_IDENTIFIER));
        assert (name != null);
        return factory.newInstance(new Object[]{encoding, name, dummy});
    }

    @Override
    public boolean isEncoding(Object object) {
        return object instanceof DynamicObject && this.isEncoding((DynamicObject)object);
    }

    @Override
    public boolean isEncoding(DynamicObject object) {
        return this.isEncoding(object.getShape().getObjectType());
    }

    private boolean isEncoding(ObjectType objectType) {
        return objectType instanceof EncodingType;
    }

    private boolean createsEncoding(DynamicObjectFactory factory) {
        return this.isEncoding(factory.getShape().getObjectType());
    }

    @Override
    public Encoding getEncoding(DynamicObject object) {
        assert (this.isEncoding(object));
        assert (object.getShape().hasProperty((Object)ENCODING_IDENTIFIER));
        return (Encoding)ENCODING_PROPERTY.get(object, true);
    }

    @Override
    public void setEncoding(DynamicObject object, Encoding value) {
        assert (this.isEncoding(object));
        assert (object.getShape().hasProperty((Object)ENCODING_IDENTIFIER));
        try {
            ENCODING_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public ByteList getName(DynamicObject object) {
        assert (this.isEncoding(object));
        assert (object.getShape().hasProperty((Object)NAME_IDENTIFIER));
        return (ByteList)NAME_PROPERTY.get(object, true);
    }

    @Override
    public boolean getDummy(DynamicObject object) {
        assert (this.isEncoding(object));
        assert (object.getShape().hasProperty((Object)DUMMY_IDENTIFIER));
        return (Boolean)DUMMY_PROPERTY.get(object, true);
    }

    protected static class EncodingType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public EncodingType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public EncodingType setLogicalClass(DynamicObject logicalClass) {
            return new EncodingType(logicalClass, this.metaClass);
        }

        @Override
        public EncodingType setMetaClass(DynamicObject metaClass) {
            return new EncodingType(this.logicalClass, metaClass);
        }
    }
}

