/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.format.nodes.PackGuards;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.format.nodes.type.ToLongNode;
import org.jruby.truffle.format.nodes.type.ToLongNodeGen;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadLongOrBigIntegerNode
extends PackNode {
    @Node.Child
    private ToLongNode toLongNode;
    private final ConditionProfile bignumProfile = ConditionProfile.createBinaryProfile();

    public ReadLongOrBigIntegerNode(RubyContext context) {
        super(context);
    }

    @Specialization(guards={"isNull(source)"})
    public void read(VirtualFrame frame, Object source) {
        CompilerDirectives.transferToInterpreter();
        this.advanceSourcePosition(frame);
        throw new IllegalStateException();
    }

    @Specialization
    public int read(VirtualFrame frame, int[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public long read(VirtualFrame frame, long[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public Object read(VirtualFrame frame, Object[] source) {
        Object value = source[this.advanceSourcePosition(frame)];
        if (this.bignumProfile.profile(PackGuards.isRubyBignum(value))) {
            return value;
        }
        if (this.toLongNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toLongNode = (ToLongNode)this.insert(ToLongNodeGen.create(this.getContext(), null));
        }
        return this.toLongNode.executeToLong(frame, value);
    }
}

