/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.PopOneNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=PopOneNode.class)
public final class PopOneNodeGen
extends PopOneNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private PopOneNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array) {
        super(context, sourceSection);
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executePopOne(DynamicObject arrayValue) {
        return this.specialization_.execute1(arrayValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static PopOneNode create(RubyContext context, SourceSection sourceSection, RubyNode array) {
        return new PopOneNodeGen(context, sourceSection, array);
    }

    @GeneratedBy(methodName="popOneObject(DynamicObject)", value=PopOneNode.class)
    private static final class PopOneObjectNode_
    extends BaseNode_ {
        PopOneObjectNode_(PopOneNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && !ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return this.root.popOneObject(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && !ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.popOneObject(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(PopOneNodeGen root) {
            return new PopOneObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="popOneDouble(DynamicObject)", value=PopOneNode.class)
    private static final class PopOneDoubleNode_
    extends BaseNode_ {
        PopOneDoubleNode_(PopOneNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && !ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.popOneDouble(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && !ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.popOneDouble(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(PopOneNodeGen root) {
            return new PopOneDoubleNode_(root);
        }
    }

    @GeneratedBy(methodName="popOneLong(DynamicObject)", value=PopOneNode.class)
    private static final class PopOneLongNode_
    extends BaseNode_ {
        PopOneLongNode_(PopOneNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && !ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue)) {
                return this.root.popOneLong(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && !ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.popOneLong(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(PopOneNodeGen root) {
            return new PopOneLongNode_(root);
        }
    }

    @GeneratedBy(methodName="popOneInteger(DynamicObject)", value=PopOneNode.class)
    private static final class PopOneIntegerNode_
    extends BaseNode_ {
        PopOneIntegerNode_(PopOneNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && !ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue)) {
                return this.root.popOneInteger(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && !ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.popOneInteger(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(PopOneNodeGen root) {
            return new PopOneIntegerNode_(root);
        }
    }

    @GeneratedBy(methodName="popOneEmpty(DynamicObject)", value=PopOneNode.class)
    private static final class PopOneEmptyNode_
    extends BaseNode_ {
        PopOneEmptyNode_(PopOneNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isEmptyArray(arrayValue)) {
                return this.root.popOneEmpty(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.popOneEmpty(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(PopOneNodeGen root) {
            return new PopOneEmptyNode_(root);
        }
    }

    @GeneratedBy(value=PopOneNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(PopOneNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public Object execute_(Object arrayValue) {
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(PopOneNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=PopOneNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(PopOneNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(Object arrayValue) {
            return this.uninitialized(null, arrayValue);
        }

        static BaseNode_ create(PopOneNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=PopOneNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final PopOneNodeGen root;

        BaseNode_(PopOneNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.execute_(arrayValue);
        }

        public abstract Object execute_(Object var1);

        public Object execute1(DynamicObject arrayValue) {
            return this.execute_(arrayValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.execute_(arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return PopOneEmptyNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return PopOneIntegerNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return PopOneLongNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return PopOneDoubleNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return PopOneObjectNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

