/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.Translator;

public class ReloadArgumentsTranslator
extends Translator {
    private final BodyTranslator methodBodyTranslator;
    private int index = 0;
    private boolean hasRestParameter = false;

    public ReloadArgumentsTranslator(Node currentNode, RubyContext context, Source source, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.methodBodyTranslator = methodBodyTranslator;
    }

    public RubyNode visitArgsNode(ArgsNode node) {
        int optArgsCount;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        org.jruby.ast.Node[] args = node.getArgs();
        int preCount = node.getPreCount();
        if (preCount > 0) {
            for (int i = 0; i < preCount; ++i) {
                sequence.add((RubyNode)((Object)args[i].accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        if ((optArgsCount = node.getOptionalArgsCount()) > 0) {
            int optArgsIndex = node.getOptArgIndex();
            for (int i = 0; i < optArgsCount; ++i) {
                sequence.add((RubyNode)((Object)args[optArgsIndex + i].accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        if (node.hasRestArg()) {
            this.hasRestParameter = true;
            sequence.add((RubyNode)((Object)node.getRestArgNode().accept((NodeVisitor)this)));
        }
        if (node.getPostCount() > 0) {
            System.err.println("WARNING: post args in zsuper not yet implemented at " + sourceSection.getShortDescription());
        }
        if (node.hasKwargs()) {
            System.err.println("WARNING: kwargs in zsuper not yet implemented at " + sourceSection.getShortDescription());
        }
        return SequenceNode.sequenceNoFlatten(this.context, sourceSection, sequence);
    }

    public RubyNode visitArgumentNode(ArgumentNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    public RubyNode visitOptArgNode(OptArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    public RubyNode visitMultipleAsgnNode(MultipleAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new ReadPreArgumentNode(this.context, sourceSection, this.index, MissingArgumentBehaviour.NIL);
    }

    public RubyNode visitRestArgNode(RestArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    protected RubyNode defaultVisit(org.jruby.ast.Node node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.nilNode(sourceSection);
    }

    @Override
    protected String getIdentifier() {
        return this.methodBodyTranslator.getIdentifier();
    }

    public boolean isSplatted() {
        return this.hasRestParameter;
    }
}

