/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.signal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.truffle.runtime.signal.SignalHandler;

public class Signal {
    private final sun.misc.Signal sunSignal;
    private static final ConcurrentMap<sun.misc.Signal, sun.misc.SignalHandler> DEFAULT_HANDLERS = new ConcurrentHashMap<sun.misc.Signal, sun.misc.SignalHandler>();

    public Signal(String name) {
        this.sunSignal = new sun.misc.Signal(name);
    }

    public static void handle(Signal signal, SignalHandler newHandler) {
        sun.misc.SignalHandler oldSunHandler = sun.misc.Signal.handle(signal.sunSignal, Signal.wrapHandler(signal, newHandler));
        DEFAULT_HANDLERS.putIfAbsent(signal.sunSignal, oldSunHandler);
    }

    public static void handleDefault(Signal signal) {
        sun.misc.SignalHandler defaultHandler = (sun.misc.SignalHandler)DEFAULT_HANDLERS.get(signal.sunSignal);
        if (defaultHandler != null) {
            sun.misc.Signal.handle(signal.sunSignal, defaultHandler);
        }
    }

    private static sun.misc.SignalHandler wrapHandler(final Signal signal, final SignalHandler newHandler) {
        return new sun.misc.SignalHandler(){

            @Override
            public void handle(sun.misc.Signal wrappedSignal) {
                newHandler.handle(signal);
            }
        };
    }

    public static void raise(Signal signal) {
        sun.misc.Signal.raise(signal.sunSignal);
    }
}

