/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.joni.Region;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.MatchDataLayout;

public class MatchDataLayoutImpl
extends BasicObjectLayoutImpl
implements MatchDataLayout {
    public static final MatchDataLayout INSTANCE = new MatchDataLayoutImpl();
    protected static final Shape.Allocator MATCH_DATA_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey SOURCE_IDENTIFIER = new HiddenKey("source");
    protected static final Property SOURCE_PROPERTY = Property.create((Object)SOURCE_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey REGEXP_IDENTIFIER = new HiddenKey("regexp");
    protected static final Property REGEXP_PROPERTY = Property.create((Object)REGEXP_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey REGION_IDENTIFIER = new HiddenKey("region");
    protected static final Property REGION_PROPERTY = Property.create((Object)REGION_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(Region.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey VALUES_IDENTIFIER = new HiddenKey("values");
    protected static final Property VALUES_PROPERTY = Property.create((Object)VALUES_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(Object[].class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey PRE_IDENTIFIER = new HiddenKey("pre");
    protected static final Property PRE_PROPERTY = Property.create((Object)PRE_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey POST_IDENTIFIER = new HiddenKey("post");
    protected static final Property POST_PROPERTY = Property.create((Object)POST_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey GLOBAL_IDENTIFIER = new HiddenKey("global");
    protected static final Property GLOBAL_PROPERTY = Property.create((Object)GLOBAL_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey BEGIN_IDENTIFIER = new HiddenKey("begin");
    protected static final Property BEGIN_PROPERTY = Property.create((Object)BEGIN_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey END_IDENTIFIER = new HiddenKey("end");
    protected static final Property END_PROPERTY = Property.create((Object)END_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey CHAR_OFFSET_UPDATED_IDENTIFIER = new HiddenKey("charOffsetUpdated");
    protected static final Property CHAR_OFFSET_UPDATED_PROPERTY = Property.create((Object)CHAR_OFFSET_UPDATED_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey CHAR_OFFSETS_IDENTIFIER = new HiddenKey("charOffsets");
    protected static final Property CHAR_OFFSETS_PROPERTY = Property.create((Object)CHAR_OFFSETS_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(Region.class), (int)0);
    protected static final HiddenKey FULL_TUPLE_IDENTIFIER = new HiddenKey("fullTuple");
    protected static final Property FULL_TUPLE_PROPERTY = Property.create((Object)FULL_TUPLE_IDENTIFIER, (Location)MATCH_DATA_ALLOCATOR.locationForType(Object.class), (int)0);

    protected MatchDataLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createMatchDataShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new MatchDataType(logicalClass, metaClass)).addProperty(SOURCE_PROPERTY).addProperty(REGEXP_PROPERTY).addProperty(REGION_PROPERTY).addProperty(VALUES_PROPERTY).addProperty(PRE_PROPERTY).addProperty(POST_PROPERTY).addProperty(GLOBAL_PROPERTY).addProperty(BEGIN_PROPERTY).addProperty(END_PROPERTY).addProperty(CHAR_OFFSET_UPDATED_PROPERTY).addProperty(CHAR_OFFSETS_PROPERTY).addProperty(FULL_TUPLE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createMatchData(DynamicObjectFactory factory, DynamicObject source, DynamicObject regexp, Region region, Object[] values, DynamicObject pre, DynamicObject post, DynamicObject global, int begin, int end, boolean charOffsetUpdated, Region charOffsets, Object fullTuple) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsMatchData(factory));
        assert (factory.getShape().hasProperty((Object)SOURCE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)REGEXP_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)REGION_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)VALUES_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)PRE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)POST_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)GLOBAL_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)BEGIN_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)END_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)CHAR_OFFSET_UPDATED_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)CHAR_OFFSETS_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)FULL_TUPLE_IDENTIFIER));
        assert (source != null);
        assert (regexp != null);
        assert (region != null);
        assert (values != null);
        assert (pre != null);
        assert (post != null);
        assert (global != null);
        return factory.newInstance(new Object[]{source, regexp, region, values, pre, post, global, begin, end, charOffsetUpdated, charOffsets, fullTuple});
    }

    @Override
    public boolean isMatchData(Object object) {
        return object instanceof DynamicObject && this.isMatchData((DynamicObject)object);
    }

    @Override
    public boolean isMatchData(DynamicObject object) {
        return this.isMatchData(object.getShape().getObjectType());
    }

    private boolean isMatchData(ObjectType objectType) {
        return objectType instanceof MatchDataType;
    }

    private boolean createsMatchData(DynamicObjectFactory factory) {
        return this.isMatchData(factory.getShape().getObjectType());
    }

    @Override
    public DynamicObject getSource(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)SOURCE_IDENTIFIER));
        return (DynamicObject)SOURCE_PROPERTY.get(object, true);
    }

    @Override
    public DynamicObject getRegexp(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)REGEXP_IDENTIFIER));
        return (DynamicObject)REGEXP_PROPERTY.get(object, true);
    }

    @Override
    public Region getRegion(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)REGION_IDENTIFIER));
        return (Region)REGION_PROPERTY.get(object, true);
    }

    @Override
    public Object[] getValues(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)VALUES_IDENTIFIER));
        return (Object[])VALUES_PROPERTY.get(object, true);
    }

    @Override
    public DynamicObject getPre(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)PRE_IDENTIFIER));
        return (DynamicObject)PRE_PROPERTY.get(object, true);
    }

    @Override
    public DynamicObject getPost(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)POST_IDENTIFIER));
        return (DynamicObject)POST_PROPERTY.get(object, true);
    }

    @Override
    public DynamicObject getGlobal(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)GLOBAL_IDENTIFIER));
        return (DynamicObject)GLOBAL_PROPERTY.get(object, true);
    }

    @Override
    public int getBegin(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)BEGIN_IDENTIFIER));
        return (Integer)BEGIN_PROPERTY.get(object, true);
    }

    @Override
    public int getEnd(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)END_IDENTIFIER));
        return (Integer)END_PROPERTY.get(object, true);
    }

    @Override
    public boolean getCharOffsetUpdated(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)CHAR_OFFSET_UPDATED_IDENTIFIER));
        return (Boolean)CHAR_OFFSET_UPDATED_PROPERTY.get(object, true);
    }

    @Override
    public void setCharOffsetUpdated(DynamicObject object, boolean value) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)CHAR_OFFSET_UPDATED_IDENTIFIER));
        try {
            CHAR_OFFSET_UPDATED_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Region getCharOffsets(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)CHAR_OFFSETS_IDENTIFIER));
        return (Region)CHAR_OFFSETS_PROPERTY.get(object, true);
    }

    @Override
    public void setCharOffsets(DynamicObject object, Region value) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)CHAR_OFFSETS_IDENTIFIER));
        try {
            CHAR_OFFSETS_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Object getFullTuple(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)FULL_TUPLE_IDENTIFIER));
        return FULL_TUPLE_PROPERTY.get(object, true);
    }

    @Override
    public void setFullTuple(DynamicObject object, Object value) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty((Object)FULL_TUPLE_IDENTIFIER));
        try {
            FULL_TUPLE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class MatchDataType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public MatchDataType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public MatchDataType setLogicalClass(DynamicObject logicalClass) {
            return new MatchDataType(logicalClass, this.metaClass);
        }

        @Override
        public MatchDataType setMetaClass(DynamicObject metaClass) {
            return new MatchDataType(this.logicalClass, metaClass);
        }
    }
}

