/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import jnr.constants.platform.Fcntl;
import jnr.ffi.Pointer;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyEncoding;
import org.jruby.RubyString;
import org.jruby.platform.Platform;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.rubinius.PointerNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

@CoreClass(name="Rubinius::FFI::Platform::POSIX")
public abstract class PosixNodes {

    @CoreMethod(names={"_getsockopt"}, isModuleFunction=true, required=5)
    public static abstract class GetSockOptNode
    extends CoreMethodArrayArgumentsNode {
        public GetSockOptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(optval)", "isRubyPointer(optlen)"})
        public int getSockOptions(int sockfd, int level, int optname, DynamicObject optval, DynamicObject optlen) {
            return this.nativeSockets().getsockopt(sockfd, level, optname, Layouts.POINTER.getPointer(optval), Layouts.POINTER.getPointer(optlen));
        }

        @Specialization(guards={"isRubySymbol(level)", "isRubySymbol(optname)", "isRubyPointer(optval)", "isRubyPointer(optlen)"})
        public int getSockOptionsSymbols(VirtualFrame frame, int sockfd, DynamicObject level, DynamicObject optname, DynamicObject optval, DynamicObject optlen) {
            int levelInt = (Integer)this.ruby(frame, "Socket::SOL_" + Layouts.SYMBOL.getString(level), new Object[0]);
            int optnameInt = (Integer)this.ruby(frame, "Socket::SO_" + Layouts.SYMBOL.getString(optname), new Object[0]);
            return this.getSockOptions(sockfd, levelInt, optnameInt, optval, optlen);
        }
    }

    @CoreMethod(names={"_getsockname"}, isModuleFunction=true, required=3)
    public static abstract class GetSockNameNode
    extends CoreMethodArrayArgumentsNode {
        public GetSockNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(address)", "isRubyPointer(addressLength)"})
        public int getSockName(int socket, DynamicObject address, DynamicObject addressLength) {
            return this.nativeSockets().getsockname(socket, Layouts.POINTER.getPointer(address), Layouts.POINTER.getPointer(addressLength));
        }
    }

    @CoreMethod(names={"_getpeername"}, isModuleFunction=true, required=3)
    public static abstract class GetPeerNameNode
    extends CoreMethodArrayArgumentsNode {
        public GetPeerNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(address)", "isRubyPointer(addressLength)"})
        public int getPeerName(int socket, DynamicObject address, DynamicObject addressLength) {
            return this.nativeSockets().getpeername(socket, Layouts.POINTER.getPointer(address), Layouts.POINTER.getPointer(addressLength));
        }
    }

    @CoreMethod(names={"gethostname"}, isModuleFunction=true, required=2)
    public static abstract class GetHostNameNode
    extends CoreMethodArrayArgumentsNode {
        public GetHostNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(name)"})
        public int getHostName(DynamicObject name, int nameLength) {
            return this.nativeSockets().gethostname(Layouts.POINTER.getPointer(name), nameLength);
        }
    }

    @CoreMethod(names={"listen"}, isModuleFunction=true, required=2)
    public static abstract class ListenNode
    extends CoreMethodArrayArgumentsNode {
        public ListenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int listen(int socket, int backlog) {
            return this.nativeSockets().listen(socket, backlog);
        }
    }

    @CoreMethod(names={"_bind"}, isModuleFunction=true, required=3)
    public static abstract class BindNode
    extends CoreMethodArrayArgumentsNode {
        public BindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(address)"})
        public int bind(int socket, DynamicObject address, int addressLength) {
            return this.nativeSockets().bind(socket, Layouts.POINTER.getPointer(address), addressLength);
        }
    }

    @CoreMethod(names={"setsockopt"}, isModuleFunction=true, required=5, lowerFixnumParameters={0, 1, 2, 4})
    public static abstract class SetSockOptNode
    extends CoreMethodArrayArgumentsNode {
        public SetSockOptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(optionValue)"})
        public int setsockopt(int socket, int level, int optionName, DynamicObject optionValue, int optionLength) {
            return this.nativeSockets().setsockopt(socket, level, optionName, Layouts.POINTER.getPointer(optionValue), optionLength);
        }
    }

    @CoreMethod(names={"socket"}, isModuleFunction=true, required=3)
    public static abstract class SocketNode
    extends CoreMethodArrayArgumentsNode {
        public SocketNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getnameinfo(int domain, int type, int protocol) {
            return this.nativeSockets().socket(domain, type, protocol);
        }
    }

    @CoreMethod(names={"shutdown"}, isModuleFunction=true, required=2)
    public static abstract class ShutdownNode
    extends CoreMethodArrayArgumentsNode {
        public ShutdownNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int shutdown(int socket, int how) {
            return this.nativeSockets().shutdown(socket, how);
        }
    }

    @CoreMethod(names={"_getnameinfo"}, isModuleFunction=true, required=7)
    public static abstract class GetNameInfoNode
    extends CoreMethodArrayArgumentsNode {
        public GetNameInfoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(sa)", "isRubyPointer(host)", "isRubyPointer(serv)"})
        public int getnameinfo(DynamicObject sa, int salen, DynamicObject host, int hostlen, DynamicObject serv, int servlen, int flags) {
            assert (hostlen > 0);
            assert (servlen > 0);
            return this.nativeSockets().getnameinfo(Layouts.POINTER.getPointer(sa), salen, Layouts.POINTER.getPointer(host), hostlen, Layouts.POINTER.getPointer(serv), servlen, flags);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(sa)", "isNil(host)", "isRubyPointer(serv)"})
        public int getnameinfoNullHost(DynamicObject sa, int salen, DynamicObject host, int hostlen, DynamicObject serv, int servlen, int flags) {
            assert (hostlen == 0);
            assert (servlen > 0);
            return this.nativeSockets().getnameinfo(Layouts.POINTER.getPointer(sa), salen, PointerNodes.NULL_POINTER, hostlen, Layouts.POINTER.getPointer(serv), servlen, flags);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(sa)", "isRubyPointer(host)", "isNil(serv)"})
        public int getnameinfoNullService(DynamicObject sa, int salen, DynamicObject host, int hostlen, DynamicObject serv, int servlen, int flags) {
            assert (hostlen > 0);
            assert (servlen == 0);
            return this.nativeSockets().getnameinfo(Layouts.POINTER.getPointer(sa), salen, Layouts.POINTER.getPointer(host), hostlen, PointerNodes.NULL_POINTER, servlen, flags);
        }
    }

    @CoreMethod(names={"freeaddrinfo"}, isModuleFunction=true, required=1)
    public static abstract class FreeAddrInfoNode
    extends CoreMethodArrayArgumentsNode {
        public FreeAddrInfoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(addrInfo)"})
        public DynamicObject freeaddrinfo(DynamicObject addrInfo) {
            this.nativeSockets().freeaddrinfo(Layouts.POINTER.getPointer(addrInfo));
            return this.nil();
        }
    }

    @CoreMethod(names={"_connect"}, isModuleFunction=true, required=3, lowerFixnumParameters={0, 2})
    public static abstract class ConnectNode
    extends CoreMethodArrayArgumentsNode {
        public ConnectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(address)"})
        public int connect(int socket, DynamicObject address, int address_len) {
            return this.nativeSockets().connect(socket, Layouts.POINTER.getPointer(address), address_len);
        }
    }

    @CoreMethod(names={"_getaddrinfo"}, isModuleFunction=true, required=4)
    public static abstract class GetAddrInfoNode
    extends CoreMethodArrayArgumentsNode {
        public GetAddrInfoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(hostName)", "isRubyString(serviceName)"})
        public int getaddrinfoNil(DynamicObject hostName, DynamicObject serviceName, DynamicObject hintsPointer, DynamicObject resultsPointer) {
            return this.getaddrinfoString(Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"0.0.0.0", (Encoding)UTF8Encoding.INSTANCE), 16, null), serviceName, hintsPointer, resultsPointer);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(hostName)", "isRubyString(serviceName)", "isRubyPointer(hintsPointer)", "isRubyPointer(resultsPointer)"})
        public int getaddrinfoString(DynamicObject hostName, DynamicObject serviceName, DynamicObject hintsPointer, DynamicObject resultsPointer) {
            return this.nativeSockets().getaddrinfo((CharSequence)Layouts.STRING.getByteList(hostName), (CharSequence)Layouts.STRING.getByteList(serviceName), Layouts.POINTER.getPointer(hintsPointer), Layouts.POINTER.getPointer(resultsPointer));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(hostName)", "isNil(serviceName)", "isRubyPointer(hintsPointer)", "isRubyPointer(resultsPointer)"})
        public int getaddrinfo(DynamicObject hostName, DynamicObject serviceName, DynamicObject hintsPointer, DynamicObject resultsPointer) {
            return this.nativeSockets().getaddrinfo((CharSequence)Layouts.STRING.getByteList(hostName), null, Layouts.POINTER.getPointer(hintsPointer), Layouts.POINTER.getPointer(resultsPointer));
        }
    }

    @CoreMethod(names={"symlink"}, isModuleFunction=true, required=2)
    public static abstract class SymlinkNode
    extends CoreMethodArrayArgumentsNode {
        public SymlinkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubyString(second)"})
        public int symlink(DynamicObject first, DynamicObject second) {
            return this.posix().symlink(first.toString(), second.toString());
        }
    }

    @CoreMethod(names={"getppid"}, isModuleFunction=true)
    public static abstract class GetppidNode
    extends CoreMethodArrayArgumentsNode {
        public GetppidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getppid() {
            return this.posix().getppid();
        }
    }

    @CoreMethod(names={"isatty"}, isModuleFunction=true, required=1)
    public static abstract class IsATTYNode
    extends CoreMethodArrayArgumentsNode {
        public IsATTYNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int isATTY(int fd) {
            return this.posix().libc().isatty(fd);
        }
    }

    @CoreMethod(names={"getpgrp"}, isModuleFunction=true)
    public static abstract class GetpgrpNode
    extends CoreMethodArrayArgumentsNode {
        public GetpgrpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getpgrp() {
            return this.posix().getpgrp();
        }
    }

    @CoreMethod(names={"getpgid"}, isModuleFunction=true, required=1)
    public static abstract class GetpgidNode
    extends CoreMethodArrayArgumentsNode {
        public GetpgidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getpgid(int pid) {
            return this.posix().getpgid(pid);
        }
    }

    @CoreMethod(names={"fcntl"}, isModuleFunction=true, required=3)
    public static abstract class FcntlNode
    extends CoreMethodArrayArgumentsNode {
        public FcntlNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(nil)"})
        public int fcntl(int fd, int fcntl, Object nil) {
            return this.posix().fcntl(fd, Fcntl.valueOf((long)fcntl));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int fcntl(int fd, int fcntl, int arg) {
            return this.posix().fcntlInt(fd, Fcntl.valueOf((long)fcntl), arg);
        }
    }

    @CoreMethod(names={"errno="}, isModuleFunction=true, required=1)
    public static abstract class ErrnoAssignNode
    extends CoreMethodArrayArgumentsNode {
        public ErrnoAssignNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int errno(int errno) {
            this.posix().errno(errno);
            return 0;
        }
    }

    @CoreMethod(names={"errno"}, isModuleFunction=true)
    public static abstract class ErrnoNode
    extends CoreMethodArrayArgumentsNode {
        public ErrnoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int errno() {
            return this.posix().errno();
        }
    }

    @CoreMethod(names={"getcwd"}, isModuleFunction=true, required=2)
    public static abstract class GetcwdNode
    extends CoreMethodArrayArgumentsNode {
        public GetcwdNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(resultPath)"})
        public DynamicObject getcwd(DynamicObject resultPath, int maxSize) {
            String path = this.getContext().getRuntime().getCurrentDirectory();
            Layouts.STRING.getByteList(resultPath).replace(path.getBytes(StandardCharsets.UTF_8));
            return resultPath;
        }
    }

    @CoreMethod(names={"rmdir"}, isModuleFunction=true, required=1)
    public static abstract class RmdirNode
    extends CoreMethodArrayArgumentsNode {
        public RmdirNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int rmdir(DynamicObject path) {
            return this.posix().rmdir(path.toString());
        }
    }

    @CoreMethod(names={"rename"}, isModuleFunction=true, required=2)
    public static abstract class RenameNode
    extends CoreMethodArrayArgumentsNode {
        public RenameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyString(other)"})
        public int rename(DynamicObject path, DynamicObject other) {
            String pathString = RubyEncoding.decodeUTF8((byte[])Layouts.STRING.getByteList(path).getUnsafeBytes(), (int)Layouts.STRING.getByteList(path).getBegin(), (int)Layouts.STRING.getByteList(path).getRealSize());
            String otherString = RubyEncoding.decodeUTF8((byte[])Layouts.STRING.getByteList(other).getUnsafeBytes(), (int)Layouts.STRING.getByteList(other).getBegin(), (int)Layouts.STRING.getByteList(other).getRealSize());
            return this.posix().rename((CharSequence)pathString, (CharSequence)otherString);
        }
    }

    @CoreMethod(names={"minor"}, isModuleFunction=true, required=1, lowerFixnumParameters={0})
    public static abstract class MinorNode
    extends CoreMethodArrayArgumentsNode {
        public MinorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int minor(int dev) {
            return dev & 0xFFFFFF;
        }
    }

    @CoreMethod(names={"major"}, isModuleFunction=true, required=1, lowerFixnumParameters={0})
    public static abstract class MajorNode
    extends CoreMethodArrayArgumentsNode {
        public MajorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int major(int dev) {
            return dev >> 24 & 0xFF;
        }
    }

    @CoreMethod(names={"flock"}, isModuleFunction=true, required=2, lowerFixnumParameters={0, 1})
    public static abstract class FlockNode
    extends CoreMethodArrayArgumentsNode {
        public FlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int flock(int fd, int constant) {
            return this.posix().flock(fd, constant);
        }
    }

    @CoreMethod(names={"setsid"}, isModuleFunction=true)
    public static abstract class SetSidNode
    extends CoreMethodArrayArgumentsNode {
        public SetSidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int setsid() {
            return this.posix().setsid();
        }
    }

    @CoreMethod(names={"setuid"}, isModuleFunction=true, required=1, lowerFixnumParameters={0})
    public static abstract class SetUidNode
    extends CoreMethodArrayArgumentsNode {
        public SetUidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int setuid(int uid) {
            return this.posix().setuid(uid);
        }
    }

    @CoreMethod(names={"setruid"}, isModuleFunction=true, required=1, lowerFixnumParameters={0})
    public static abstract class SetRuidNode
    extends CoreMethodArrayArgumentsNode {
        public SetRuidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setruid(int uid) {
            throw new RaiseException(this.getContext().getCoreLibrary().notImplementedError("setruid", this));
        }
    }

    @CoreMethod(names={"setrlimit"}, isModuleFunction=true, required=2)
    public static abstract class SetRLimitNode
    extends CoreMethodArrayArgumentsNode {
        public SetRLimitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyPointer(pointer)"})
        public int setrlimit(int resource, DynamicObject pointer) {
            int result = this.posix().setrlimit(resource, Layouts.POINTER.getPointer(pointer));
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @CoreMethod(names={"setreuid"}, isModuleFunction=true, required=2, lowerFixnumParameters={0, 1})
    public static abstract class SetReuidNode
    extends CoreMethodArrayArgumentsNode {
        public SetReuidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setreuid(int uid, int id) {
            throw new RaiseException(this.getContext().getCoreLibrary().notImplementedError("setreuid", this));
        }
    }

    @CoreMethod(names={"seteuid"}, isModuleFunction=true, required=1, lowerFixnumParameters={0})
    public static abstract class SetEuidNode
    extends CoreMethodArrayArgumentsNode {
        public SetEuidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int seteuid(int uid) {
            return this.posix().seteuid(uid);
        }
    }

    @CoreMethod(names={"setresuid"}, isModuleFunction=true, required=3, lowerFixnumParameters={0, 1, 2})
    public static abstract class SetResuidNode
    extends CoreMethodArrayArgumentsNode {
        public SetResuidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setresuid(int uid, int id, int priority) {
            throw new RaiseException(this.getContext().getCoreLibrary().notImplementedError("setresuid", this));
        }
    }

    @CoreMethod(names={"setpriority"}, isModuleFunction=true, required=3, lowerFixnumParameters={0, 1, 2})
    public static abstract class SetPriorityNode
    extends CoreMethodArrayArgumentsNode {
        public SetPriorityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int setpriority(int kind, int id, int priority) {
            return this.posix().setpriority(kind, id, priority);
        }
    }

    @CoreMethod(names={"setgid"}, isModuleFunction=true, required=1, lowerFixnumParameters={0})
    public static abstract class SetgidNode
    extends CoreMethodArrayArgumentsNode {
        public SetgidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int setgid(int gid) {
            return this.posix().setgid(gid);
        }
    }

    @CoreMethod(names={"getpriority"}, isModuleFunction=true, required=2, lowerFixnumParameters={0, 1})
    public static abstract class GetPriorityNode
    extends CoreMethodArrayArgumentsNode {
        public GetPriorityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getpriority(int kind, int id) {
            return this.posix().getpriority(kind, id);
        }
    }

    @CoreMethod(names={"chdir"}, isModuleFunction=true, required=1)
    public static abstract class ChdirNode
    extends CoreMethodArrayArgumentsNode {
        public ChdirNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int chdir(DynamicObject path) {
            String pathString = path.toString();
            int result = this.posix().chdir(pathString);
            if (result == 0) {
                this.getContext().getRuntime().setCurrentDirectory(pathString);
            }
            return result;
        }
    }

    @CoreMethod(names={"mkdir"}, isModuleFunction=true, required=2)
    public static abstract class MkdirNode
    extends CoreMethodArrayArgumentsNode {
        public MkdirNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int mkdir(DynamicObject path, int mode) {
            return this.posix().mkdir(path.toString(), mode);
        }
    }

    @CoreMethod(names={"utimes"}, isModuleFunction=true, required=2)
    public static abstract class UtimesNode
    extends CoreMethodArrayArgumentsNode {
        public UtimesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyPointer(pointer)"})
        public int utimes(DynamicObject path, DynamicObject pointer) {
            ByteList byteList = Layouts.STRING.getByteList(path);
            String pathString = RubyEncoding.decodeUTF8((byte[])byteList.getUnsafeBytes(), (int)byteList.getBegin(), (int)byteList.getRealSize());
            int result = this.posix().utimes(pathString, Layouts.POINTER.getPointer(pointer));
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @CoreMethod(names={"unsetenv"}, isModuleFunction=true, required=1)
    public static abstract class UnsetenvNode
    extends CoreMethodArrayArgumentsNode {
        public UnsetenvNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public int unsetenv(DynamicObject name) {
            ByteList byteList = Layouts.STRING.getByteList(name);
            String nameString = RubyEncoding.decodeUTF8((byte[])byteList.getUnsafeBytes(), (int)byteList.getBegin(), (int)byteList.getRealSize());
            return this.posix().unsetenv(nameString);
        }
    }

    @CoreMethod(names={"umask"}, isModuleFunction=true, required=1)
    public static abstract class UmaskNode
    extends CoreMethodArrayArgumentsNode {
        public UmaskNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int umask(int mask) {
            return this.posix().umask(mask);
        }
    }

    @CoreMethod(names={"unlink"}, isModuleFunction=true, required=1)
    public static abstract class UnlinkNode
    extends CoreMethodArrayArgumentsNode {
        public UnlinkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int unlink(DynamicObject path) {
            ByteList byteList = Layouts.STRING.getByteList(path);
            return this.posix().unlink((CharSequence)RubyEncoding.decodeUTF8((byte[])byteList.getUnsafeBytes(), (int)byteList.getBegin(), (int)byteList.getRealSize()));
        }
    }

    @CoreMethod(names={"link"}, isModuleFunction=true, required=2)
    public static abstract class LinkNode
    extends CoreMethodArrayArgumentsNode {
        public LinkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyString(other)"})
        public int link(DynamicObject path, DynamicObject other) {
            String pathString = RubyEncoding.decodeUTF8((byte[])Layouts.STRING.getByteList(path).getUnsafeBytes(), (int)Layouts.STRING.getByteList(path).getBegin(), (int)Layouts.STRING.getByteList(path).getRealSize());
            String otherString = RubyEncoding.decodeUTF8((byte[])Layouts.STRING.getByteList(other).getUnsafeBytes(), (int)Layouts.STRING.getByteList(other).getBegin(), (int)Layouts.STRING.getByteList(other).getRealSize());
            return this.posix().link(pathString, otherString);
        }
    }

    @CoreMethod(names={"setenv"}, isModuleFunction=true, required=3)
    public static abstract class SetenvNode
    extends CoreMethodArrayArgumentsNode {
        public SetenvNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)", "isRubyString(value)"})
        public int setenv(DynamicObject name, DynamicObject value, int overwrite) {
            String nameString = RubyEncoding.decodeUTF8((byte[])Layouts.STRING.getByteList(name).getUnsafeBytes(), (int)Layouts.STRING.getByteList(name).getBegin(), (int)Layouts.STRING.getByteList(name).getRealSize());
            String valueString = RubyEncoding.decodeUTF8((byte[])Layouts.STRING.getByteList(value).getUnsafeBytes(), (int)Layouts.STRING.getByteList(value).getBegin(), (int)Layouts.STRING.getByteList(value).getRealSize());
            return this.posix().setenv(nameString, valueString, overwrite);
        }
    }

    @CoreMethod(names={"readlink"}, isModuleFunction=true, required=3)
    public static abstract class ReadlinkNode
    extends CoreMethodArrayArgumentsNode {
        public ReadlinkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyPointer(pointer)"})
        public int readlink(DynamicObject path, DynamicObject pointer, int bufsize) {
            ByteList byteList = Layouts.STRING.getByteList(path);
            String pathString = RubyEncoding.decodeUTF8((byte[])byteList.unsafeBytes(), (int)byteList.begin(), (int)byteList.length());
            int result = this.posix().readlink((CharSequence)pathString, Layouts.POINTER.getPointer(pointer), bufsize);
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @CoreMethod(names={"putenv"}, isModuleFunction=true, required=1)
    public static abstract class PutenvNode
    extends CoreMethodArrayArgumentsNode {
        public PutenvNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(nameValuePair)"})
        public int putenv(DynamicObject nameValuePair) {
            throw new UnsupportedOperationException("Not yet implemented in jnr-posix");
        }
    }

    @CoreMethod(names={"memset"}, isModuleFunction=true, required=3)
    public static abstract class MemsetNode
    extends CoreMethodArrayArgumentsNode {
        public MemsetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyPointer(pointer)"})
        public DynamicObject memset(DynamicObject pointer, int c, int length) {
            return this.memset(pointer, c, (long)length);
        }

        @Specialization(guards={"isRubyPointer(pointer)"})
        public DynamicObject memset(DynamicObject pointer, int c, long length) {
            Layouts.POINTER.getPointer(pointer).setMemory(0L, length, (byte)c);
            return pointer;
        }
    }

    @CoreMethod(names={"getuid"}, isModuleFunction=true)
    public static abstract class GetUIDNode
    extends CoreMethodArrayArgumentsNode {
        public GetUIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getUID() {
            return this.posix().getuid();
        }
    }

    @CoreMethod(names={"getrlimit"}, isModuleFunction=true, required=2)
    public static abstract class GetRLimitNode
    extends CoreMethodArrayArgumentsNode {
        public GetRLimitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(pointer)"})
        public int getrlimit(int resource, DynamicObject pointer) {
            int result = this.posix().getrlimit(resource, Layouts.POINTER.getPointer(pointer));
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @CoreMethod(names={"getgroups"}, isModuleFunction=true, required=2)
    public static abstract class GetGroupsNode
    extends CoreMethodArrayArgumentsNode {
        public GetGroupsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNil(pointer)"})
        public int getGroupsNil(int max, DynamicObject pointer) {
            return Platform.getPlatform().getGroups(null).length;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(pointer)"})
        public int getGroups(int max, DynamicObject pointer) {
            long[] groups = Platform.getPlatform().getGroups(null);
            Pointer pointerValue = Layouts.POINTER.getPointer(pointer);
            for (int n = 0; n < groups.length && n < max; ++n) {
                pointerValue.putInt((long)(4 * n), (int)groups[n]);
            }
            return groups.length;
        }
    }

    @CoreMethod(names={"getgid"}, isModuleFunction=true)
    public static abstract class GetGIDNode
    extends CoreMethodArrayArgumentsNode {
        public GetGIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getGID() {
            return this.posix().getgid();
        }
    }

    @CoreMethod(names={"geteuid"}, isModuleFunction=true)
    public static abstract class GetEUIDNode
    extends CoreMethodArrayArgumentsNode {
        public GetEUIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getEUID() {
            return this.posix().geteuid();
        }
    }

    @CoreMethod(names={"getenv"}, isModuleFunction=true, required=1)
    public static abstract class GetenvNode
    extends CoreMethodArrayArgumentsNode {
        public GetenvNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public DynamicObject getenv(DynamicObject name) {
            String nameString = RubyEncoding.decodeUTF8((byte[])Layouts.STRING.getByteList(name).getUnsafeBytes(), (int)Layouts.STRING.getByteList(name).getBegin(), (int)Layouts.STRING.getByteList(name).getRealSize());
            String result = this.posix().getenv(nameString);
            if (result == null) {
                return this.nil();
            }
            return Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(this.getContext().getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)result, (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
    }

    @CoreMethod(names={"getegid"}, isModuleFunction=true)
    public static abstract class GetEGIDNode
    extends CoreMethodArrayArgumentsNode {
        public GetEGIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getEGID() {
            return this.posix().getegid();
        }
    }

    @CoreMethod(names={"fchown"}, isModuleFunction=true, required=3)
    public static abstract class FchownNode
    extends CoreMethodArrayArgumentsNode {
        public FchownNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int fchown(int descriptor, int owner, int group) {
            return this.posix().fchown(descriptor, owner, group);
        }
    }

    @CoreMethod(names={"fsync"}, isModuleFunction=true, required=1)
    public static abstract class FsyncNode
    extends CoreMethodArrayArgumentsNode {
        public FsyncNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int fsync(int descriptor) {
            return this.posix().fsync(descriptor);
        }
    }

    @CoreMethod(names={"fchmod"}, isModuleFunction=true, required=2)
    public static abstract class FchmodNode
    extends CoreMethodArrayArgumentsNode {
        public FchmodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int fchmod(int one, int mode) {
            return this.posix().fchmod(one, mode);
        }
    }

    @CoreMethod(names={"environ"}, isModuleFunction=true)
    public static abstract class EnvironNode
    extends CoreMethodArrayArgumentsNode {
        public EnvironNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject environ() {
            return PointerNodes.createPointer(this.getContext().getCoreLibrary().getRubiniusFFIPointerClass(), this.posix().environ());
        }
    }

    @CoreMethod(names={"dup"}, isModuleFunction=true, required=1)
    public static abstract class DupNode
    extends CoreMethodArrayArgumentsNode {
        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int dup(int descriptor) {
            return this.posix().dup(descriptor);
        }
    }

    @CoreMethod(names={"chown"}, isModuleFunction=true, required=3, lowerFixnumParameters={1, 2})
    public static abstract class ChownNode
    extends CoreMethodArrayArgumentsNode {
        public ChownNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int chown(DynamicObject path, int owner, int group) {
            return this.posix().chown(path.toString(), owner, group);
        }
    }

    @CoreMethod(names={"chmod"}, isModuleFunction=true, required=2)
    public static abstract class ChmodNode
    extends CoreMethodArrayArgumentsNode {
        public ChmodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int chmod(DynamicObject path, int mode) {
            return this.posix().chmod(path.toString(), mode);
        }
    }

    @CoreMethod(names={"access"}, isModuleFunction=true, required=2)
    public static abstract class AccessNode
    extends CoreMethodArrayArgumentsNode {
        public AccessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int access(DynamicObject path, int mode) {
            String pathString = RubyEncoding.decodeUTF8((byte[])Layouts.STRING.getByteList(path).getUnsafeBytes(), (int)Layouts.STRING.getByteList(path).getBegin(), (int)Layouts.STRING.getByteList(path).getRealSize());
            return this.posix().access((CharSequence)pathString, mode);
        }
    }
}

