/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.WriteObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.WriteObjectFieldNode;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class WriteDoubleObjectFieldNode
extends WriteObjectFieldChainNode {
    private final Shape expectedLayout;
    private final Shape newLayout;
    private final DoubleLocation storageLocation;

    public WriteDoubleObjectFieldNode(Shape expectedLayout, Shape newLayout, DoubleLocation storageLocation, WriteObjectFieldNode next) {
        super(next);
        this.expectedLayout = expectedLayout;
        this.newLayout = newLayout;
        this.storageLocation = storageLocation;
    }

    @Override
    public void execute(DynamicObject object, double value) {
        block7: {
            try {
                this.expectedLayout.getValidAssumption().check();
                this.newLayout.getValidAssumption().check();
            }
            catch (InvalidAssumptionException e) {
                this.replace(this.next);
                this.next.execute(object, value);
                return;
            }
            if (object.getShape() == this.expectedLayout) {
                try {
                    if (this.newLayout == this.expectedLayout) {
                        this.storageLocation.setDouble(object, value, this.expectedLayout);
                        break block7;
                    }
                    this.storageLocation.setDouble(object, value, this.expectedLayout, this.newLayout);
                }
                catch (FinalLocationException e) {
                    ((WriteObjectFieldNode)this.replace(this.next, "!final")).execute(object, value);
                }
            } else {
                this.next.execute(object, value);
            }
        }
    }

    @Override
    public void execute(DynamicObject object, Object value) {
        if (value instanceof Double) {
            this.execute(object, (Double)value);
        } else {
            this.next.execute(object, value);
        }
    }
}

