/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.MigrateNode;
import org.jruby.truffle.nodes.objectstorage.WriteBooleanObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteDoubleObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteIntegerObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteLongObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.WriteObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteObjectObjectFieldNode;

@NodeInfo(cost=NodeCost.UNINITIALIZED)
public class UninitializedWriteObjectFieldNode
extends WriteObjectFieldNode {
    private final Object name;

    public UninitializedWriteObjectFieldNode(Object name) {
        this.name = name;
    }

    @Override
    public void execute(DynamicObject object, Object value) {
        Property newProperty;
        Shape newShape;
        CompilerDirectives.transferToInterpreterAndInvalidate();
        Shape currentShape = object.getShape();
        if (object.updateShape()) {
            MigrateNode migrateNode = new MigrateNode(currentShape, this);
            this.replace(migrateNode);
            migrateNode.execute(object, value);
            return;
        }
        Property currentProperty = currentShape.getProperty(this.name);
        if (currentProperty != null && currentProperty.getLocation().canSet(object, value)) {
            newShape = currentShape;
            newProperty = currentProperty;
            newProperty.setSafe(object, value, null);
        } else {
            object.define(this.name, value, 0);
            newShape = object.getShape();
            newProperty = newShape.getProperty(this.name);
            if (newProperty == null) {
                throw new IllegalStateException("Property missing from object's shape even after setting it");
            }
        }
        Location location = newProperty.getLocation();
        WriteObjectFieldChainNode writeNode = location instanceof BooleanLocation ? new WriteBooleanObjectFieldNode(currentShape, newShape, (BooleanLocation)location, this) : (location instanceof IntLocation ? new WriteIntegerObjectFieldNode(currentShape, newShape, (IntLocation)location, this) : (location instanceof LongLocation ? new WriteLongObjectFieldNode(currentShape, newShape, (LongLocation)location, this) : (location instanceof DoubleLocation ? new WriteDoubleObjectFieldNode(currentShape, newShape, (DoubleLocation)location, this) : new WriteObjectObjectFieldNode(currentShape, newShape, location, this))));
        this.replace(writeNode, "adding new write object field node to chain");
    }
}

