/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.ReadClassVariableNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class WriteClassVariableNode
extends RubyNode {
    private final String name;
    private final LexicalScope lexicalScope;
    @Node.Child
    private RubyNode rhs;

    public WriteClassVariableNode(RubyContext context, SourceSection sourceSection, String name, LexicalScope lexicalScope, RubyNode rhs) {
        super(context, sourceSection);
        this.name = name;
        this.lexicalScope = lexicalScope;
        this.rhs = rhs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        Object rhsValue = this.rhs.execute(frame);
        DynamicObject module = ReadClassVariableNode.resolveTargetModule(this.lexicalScope);
        ModuleOperations.setClassVariable(module, this.name, rhsValue, this);
        return rhsValue;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"assignment", (Encoding)UTF8Encoding.INSTANCE), 16, null);
    }
}

