/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="classToAllocate"), @NodeChild(value="values")})
public abstract class AllocateObjectNode
extends RubyNode {
    public AllocateObjectNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public DynamicObject allocate(DynamicObject classToAllocate, Object ... values) {
        return this.executeAllocateX(classToAllocate, values);
    }

    public abstract DynamicObject executeAllocateX(DynamicObject var1, Object[] var2);

    @Specialization(guards={"cachedClassToAllocate == classToAllocate", "!cachedIsSingleton"})
    public DynamicObject allocateCached(DynamicObject classToAllocate, Object[] values, @Cached(value="classToAllocate") DynamicObject cachedClassToAllocate, @Cached(value="isSingleton(classToAllocate)") boolean cachedIsSingleton, @Cached(value="getInstanceFactory(classToAllocate)") DynamicObjectFactory factory) {
        return factory.newInstance(values);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"allocateCached"}, guards={"!isSingleton(classToAllocate)"})
    public DynamicObject allocateUncached(DynamicObject classToAllocate, Object[] values) {
        return this.getInstanceFactory(classToAllocate).newInstance(values);
    }

    @Specialization(guards={"isSingleton(classToAllocate)"})
    public DynamicObject allocateSingleton(DynamicObject classToAllocate, Object[] values) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't create instance of singleton class", this));
    }

    protected boolean isSingleton(DynamicObject classToAllocate) {
        return Layouts.CLASS.getIsSingleton(classToAllocate);
    }
}

