/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeInfo(cost=NodeCost.NONE)
public class BooleanLiteralNode
extends RubyNode {
    private final boolean value;

    public BooleanLiteralNode(RubyContext context, SourceSection sourceSection, boolean value) {
        super(context, sourceSection);
        this.value = value;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        return this.value;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)Boolean.toString(this.value), (Encoding)UTF8Encoding.INSTANCE), 16, null);
    }
}

