/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.util.unsafe.UnsafeHolder;

@CoreClass(name="Queue")
public abstract class QueueNodes {

    @CoreMethod(names={"num_waiting"})
    public static abstract class NumWaitingNode
    extends CoreMethodArrayArgumentsNode {
        private static final long LOCK_FIELD_OFFSET = UnsafeHolder.fieldOffset(LinkedBlockingQueue.class, (String)"takeLock");
        private static final long NOT_EMPTY_CONDITION_FIELD_OFFSET = UnsafeHolder.fieldOffset(LinkedBlockingQueue.class, (String)"notEmpty");

        public NumWaitingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public int num_waiting(DynamicObject self) {
            LinkedBlockingQueue queue;
            LinkedBlockingQueue linkedBlockingQueue = queue = Layouts.QUEUE.getQueue(self);
            final ReentrantLock lock = (ReentrantLock)UnsafeHolder.U.getObject(linkedBlockingQueue, LOCK_FIELD_OFFSET);
            Condition notEmptyCondition = (Condition)UnsafeHolder.U.getObject(linkedBlockingQueue, NOT_EMPTY_CONDITION_FIELD_OFFSET);
            this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    lock.lockInterruptibly();
                    return true;
                }
            });
            try {
                int n = lock.getWaitQueueLength(notEmptyCondition);
                return n;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @CoreMethod(names={"marshal_dump"})
    public static abstract class MarshalDumpNode
    extends CoreMethodArrayArgumentsNode {
        public MarshalDumpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object marshal_dump(DynamicObject self) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantDump(self, this));
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject clear(DynamicObject self) {
            LinkedBlockingQueue queue = Layouts.QUEUE.getQueue(self);
            queue.clear();
            return self;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int size(DynamicObject self) {
            LinkedBlockingQueue queue = Layouts.QUEUE.getQueue(self);
            return queue.size();
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean empty(DynamicObject self) {
            LinkedBlockingQueue queue = Layouts.QUEUE.getQueue(self);
            return queue.isEmpty();
        }
    }

    @CoreMethod(names={"receive_timeout"}, required=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="queue"), @NodeChild(type=RubyNode.class, value="duration")})
    public static abstract class ReceiveTimeoutNode
    extends CoreMethodNode {
        public ReceiveTimeoutNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object receiveTimeout(DynamicObject self, int duration) {
            return this.receiveTimeout(self, (double)duration);
        }

        @Specialization
        public Object receiveTimeout(DynamicObject self, double duration) {
            final LinkedBlockingQueue queue = Layouts.QUEUE.getQueue(self);
            final long durationInMillis = (long)(duration * 1000.0);
            final long start = System.currentTimeMillis();
            return this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Object>(){

                @Override
                public Object block() throws InterruptedException {
                    long now = System.currentTimeMillis();
                    long waited = now - start;
                    if (waited >= durationInMillis) {
                        Object result = queue.poll();
                        if (result == null) {
                            return false;
                        }
                        return result;
                    }
                    Object result = queue.poll(durationInMillis, TimeUnit.MILLISECONDS);
                    if (result == null) {
                        return false;
                    }
                    return result;
                }
            });
        }
    }

    @CoreMethod(names={"pop", "shift", "deq"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="queue"), @NodeChild(type=RubyNode.class, value="nonBlocking")})
    public static abstract class PopNode
    extends CoreMethodNode {
        public PopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"nonBlocking"})
        public RubyNode coerceToBoolean(RubyNode nonBlocking) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), false, nonBlocking);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!nonBlocking"})
        public Object popBlocking(DynamicObject self, boolean nonBlocking) {
            final LinkedBlockingQueue queue = Layouts.QUEUE.getQueue(self);
            return this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Object>(){

                @Override
                public Object block() throws InterruptedException {
                    return queue.take();
                }
            });
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"nonBlocking"})
        public Object popNonBlock(DynamicObject self, boolean nonBlocking) {
            LinkedBlockingQueue queue = Layouts.QUEUE.getQueue(self);
            Object value = queue.poll();
            if (value == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("queue empty", this));
            }
            return value;
        }
    }

    @CoreMethod(names={"push", "<<", "enq"}, required=1)
    public static abstract class PushNode
    extends CoreMethodArrayArgumentsNode {
        public PushNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject push(DynamicObject self, Object value) {
            LinkedBlockingQueue queue = Layouts.QUEUE.getQueue(self);
            queue.add(value);
            return self;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.QUEUE.createQueue(Layouts.CLASS.getInstanceFactory(rubyClass), new LinkedBlockingQueue());
        }
    }
}

