/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNodeGen;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.ThreadLocalObject;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="Binding")
public abstract class BindingNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, null, null);
        }
    }

    @CoreMethod(names={"local_variables"})
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject localVariables(DynamicObject binding) {
            DynamicObject array = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            while (frame != null) {
                for (Object name : frame.getFrameDescriptor().getIdentifiers()) {
                    if (!(name instanceof String)) continue;
                    ArrayOperations.append(array, this.getSymbol((String)name));
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return array;
        }
    }

    @CoreMethod(names={"local_variable_set"}, required=2)
    public static abstract class LocalVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        private final DynamicObject dollarUnderscore = this.getSymbol("$_");

        public LocalVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)", "getFrameDescriptor(binding) == cachedFrameDescriptor", "symbol == cachedSymbol"})
        public Object localVariableSetCached(DynamicObject binding, DynamicObject symbol, Object value, @Cached(value="symbol") DynamicObject cachedSymbol, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="createWriteNode(findFrameSlot(binding, symbol))") WriteFrameSlotNode writeLocalVariableNode) {
            return writeLocalVariableNode.executeWrite((Frame)Layouts.BINDING.getFrame(binding), value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)"})
        public Object localVariableSetUncached(DynamicObject binding, DynamicObject symbol, Object value) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)Layouts.SYMBOL.getString(symbol));
            frame.setObject(frameSlot, value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "isLastLine(symbol)"})
        public Object localVariableSetLastLine(DynamicObject binding, DynamicObject symbol, Object value) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)Layouts.SYMBOL.getString(symbol));
            frame.setObject(frameSlot, (Object)ThreadLocalObject.wrap(this.getContext(), value));
            return value;
        }

        protected FrameDescriptor getFrameDescriptor(DynamicObject binding) {
            assert (RubyGuards.isRubyBinding(binding));
            return Layouts.BINDING.getFrame(binding).getFrameDescriptor();
        }

        protected FrameSlot findFrameSlot(DynamicObject binding, DynamicObject symbol) {
            assert (RubyGuards.isRubyBinding(binding));
            assert (RubyGuards.isRubySymbol(symbol));
            String symbolString = Layouts.SYMBOL.getString(symbol);
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            while (frame != null) {
                FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbolString);
                if (frameSlot != null) {
                    return frameSlot;
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return Layouts.BINDING.getFrame(binding).getFrameDescriptor().addFrameSlot((Object)symbolString);
        }

        protected WriteFrameSlotNode createWriteNode(FrameSlot frameSlot) {
            return WriteFrameSlotNodeGen.create(frameSlot);
        }

        protected boolean isLastLine(DynamicObject symbol) {
            return symbol == this.dollarUnderscore;
        }
    }

    @CoreMethod(names={"local_variable_get"}, required=1)
    public static abstract class LocalVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        private final DynamicObject dollarUnderscore = this.getSymbol("$_");

        public LocalVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "symbol == cachedSymbol", "!isLastLine(cachedSymbol)", "getFrameDescriptor(binding) == cachedFrameDescriptor"})
        public Object localVariableGetCached(DynamicObject binding, DynamicObject symbol, @Cached(value="symbol") DynamicObject cachedSymbol, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="findFrameSlot(binding, symbol)") FrameSlot cachedFrameSlot, @Cached(value="createReadNode(cachedFrameSlot)") ReadFrameSlotNode readLocalVariableNode) {
            if (cachedFrameSlot == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(Layouts.SYMBOL.getString(symbol), binding, this));
            }
            return readLocalVariableNode.executeRead((Frame)Layouts.BINDING.getFrame(binding));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)"})
        public Object localVariableGetUncached(DynamicObject binding, DynamicObject symbol) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)Layouts.SYMBOL.getString(symbol));
            if (frameSlot == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(Layouts.SYMBOL.getString(symbol), binding, this));
            }
            return frame.getValue(frameSlot);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "isLastLine(symbol)"})
        public Object localVariableGetLastLine(DynamicObject binding, DynamicObject symbol) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)Layouts.SYMBOL.getString(symbol));
            if (frameSlot == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(Layouts.SYMBOL.getString(symbol), binding, this));
            }
            Object value = frame.getValue(frameSlot);
            if (value instanceof ThreadLocalObject) {
                return ((ThreadLocalObject)value).get();
            }
            return value;
        }

        protected FrameDescriptor getFrameDescriptor(DynamicObject binding) {
            assert (RubyGuards.isRubyBinding(binding));
            return Layouts.BINDING.getFrame(binding).getFrameDescriptor();
        }

        protected FrameSlot findFrameSlot(DynamicObject binding, DynamicObject symbol) {
            assert (RubyGuards.isRubyBinding(binding));
            assert (RubyGuards.isRubySymbol(symbol));
            String symbolString = Layouts.SYMBOL.getString(symbol);
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            while (frame != null) {
                FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbolString);
                if (frameSlot != null) {
                    return frameSlot;
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return null;
        }

        protected ReadFrameSlotNode createReadNode(FrameSlot frameSlot) {
            if (frameSlot == null) {
                return null;
            }
            return ReadFrameSlotNodeGen.create(frameSlot);
        }

        protected boolean isLastLine(DynamicObject symbol) {
            return symbol == this.dollarUnderscore;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyBinding(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            Object[] arguments = Layouts.BINDING.getFrame(from).getArguments();
            InternalMethod method = RubyArguments.getMethod(arguments);
            Object boundSelf = RubyArguments.getSelf(arguments);
            DynamicObject boundBlock = RubyArguments.getBlock(arguments);
            Object[] userArguments = RubyArguments.extractUserArguments(arguments);
            Object[] copiedArguments = RubyArguments.pack(method, Layouts.BINDING.getFrame(from), boundSelf, boundBlock, userArguments);
            MaterializedFrame copiedFrame = Truffle.getRuntime().createMaterializedFrame(copiedArguments);
            Layouts.BINDING.setSelf(self, Layouts.BINDING.getSelf(from));
            Layouts.BINDING.setFrame(self, copiedFrame);
            return self;
        }
    }
}

