/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.conversion;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToSymbolNode
extends RubyNode {
    public ToSymbolNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeRubySymbol(VirtualFrame var1, Object var2);

    @Specialization(guards={"isRubySymbol(symbol)"})
    protected DynamicObject toSymbolSymbol(DynamicObject symbol) {
        return symbol;
    }

    @Specialization(guards={"isRubyString(string)"})
    protected DynamicObject toSymbolString(DynamicObject string) {
        return this.getSymbol(Layouts.STRING.getByteList(string));
    }

    @Specialization
    protected DynamicObject toSymbol(String string) {
        return this.getSymbol(string);
    }
}

