/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;

public class RubyConstant {
    private final RubyModule declaringModule;
    private final Object value;
    private boolean isPrivate;
    private final boolean autoload;

    public RubyConstant(RubyModule declaringModule, Object value, boolean isPrivate, boolean autoload) {
        this.declaringModule = declaringModule;
        this.value = value;
        this.isPrivate = isPrivate;
        this.autoload = autoload;
    }

    public RubyModule getDeclaringModule() {
        return this.declaringModule;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public boolean isVisibleTo(RubyContext context, LexicalScope lexicalScope, RubyModule module) {
        CompilerAsserts.neverPartOfCompilation();
        assert (lexicalScope == null || lexicalScope.getLiveModule() == module);
        if (!this.isPrivate) {
            return true;
        }
        if (lexicalScope != null) {
            while (lexicalScope != context.getRootLexicalScope()) {
                if (lexicalScope.getLiveModule() == this.declaringModule) {
                    return true;
                }
                lexicalScope = lexicalScope.getParent();
            }
        }
        if (module instanceof RubyClass) {
            for (RubyModule included : module.parentAncestors()) {
                if (included != this.declaringModule) continue;
                return true;
            }
        }
        return lexicalScope != null && context.getCoreLibrary().getObjectClass() == this.declaringModule;
    }

    public boolean isAutoload() {
        return this.autoload;
    }
}

