/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.hash.HashGuards;
import org.jruby.truffle.nodes.core.hash.HashNode;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.nodes.core.hash.LookupEntryNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashLookupResult;
import org.jruby.truffle.runtime.hash.PackedArrayStrategy;

@ImportStatic(value={HashGuards.class})
@NodeChildren(value={@NodeChild(value="hash", type=RubyNode.class), @NodeChild(value="key", type=RubyNode.class), @NodeChild(value="value", type=RubyNode.class), @NodeChild(value="byIdentity", type=RubyNode.class)})
public abstract class SetNode
extends RubyNode {
    @Node.Child
    private HashNode hashNode;
    @Node.Child
    private CallDispatchHeadNode eqlNode;
    @Node.Child
    private BasicObjectNodes.ReferenceEqualNode equalNode;
    @Node.Child
    private LookupEntryNode lookupEntryNode;
    private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile extendProfile = BranchProfile.create();
    private final ConditionProfile strategyProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile foundProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile bucketCollisionProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile appendingProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile resizeProfile = ConditionProfile.createBinaryProfile();

    public SetNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = new HashNode(context, sourceSection);
        this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
    }

    public abstract Object executeSet(VirtualFrame var1, RubyBasicObject var2, Object var3, Object var4, boolean var5);

    @Specialization(guards={"isNullHash(hash)", "!isRubyString(key)"})
    public Object setNull(VirtualFrame frame, RubyBasicObject hash, Object key, Object value, boolean byIdentity) {
        HashNodes.setStore(hash, PackedArrayStrategy.createStore(this.hashNode.hash(frame, key), key, value), 1, null, null);
        assert (HashNodes.verifyStore(hash));
        return value;
    }

    @Specialization(guards={"isNullHash(hash)", "byIdentity", "isRubyString(key)"})
    public Object setNullByIdentity(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject key, Object value, boolean byIdentity) {
        return this.setNull(frame, hash, key, value, byIdentity);
    }

    @Specialization(guards={"isNullHash(hash)", "!byIdentity", "isRubyString(key)"})
    public Object setNullNotByIdentity(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject key, Object value, boolean byIdentity) {
        return this.setNull(frame, hash, this.ruby(frame, "key.frozen? ? key : key.dup.freeze", "key", key), value, byIdentity);
    }

    @ExplodeLoop
    @Specialization(guards={"isPackedHash(hash)", "!isRubyString(key)"})
    public Object setPackedArray(VirtualFrame frame, RubyBasicObject hash, Object key, Object value, boolean byIdentity) {
        assert (HashNodes.verifyStore(hash));
        int hashed = this.hashNode.hash(frame, key);
        Object[] store = (Object[])HashNodes.getStore(hash);
        int size = HashNodes.getSize(hash);
        for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
            boolean equal;
            if (n >= size || hashed != PackedArrayStrategy.getHashed(store, n) || !(equal = this.byIdentityProfile.profile(byIdentity) ? this.equalNode.executeReferenceEqual(frame, key, PackedArrayStrategy.getKey(store, n)) : this.eqlNode.callBoolean(frame, key, "eql?", null, PackedArrayStrategy.getKey(store, n)))) continue;
            PackedArrayStrategy.setValue(store, n, value);
            assert (HashNodes.verifyStore(hash));
            return value;
        }
        this.extendProfile.enter();
        if (this.strategyProfile.profile(size + 1 <= PackedArrayStrategy.MAX_ENTRIES)) {
            PackedArrayStrategy.setHashedKeyValue(store, size, hashed, key, value);
            HashNodes.setSize(hash, size + 1);
            return value;
        }
        PackedArrayStrategy.promoteToBuckets(hash, store, size);
        BucketsStrategy.addNewEntry(hash, hashed, key, value);
        assert (HashNodes.verifyStore(hash));
        return value;
    }

    @Specialization(guards={"isPackedHash(hash)", "byIdentity", "isRubyString(key)"})
    public Object setPackedArrayByIdentity(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject key, Object value, boolean byIdentity) {
        return this.setPackedArray(frame, hash, key, value, byIdentity);
    }

    @Specialization(guards={"isPackedHash(hash)", "!byIdentity", "isRubyString(key)"})
    public Object setPackedArrayNotByIdentity(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject key, Object value, boolean byIdentity) {
        return this.setPackedArray(frame, hash, this.ruby(frame, "key.frozen? ? key : key.dup.freeze", "key", key), value, byIdentity);
    }

    @Specialization(guards={"isBucketHash(hash)", "!isRubyString(key)"})
    public Object setBuckets(VirtualFrame frame, RubyBasicObject hash, Object key, Object value, boolean byIdentity) {
        HashLookupResult result;
        Entry entry;
        assert (HashNodes.verifyStore(hash));
        if (this.lookupEntryNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupEntryNode = (LookupEntryNode)this.insert(new LookupEntryNode(this.getContext(), this.getEncapsulatingSourceSection()));
        }
        if (this.foundProfile.profile((entry = (result = this.lookupEntryNode.lookup(frame, hash, key)).getEntry()) == null)) {
            Entry[] entries = (Entry[])HashNodes.getStore(hash);
            Entry newEntry = new Entry(result.getHashed(), key, value);
            if (this.bucketCollisionProfile.profile(result.getPreviousEntry() == null)) {
                entries[result.getIndex()] = newEntry;
            } else {
                result.getPreviousEntry().setNextInLookup(newEntry);
            }
            Entry lastInSequence = HashNodes.getLastInSequence(hash);
            if (this.appendingProfile.profile(lastInSequence == null)) {
                HashNodes.setFirstInSequence(hash, newEntry);
            } else {
                lastInSequence.setNextInSequence(newEntry);
                newEntry.setPreviousInSequence(lastInSequence);
            }
            HashNodes.setLastInSequence(hash, newEntry);
            int newSize = HashNodes.getSize(hash) + 1;
            HashNodes.setSize(hash, newSize);
            if (this.resizeProfile.profile((double)newSize / (double)entries.length > 0.75)) {
                BucketsStrategy.resize(hash);
            }
        } else {
            entry.setKeyValue(result.getHashed(), key, value);
        }
        assert (HashNodes.verifyStore(hash));
        return value;
    }

    @Specialization(guards={"isBucketHash(hash)", "byIdentity", "isRubyString(key)"})
    public Object setBucketsByIdentity(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject key, Object value, boolean byIdentity) {
        return this.setBuckets(frame, hash, key, value, byIdentity);
    }

    @Specialization(guards={"isBucketHash(hash)", "!byIdentity", "isRubyString(key)"})
    public Object setBucketsNotByIdentity(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject key, Object value, boolean byIdentity) {
        return this.setBuckets(frame, hash, this.ruby(frame, "key.frozen? ? key : key.dup.freeze", "key", key), value, byIdentity);
    }
}

