/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.hash.HashGuards;
import org.jruby.truffle.nodes.core.hash.HashNode;
import org.jruby.truffle.nodes.core.hash.HashNodesFactory;
import org.jruby.truffle.nodes.core.hash.LookupEntryNode;
import org.jruby.truffle.nodes.core.hash.SetNode;
import org.jruby.truffle.nodes.core.hash.SetNodeGen;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashLookupResult;
import org.jruby.truffle.runtime.hash.PackedArrayStrategy;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.object.BasicObjectType;

@CoreClass(name="Hash")
public abstract class HashNodes {
    public static final HashType HASH_TYPE = new HashType();
    private static final DynamicObjectFactory HASH_FACTORY;

    public static int slowHashKey(RubyContext context, Object key) {
        Object hashValue = DebugOperations.send(context, key, "hash", null, new Object[0]);
        if (hashValue instanceof Integer) {
            return (Integer)hashValue;
        }
        if (hashValue instanceof Long) {
            return (int)((Long)hashValue).longValue();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean slowAreKeysEqual(RubyContext context, Object a, Object b, boolean byIdentity) {
        String method = byIdentity ? "equal?" : "eql?";
        Object equalityResult = DebugOperations.send(context, a, method, null, b);
        if (equalityResult instanceof Boolean) {
            return (Boolean)equalityResult;
        }
        throw new UnsupportedOperationException();
    }

    public static boolean verifyStore(RubyBasicObject hash) {
        return HashNodes.verifyStore(HashNodes.getStore(hash), HashNodes.getSize(hash), HashNodes.getFirstInSequence(hash), HashNodes.getLastInSequence(hash));
    }

    public static boolean verifyStore(Object store, int size, Entry firstInSequence, Entry lastInSequence) {
        assert (store == null || store instanceof Object[] || store instanceof Entry[]);
        if (store == null) {
            assert (size == 0);
            assert (firstInSequence == null);
            assert (lastInSequence == null);
        }
        if (store instanceof Entry[]) {
            Entry entry;
            assert (lastInSequence == null || lastInSequence.getNextInSequence() == null);
            Entry[] entryStore = (Entry[])store;
            Entry foundFirst = null;
            Entry foundLast = null;
            int foundSizeBuckets = 0;
            for (int n = 0; n < entryStore.length; ++n) {
                for (entry = entryStore[n]; entry != null; entry = entry.getNextInLookup()) {
                    ++foundSizeBuckets;
                    if (entry == firstInSequence) {
                        assert (foundFirst == null);
                        foundFirst = entry;
                    }
                    if (entry != lastInSequence) continue;
                    assert (foundLast == null);
                    foundLast = entry;
                }
            }
            assert (foundSizeBuckets == size);
            assert (firstInSequence == foundFirst);
            assert (lastInSequence == foundLast);
            int foundSizeSequence = 0;
            for (entry = firstInSequence; entry != null; entry = entry.getNextInSequence()) {
                ++foundSizeSequence;
                if (entry.getNextInSequence() == null ? !$assertionsDisabled && entry != lastInSequence : !$assertionsDisabled && entry.getNextInSequence().getPreviousInSequence() != entry) {
                    throw new AssertionError();
                }
            }
            assert (foundSizeSequence == size) : String.format("%d %d", foundSizeSequence, size);
        } else if (store instanceof Object[]) {
            assert (((Object[])store).length == PackedArrayStrategy.MAX_ENTRIES * 3) : ((Object[])store).length;
            Object[] packedStore = (Object[])store;
            for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                if (n >= size) continue;
                assert (packedStore[n * 2] != null);
                assert (packedStore[n * 2 + 1] != null);
            }
            assert (firstInSequence == null);
            assert (lastInSequence == null);
        }
        return true;
    }

    public static RubyBasicObject getDefaultBlock(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return ((RubyHash)hash).defaultBlock;
    }

    public static void setDefaultBlock(RubyBasicObject hash, RubyBasicObject defaultBlock) {
        assert (RubyGuards.isRubyHash(hash));
        ((RubyHash)hash).defaultBlock = defaultBlock;
    }

    public static Object getDefaultValue(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return ((RubyHash)hash).defaultValue;
    }

    public static void setDefaultValue(RubyBasicObject hash, Object defaultValue) {
        assert (RubyGuards.isRubyHash(hash));
        ((RubyHash)hash).defaultValue = defaultValue;
    }

    public static boolean isCompareByIdentity(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return ((RubyHash)hash).compareByIdentity;
    }

    public static void setCompareByIdentity(RubyBasicObject hash, boolean compareByIdentity) {
        assert (RubyGuards.isRubyHash(hash));
        ((RubyHash)hash).compareByIdentity = compareByIdentity;
    }

    public static Object getStore(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return ((RubyHash)hash).store;
    }

    public static void setStore(RubyBasicObject hash, Object store, int size, Entry firstInSequence, Entry lastInSequence) {
        assert (RubyGuards.isRubyHash(hash));
        assert (HashNodes.verifyStore(store, size, firstInSequence, lastInSequence));
        ((RubyHash)hash).store = store;
        ((RubyHash)hash).size = size;
        ((RubyHash)hash).firstInSequence = firstInSequence;
        ((RubyHash)hash).lastInSequence = lastInSequence;
    }

    public static int getSize(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return ((RubyHash)hash).size;
    }

    public static void setSize(RubyBasicObject hash, int storeSize) {
        assert (RubyGuards.isRubyHash(hash));
        ((RubyHash)hash).size = storeSize;
    }

    public static Entry getFirstInSequence(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return ((RubyHash)hash).firstInSequence;
    }

    public static void setFirstInSequence(RubyBasicObject hash, Entry firstInSequence) {
        assert (RubyGuards.isRubyHash(hash));
        ((RubyHash)hash).firstInSequence = firstInSequence;
    }

    public static Entry getLastInSequence(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return ((RubyHash)hash).lastInSequence;
    }

    public static void setLastInSequence(RubyBasicObject hash, Entry lastInSequence) {
        assert (RubyGuards.isRubyHash(hash));
        ((RubyHash)hash).lastInSequence = lastInSequence;
    }

    public static RubyBasicObject createEmptyHash(RubyClass hashClass) {
        return HashNodes.createHash(hashClass, null, null, null, 0, null, null);
    }

    public static RubyBasicObject createHash(RubyClass hashClass, Object[] store, int size) {
        return HashNodes.createHash(hashClass, null, null, store, size, null, null);
    }

    public static RubyBasicObject createHash(RubyClass hashClass, RubyBasicObject defaultBlock, Object defaultValue, Object store, int size, Entry firstInSequence, Entry lastInSequence) {
        return new RubyHash(hashClass, defaultBlock, defaultValue, store, size, firstInSequence, lastInSequence, HASH_FACTORY.newInstance(new Object[0]));
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterator<Map.Entry<Object, Object>> iterateKeyValues(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        if (HashGuards.isNullHash(hash)) {
            return Collections.emptyIterator();
        }
        if (HashGuards.isPackedHash(hash)) {
            return PackedArrayStrategy.iterateKeyValues((Object[])HashNodes.getStore(hash), HashNodes.getSize(hash));
        }
        if (HashGuards.isBucketHash(hash)) {
            return BucketsStrategy.iterateKeyValues(HashNodes.getFirstInSequence(hash));
        }
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterable<Map.Entry<Object, Object>> iterableKeyValues(final RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return new Iterable<Map.Entry<Object, Object>>(){

            @Override
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return HashNodes.iterateKeyValues(hash);
            }
        };
    }

    static {
        Shape shape = RubyBasicObject.LAYOUT.createShape((ObjectType)HASH_TYPE);
        HASH_FACTORY = shape.createFactory();
    }

    public static class HashAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return HashNodes.createEmptyHash(rubyClass);
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="defaultProc")})
    public static abstract class SetDefaultProcNode
    extends CoreMethodNode {
        public SetDefaultProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyProc(defaultProc)"})
        public RubyBasicObject setDefaultProc(RubyBasicObject hash, RubyBasicObject defaultProc) {
            HashNodes.setDefaultValue(hash, null);
            HashNodes.setDefaultBlock(hash, defaultProc);
            return defaultProc;
        }

        @Specialization(guards={"isNil(nil)"})
        public RubyBasicObject setDefaultProc(RubyBasicObject hash, Object nil) {
            HashNodes.setDefaultValue(hash, null);
            HashNodes.setDefaultBlock(hash, null);
            return this.nil();
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="defaultValue")})
    public static abstract class SetDefaultValueNode
    extends CoreMethodNode {
        public SetDefaultValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setDefaultValue(RubyBasicObject hash, Object defaultValue) {
            HashNodes.setDefaultValue(hash, defaultValue);
            return defaultValue;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class DefaultValueNode
    extends CoreMethodNode {
        public DefaultValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object defaultValue(RubyBasicObject hash) {
            Object value = HashNodes.getDefaultValue(hash);
            if (value == null) {
                return this.nil();
            }
            return value;
        }
    }

    @CoreMethod(names={"rehash"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class RehashNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private HashNode hashNode;

        public RehashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = new HashNode(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public RubyBasicObject rehashNull(RubyBasicObject hash) {
            return hash;
        }

        @Specialization(guards={"isPackedHash(hash)"})
        public RubyBasicObject rehashPackedArray(VirtualFrame frame, RubyBasicObject hash) {
            assert (HashNodes.verifyStore(hash));
            Object[] store = (Object[])HashNodes.getStore(hash);
            int size = HashNodes.getSize(hash);
            for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                if (n >= size) continue;
                PackedArrayStrategy.setHashed(store, n, this.hashNode.hash(frame, PackedArrayStrategy.getKey(store, n)));
            }
            assert (HashNodes.verifyStore(hash));
            return hash;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isBucketHash(hash)"})
        public RubyBasicObject rehashBuckets(RubyBasicObject hash) {
            assert (HashNodes.verifyStore(hash));
            Object[] entries = (Entry[])HashNodes.getStore(hash);
            Arrays.fill(entries, null);
            for (Entry entry = HashNodes.getFirstInSequence(hash); entry != null; entry = entry.getNextInSequence()) {
                int index = BucketsStrategy.getBucketIndex(entry.getHashed(), entries.length);
                Object bucketEntry = entries[index];
                if (bucketEntry == null) {
                    entries[index] = entry;
                    continue;
                }
                while (((Entry)bucketEntry).getNextInLookup() != null) {
                    bucketEntry = ((Entry)bucketEntry).getNextInLookup();
                }
                ((Entry)bucketEntry).setNextInLookup(entry);
            }
            assert (HashNodes.verifyStore(hash));
            return hash;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={HashGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public int sizeNull(RubyBasicObject hash) {
            return 0;
        }

        @Specialization(guards={"!isNullHash(hash)"})
        public int sizePackedArray(RubyBasicObject hash) {
            return HashNodes.getSize(hash);
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ShiftNode
    extends CoreMethodArrayArgumentsNode {
        public ShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isEmptyHash(hash)", "!hasDefaultValue(hash)", "!hasDefaultBlock(hash)"})
        public RubyBasicObject shiftEmpty(RubyBasicObject hash) {
            return this.nil();
        }

        @Specialization(guards={"isEmptyHash(hash)", "hasDefaultValue(hash)", "!hasDefaultBlock(hash)"})
        public Object shiftEmpyDefaultValue(RubyBasicObject hash) {
            return HashNodes.getDefaultValue(hash);
        }

        @Specialization(guards={"isEmptyHash(hash)", "!hasDefaultValue(hash)", "hasDefaultBlock(hash)"})
        public Object shiftEmptyDefaultProc(RubyBasicObject hash) {
            return ProcNodes.rootCall(HashNodes.getDefaultBlock(hash), hash, this.nil());
        }

        @Specialization(guards={"!isEmptyHash(hash)", "isPackedHash(hash)"})
        public RubyBasicObject shiftPackedArray(RubyBasicObject hash) {
            assert (HashNodes.verifyStore(hash));
            Object[] store = (Object[])HashNodes.getStore(hash);
            Object key = PackedArrayStrategy.getKey(store, 0);
            Object value = PackedArrayStrategy.getValue(store, 0);
            PackedArrayStrategy.removeEntry(store, 0);
            HashNodes.setSize(hash, HashNodes.getSize(hash) - 1);
            assert (HashNodes.verifyStore(hash));
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), key, value);
        }

        @Specialization(guards={"!isEmptyHash(hash)", "isBucketHash(hash)"})
        public RubyBasicObject shiftBuckets(RubyBasicObject hash) {
            assert (HashNodes.verifyStore(hash));
            Entry first = HashNodes.getFirstInSequence(hash);
            assert (first.getPreviousInSequence() == null);
            Object key = first.getKey();
            Object value = first.getValue();
            HashNodes.setFirstInSequence(hash, first.getNextInSequence());
            if (first.getNextInSequence() != null) {
                first.getNextInSequence().setPreviousInSequence(null);
                HashNodes.setFirstInSequence(hash, first.getNextInSequence());
            }
            if (HashNodes.getLastInSequence(hash) == first) {
                HashNodes.setLastInSequence(hash, null);
            }
            Entry[] store = (Entry[])HashNodes.getStore(hash);
            block0: for (int n = 0; n < store.length; ++n) {
                Entry previous = null;
                for (Entry entry = store[n]; entry != null; entry = entry.getNextInLookup()) {
                    if (entry == first) {
                        if (previous == null) {
                            store[n] = first.getNextInLookup();
                            break block0;
                        }
                        previous.setNextInLookup(first.getNextInLookup());
                        break block0;
                    }
                    previous = entry;
                }
            }
            HashNodes.setSize(hash, HashNodes.getSize(hash) - 1);
            assert (HashNodes.verifyStore(hash));
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), key, value);
        }
    }

    @CoreMethod(names={"default="}, required=1)
    public static abstract class SetDefaultNode
    extends CoreMethodArrayArgumentsNode {
        public SetDefaultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setDefault(VirtualFrame frame, RubyBasicObject hash, Object defaultValue) {
            this.ruby(frame, "Rubinius.check_frozen", new Object[0]);
            HashNodes.setDefaultValue(hash, defaultValue);
            HashNodes.setDefaultBlock(hash, null);
            return defaultValue;
        }
    }

    @ImportStatic(value={HashGuards.class})
    @CoreMethod(names={"merge"}, required=1, needsBlock=true)
    public static abstract class MergeNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;
        @Node.Child
        private LookupEntryNode lookupEntryNode;
        @Node.Child
        private SetNode setNode;
        private final BranchProfile nothingFromFirstProfile = BranchProfile.create();
        private final BranchProfile considerNothingFromSecondProfile = BranchProfile.create();
        private final BranchProfile nothingFromSecondProfile = BranchProfile.create();
        private final BranchProfile considerResultIsSmallProfile = BranchProfile.create();
        private final BranchProfile resultIsSmallProfile = BranchProfile.create();
        private final BranchProfile promoteProfile = BranchProfile.create();

        public MergeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.setNode = SetNodeGen.create(context, sourceSection, null, null, null, null);
        }

        @Specialization(guards={"isNullHash(hash)", "isRubyHash(other)", "isNullHash(other)"})
        public RubyBasicObject mergeEmptyEmpty(RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            return HashNodes.createHash(hash.getLogicalClass(), HashNodes.getDefaultBlock(hash), HashNodes.getDefaultValue(hash), null, 0, null, null);
        }

        @Specialization(guards={"isEmptyHash(hash)", "isRubyHash(other)", "isPackedHash(other)"})
        public RubyBasicObject mergeEmptyPacked(RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            Object[] store = (Object[])HashNodes.getStore(other);
            Object[] copy = PackedArrayStrategy.copyStore(store);
            return HashNodes.createHash(hash.getLogicalClass(), HashNodes.getDefaultBlock(hash), HashNodes.getDefaultValue(hash), copy, HashNodes.getSize(other), null, null);
        }

        @Specialization(guards={"isPackedHash(hash)", "isRubyHash(other)", "isEmptyHash(other)"})
        public RubyBasicObject mergePackedEmpty(RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            Object[] store = (Object[])HashNodes.getStore(hash);
            Object[] copy = PackedArrayStrategy.copyStore(store);
            return HashNodes.createHash(hash.getLogicalClass(), HashNodes.getDefaultBlock(hash), HashNodes.getDefaultValue(hash), copy, HashNodes.getSize(hash), null, null);
        }

        @Specialization(guards={"isEmptyHash(hash)", "isRubyHash(other)", "isBucketHash(other)"})
        public RubyBasicObject mergeEmptyBuckets(RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            RubyBasicObject merged = HashNodes.createHash(hash.getLogicalClass(), HashNodes.getDefaultBlock(hash), HashNodes.getDefaultValue(hash), null, 0, null, null);
            BucketsStrategy.copyInto(other, merged);
            return merged;
        }

        @Specialization(guards={"isBucketHash(hash)", "isRubyHash(other)", "isEmptyHash(other)"})
        public RubyBasicObject mergeBucketsEmpty(RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            RubyBasicObject merged = HashNodes.createHash(hash.getLogicalClass(), HashNodes.getDefaultBlock(hash), HashNodes.getDefaultValue(hash), null, 0, null, null);
            BucketsStrategy.copyInto(hash, merged);
            return merged;
        }

        @ExplodeLoop
        @Specialization(guards={"isPackedHash(hash)", "!isEmptyHash(hash)", "isRubyHash(other)", "isPackedHash(other)", "!isEmptyHash(other)", "!isCompareByIdentity(hash)"})
        public RubyBasicObject mergePackedPacked(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            int n;
            assert (HashNodes.verifyStore(hash));
            assert (HashNodes.verifyStore(other));
            Object[] storeA = (Object[])HashNodes.getStore(hash);
            int storeASize = HashNodes.getSize(hash);
            Object[] storeB = (Object[])HashNodes.getStore(other);
            int storeBSize = HashNodes.getSize(other);
            boolean[] mergeFromA = new boolean[storeASize];
            int mergeFromACount = 0;
            int conflictsCount = 0;
            for (int a = 0; a < PackedArrayStrategy.MAX_ENTRIES; ++a) {
                if (a >= storeASize) continue;
                boolean merge = true;
                for (int b = 0; b < PackedArrayStrategy.MAX_ENTRIES; ++b) {
                    if (b >= storeBSize || !this.eqlNode.callBoolean(frame, PackedArrayStrategy.getKey(storeA, a), "eql?", null, PackedArrayStrategy.getKey(storeB, b))) continue;
                    ++conflictsCount;
                    merge = false;
                    break;
                }
                if (merge) {
                    ++mergeFromACount;
                }
                mergeFromA[a] = merge;
            }
            if (mergeFromACount == 0) {
                this.nothingFromFirstProfile.enter();
                return HashNodes.createHash(hash.getLogicalClass(), HashNodes.getDefaultBlock(hash), HashNodes.getDefaultValue(hash), PackedArrayStrategy.copyStore(storeB), storeBSize, null, null);
            }
            this.considerNothingFromSecondProfile.enter();
            if (conflictsCount == storeBSize) {
                this.nothingFromSecondProfile.enter();
                return HashNodes.createHash(hash.getLogicalClass(), HashNodes.getDefaultBlock(hash), HashNodes.getDefaultValue(hash), PackedArrayStrategy.copyStore(storeA), storeASize, null, null);
            }
            this.considerResultIsSmallProfile.enter();
            int mergedSize = storeBSize + mergeFromACount;
            if (storeBSize + mergeFromACount <= PackedArrayStrategy.MAX_ENTRIES) {
                int n2;
                this.resultIsSmallProfile.enter();
                Object[] merged = PackedArrayStrategy.createStore();
                int index = 0;
                for (n2 = 0; n2 < storeASize; ++n2) {
                    if (!mergeFromA[n2]) continue;
                    PackedArrayStrategy.setHashedKeyValue(merged, index, PackedArrayStrategy.getHashed(storeA, n2), PackedArrayStrategy.getKey(storeA, n2), PackedArrayStrategy.getValue(storeA, n2));
                    ++index;
                }
                for (n2 = 0; n2 < storeBSize; ++n2) {
                    PackedArrayStrategy.setHashedKeyValue(merged, index, PackedArrayStrategy.getHashed(storeB, n2), PackedArrayStrategy.getKey(storeB, n2), PackedArrayStrategy.getValue(storeB, n2));
                    ++index;
                }
                return HashNodes.createHash(hash.getLogicalClass(), HashNodes.getDefaultBlock(hash), HashNodes.getDefaultValue(hash), merged, mergedSize, null, null);
            }
            this.promoteProfile.enter();
            RubyBasicObject merged = HashNodes.createHash(hash.getLogicalClass(), null, null, new Entry[BucketsStrategy.capacityGreaterThan(mergedSize)], 0, null, null);
            for (n = 0; n < storeASize; ++n) {
                if (!mergeFromA[n]) continue;
                this.setNode.executeSet(frame, merged, PackedArrayStrategy.getKey(storeA, n), PackedArrayStrategy.getValue(storeA, n), false);
            }
            for (n = 0; n < storeBSize; ++n) {
                this.setNode.executeSet(frame, merged, PackedArrayStrategy.getKey(storeB, n), PackedArrayStrategy.getValue(storeB, n), false);
            }
            assert (HashNodes.verifyStore(hash));
            return merged;
        }

        @Specialization(guards={"isBucketHash(hash)", "!isEmptyHash(hash)", "isRubyHash(other)", "isBucketHash(other)", "!isEmptyHash(other)"})
        public RubyBasicObject mergeBucketsBuckets(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            boolean isCompareByIdentity = HashNodes.isCompareByIdentity(hash);
            RubyBasicObject merged = HashNodes.createHash(hash.getLogicalClass(), null, null, new Entry[BucketsStrategy.capacityGreaterThan(HashNodes.getSize(hash) + HashNodes.getSize(other))], 0, null, null);
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(HashNodes.getFirstInSequence(hash))) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), isCompareByIdentity);
            }
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(HashNodes.getFirstInSequence(other))) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), isCompareByIdentity);
            }
            assert (HashNodes.verifyStore(hash));
            return merged;
        }

        @Specialization(guards={"isPackedHash(hash)", "!isEmptyHash(hash)", "isRubyHash(other)", "isBucketHash(other)", "!isEmptyHash(other)"})
        public RubyBasicObject mergePackedBuckets(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            boolean isCompareByIdentity = HashNodes.isCompareByIdentity(hash);
            RubyBasicObject merged = HashNodes.createHash(hash.getLogicalClass(), null, null, new Entry[BucketsStrategy.capacityGreaterThan(HashNodes.getSize(hash) + HashNodes.getSize(other))], 0, null, null);
            Object[] hashStore = (Object[])HashNodes.getStore(hash);
            int hashSize = HashNodes.getSize(hash);
            for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                if (n >= hashSize) continue;
                this.setNode.executeSet(frame, merged, PackedArrayStrategy.getKey(hashStore, n), PackedArrayStrategy.getValue(hashStore, n), isCompareByIdentity);
            }
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(HashNodes.getFirstInSequence(other))) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), isCompareByIdentity);
            }
            assert (HashNodes.verifyStore(hash));
            return merged;
        }

        @Specialization(guards={"isBucketHash(hash)", "!isEmptyHash(hash)", "isRubyHash(other)", "isPackedHash(other)", "!isEmptyHash(other)"})
        public RubyBasicObject mergeBucketsPacked(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject other, NotProvided block) {
            boolean isCompareByIdentity = HashNodes.isCompareByIdentity(hash);
            RubyBasicObject merged = HashNodes.createHash(hash.getLogicalClass(), null, null, new Entry[BucketsStrategy.capacityGreaterThan(HashNodes.getSize(hash) + HashNodes.getSize(other))], 0, null, null);
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(HashNodes.getFirstInSequence(hash))) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), isCompareByIdentity);
            }
            Object[] otherStore = (Object[])HashNodes.getStore(other);
            int otherSize = HashNodes.getSize(other);
            for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                if (n >= otherSize) continue;
                this.setNode.executeSet(frame, merged, PackedArrayStrategy.getKey(otherStore, n), PackedArrayStrategy.getValue(otherStore, n), isCompareByIdentity);
            }
            assert (HashNodes.verifyStore(hash));
            return merged;
        }

        @Specialization(guards={"isRubyHash(other)", "!isCompareByIdentity(hash)", "isRubyProc(block)"})
        public RubyBasicObject merge(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject other, RubyBasicObject block) {
            CompilerDirectives.bailout((String)"Hash#merge with a block cannot be compiled at the moment");
            RubyBasicObject merged = HashNodes.createHash(hash.getLogicalClass(), null, null, new Entry[BucketsStrategy.capacityGreaterThan(HashNodes.getSize(hash) + HashNodes.getSize(other))], 0, null, null);
            int size = 0;
            for (Map.Entry<Object, Object> keyValue : HashNodes.iterableKeyValues(hash)) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), false);
                ++size;
            }
            if (this.lookupEntryNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.lookupEntryNode = (LookupEntryNode)this.insert(new LookupEntryNode(this.getContext(), this.getSourceSection()));
            }
            for (Map.Entry<Object, Object> keyValue : HashNodes.iterableKeyValues(other)) {
                HashLookupResult searchResult = this.lookupEntryNode.lookup(frame, merged, keyValue.getKey());
                if (searchResult.getEntry() == null) {
                    this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), false);
                    ++size;
                    continue;
                }
                Object oldValue = searchResult.getEntry().getValue();
                Object newValue = keyValue.getValue();
                Object mergedValue = this.yield(frame, block, keyValue.getKey(), oldValue, newValue);
                this.setNode.executeSet(frame, merged, keyValue.getKey(), mergedValue, false);
            }
            HashNodes.setSize(merged, size);
            assert (HashNodes.verifyStore(hash));
            return merged;
        }

        @Specialization(guards={"!isRubyHash(other)"})
        public Object merge(VirtualFrame frame, RubyBasicObject hash, Object other, Object block) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            RubyBasicObject blockProc = block == NotProvided.INSTANCE ? null : (RubyBasicObject)block;
            return this.fallbackCallNode.call(frame, hash, "merge_fallback", blockProc, other);
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        @Node.Child
        ArrayBuilderNode arrayBuilderNode;

        public MapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)", "isRubyProc(block)"})
        public RubyBasicObject mapNull(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject block) {
            assert (HashNodes.verifyStore(hash));
            return this.createEmptyArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        @Specialization(guards={"isPackedHash(hash)", "isRubyProc(block)"})
        public RubyBasicObject mapPackedArray(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject block) {
            assert (HashNodes.verifyStore(hash));
            if (this.arrayBuilderNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.arrayBuilderNode = (ArrayBuilderNode)this.insert(new ArrayBuilderNode.UninitializedArrayBuilderNode(this.getContext()));
            }
            Object[] store = (Object[])HashNodes.getStore(hash);
            int length = HashNodes.getSize(hash);
            Object resultStore = this.arrayBuilderNode.start(length);
            try {
                for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                    if (n >= length) continue;
                    Object key = PackedArrayStrategy.getKey(store, n);
                    Object value = PackedArrayStrategy.getValue(store, n);
                    resultStore = this.arrayBuilderNode.appendValue(resultStore, n, this.yield(frame, block, key, value));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(length);
                }
            }
            return this.arrayBuilderNode.finishAndCreate(this.getContext().getCoreLibrary().getArrayClass(), resultStore, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isBucketHash(hash)", "isRubyProc(block)"})
        public RubyBasicObject mapBuckets(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject block) {
            assert (HashNodes.verifyStore(hash));
            if (this.arrayBuilderNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.arrayBuilderNode = (ArrayBuilderNode)this.insert(new ArrayBuilderNode.UninitializedArrayBuilderNode(this.getContext()));
            }
            int length = HashNodes.getSize(hash);
            Object store = this.arrayBuilderNode.start(length);
            int index = 0;
            try {
                for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(HashNodes.getFirstInSequence(hash))) {
                    this.arrayBuilderNode.appendValue(store, index, this.yield(frame, block, keyValue.getKey(), keyValue.getValue()));
                    ++index;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(length);
                }
            }
            return this.arrayBuilderNode.finishAndCreate(this.getContext().getCoreLibrary().getArrayClass(), store, length);
        }
    }

    @CoreMethod(names={"initialize_copy", "replace"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyHash(from)", "isNullHash(from)"})
        public RubyBasicObject replaceNull(RubyBasicObject self, RubyBasicObject from) {
            if (self == from) {
                return self;
            }
            HashNodes.setStore(self, null, 0, null, null);
            this.copyOtherFields(self, from);
            return self;
        }

        @Specialization(guards={"isRubyHash(from)", "isPackedHash(from)"})
        public RubyBasicObject replacePackedArray(RubyBasicObject self, RubyBasicObject from) {
            if (self == from) {
                return self;
            }
            Object[] store = (Object[])HashNodes.getStore(from);
            HashNodes.setStore(self, PackedArrayStrategy.copyStore(store), HashNodes.getSize(from), null, null);
            this.copyOtherFields(self, from);
            assert (HashNodes.verifyStore(self));
            return self;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyHash(from)", "isBucketHash(from)"})
        public RubyBasicObject replaceBuckets(RubyBasicObject self, RubyBasicObject from) {
            if (self == from) {
                return self;
            }
            BucketsStrategy.copyInto(from, self);
            this.copyOtherFields(self, from);
            assert (HashNodes.verifyStore(self));
            return self;
        }

        @Specialization(guards={"!isRubyHash(other)"})
        public Object replaceBuckets(VirtualFrame frame, RubyBasicObject self, Object other) {
            return this.ruby(frame, "replace(Rubinius::Type.coerce_to other, Hash, :to_hash)", "other", other);
        }

        private void copyOtherFields(RubyBasicObject self, RubyBasicObject from) {
            HashNodes.setDefaultBlock(self, HashNodes.getDefaultBlock(from));
            HashNodes.setDefaultValue(self, HashNodes.getDefaultValue(from));
            HashNodes.setCompareByIdentity(self, HashNodes.isCompareByIdentity(from));
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject initialize(RubyBasicObject hash, NotProvided defaultValue, NotProvided block) {
            HashNodes.setStore(hash, null, 0, null, null);
            HashNodes.setDefaultValue(hash, null);
            HashNodes.setDefaultBlock(hash, null);
            return hash;
        }

        @Specialization(guards={"isRubyProc(block)"})
        public RubyBasicObject initialize(RubyBasicObject hash, NotProvided defaultValue, RubyBasicObject block) {
            HashNodes.setStore(hash, null, 0, null, null);
            HashNodes.setDefaultValue(hash, null);
            HashNodes.setDefaultBlock(hash, block);
            return hash;
        }

        @Specialization(guards={"wasProvided(defaultValue)"})
        public RubyBasicObject initialize(RubyBasicObject hash, Object defaultValue, NotProvided block) {
            HashNodes.setStore(hash, null, 0, null, null);
            HashNodes.setDefaultValue(hash, defaultValue);
            HashNodes.setDefaultBlock(hash, null);
            return hash;
        }

        @Specialization(guards={"wasProvided(defaultValue)", "isRubyProc(block)"})
        public Object initialize(RubyBasicObject hash, Object defaultValue, RubyBasicObject block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("wrong number of arguments (1 for 0)", this));
        }
    }

    @CoreMethod(names={"empty?"})
    @ImportStatic(value={HashGuards.class})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public boolean emptyNull(RubyBasicObject hash) {
            return true;
        }

        @Specialization(guards={"!isNullHash(hash)"})
        public boolean emptyPackedArray(RubyBasicObject hash) {
            return HashNodes.getSize(hash) == 0;
        }
    }

    @CoreMethod(names={"each", "each_pair"}, needsBlock=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toEnumNode;

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)", "isRubyProc(block)"})
        public RubyBasicObject eachNull(RubyBasicObject hash, RubyBasicObject block) {
            return hash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        @Specialization(guards={"isPackedHash(hash)", "isRubyProc(block)"})
        public RubyBasicObject eachPackedArray(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject block) {
            assert (HashNodes.verifyStore(hash));
            Object[] store = (Object[])HashNodes.getStore(hash);
            int size = HashNodes.getSize(hash);
            int count = 0;
            try {
                for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    if (n >= size) continue;
                    this.yield(frame, block, this.createArray(new Object[]{PackedArrayStrategy.getKey(store, n), PackedArrayStrategy.getValue(store, n)}, 2));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return hash;
        }

        @Specialization(guards={"isBucketHash(hash)", "isRubyProc(block)"})
        public RubyBasicObject eachBuckets(VirtualFrame frame, RubyBasicObject hash, RubyBasicObject block) {
            assert (HashNodes.verifyStore(hash));
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(HashNodes.getFirstInSequence(hash))) {
                this.yield(frame, block, this.createArray(new Object[]{keyValue.getKey(), keyValue.getValue()}, 2));
            }
            return hash;
        }

        @Specialization
        public Object each(VirtualFrame frame, RubyBasicObject hash, NotProvided block) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            InternalMethod method = RubyArguments.getMethod(frame.getArguments());
            return this.toEnumNode.call(frame, hash, "to_enum", null, this.getSymbol(method.getName()));
        }
    }

    @CoreMethod(names={"delete"}, required=1, needsBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class DeleteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private HashNode hashNode;
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private LookupEntryNode lookupEntryNode;
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = new HashNode(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupEntryNode = new LookupEntryNode(context, sourceSection);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public Object deleteNull(VirtualFrame frame, RubyBasicObject hash, Object key, Object block) {
            assert (HashNodes.verifyStore(hash));
            if (block == NotProvided.INSTANCE) {
                return this.nil();
            }
            return this.yieldNode.dispatch(frame, (RubyBasicObject)block, key);
        }

        @Specialization(guards={"isPackedHash(hash)", "!isCompareByIdentity(hash)"})
        public Object deletePackedArray(VirtualFrame frame, RubyBasicObject hash, Object key, Object block) {
            assert (HashNodes.verifyStore(hash));
            int hashed = this.hashNode.hash(frame, key);
            Object[] store = (Object[])HashNodes.getStore(hash);
            int size = HashNodes.getSize(hash);
            for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                if (n >= size || hashed != PackedArrayStrategy.getHashed(store, n) || !this.eqlNode.callBoolean(frame, PackedArrayStrategy.getKey(store, n), "eql?", null, key)) continue;
                Object value = PackedArrayStrategy.getValue(store, n);
                PackedArrayStrategy.removeEntry(store, n);
                HashNodes.setSize(hash, size - 1);
                assert (HashNodes.verifyStore(hash));
                return value;
            }
            assert (HashNodes.verifyStore(hash));
            if (block == NotProvided.INSTANCE) {
                return this.nil();
            }
            return this.yieldNode.dispatch(frame, (RubyBasicObject)block, key);
        }

        @Specialization(guards={"isBucketHash(hash)"})
        public Object delete(VirtualFrame frame, RubyBasicObject hash, Object key, Object block) {
            assert (HashNodes.verifyStore(hash));
            HashLookupResult hashLookupResult = this.lookupEntryNode.lookup(frame, hash, key);
            if (hashLookupResult.getEntry() == null) {
                if (block == NotProvided.INSTANCE) {
                    return this.nil();
                }
                return this.yieldNode.dispatch(frame, (RubyBasicObject)block, key);
            }
            Entry entry = hashLookupResult.getEntry();
            if (entry.getPreviousInSequence() == null) {
                assert (HashNodes.getFirstInSequence(hash) == entry);
                HashNodes.setFirstInSequence(hash, entry.getNextInSequence());
            } else {
                assert (HashNodes.getFirstInSequence(hash) != entry);
                entry.getPreviousInSequence().setNextInSequence(entry.getNextInSequence());
            }
            if (entry.getNextInSequence() == null) {
                HashNodes.setLastInSequence(hash, entry.getPreviousInSequence());
            } else {
                entry.getNextInSequence().setPreviousInSequence(entry.getPreviousInSequence());
            }
            if (hashLookupResult.getPreviousEntry() == null) {
                ((Entry[])HashNodes.getStore((RubyBasicObject)hash))[hashLookupResult.getIndex()] = entry.getNextInLookup();
            } else {
                hashLookupResult.getPreviousEntry().setNextInLookup(entry.getNextInLookup());
            }
            HashNodes.setSize(hash, HashNodes.getSize(hash) - 1);
            assert (HashNodes.verifyStore(hash));
            return entry.getValue();
        }
    }

    @CoreMethod(names={"default_proc"})
    public static abstract class DefaultProcNode
    extends CoreMethodArrayArgumentsNode {
        public DefaultProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object defaultProc(RubyBasicObject hash) {
            if (HashNodes.getDefaultBlock(hash) == null) {
                return this.nil();
            }
            return HashNodes.getDefaultBlock(hash);
        }
    }

    @CoreMethod(names={"compare_by_identity?"})
    public static abstract class IsCompareByIdentityNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile profile = ConditionProfile.createBinaryProfile();

        public IsCompareByIdentityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean compareByIdentity(RubyBasicObject hash) {
            return this.profile.profile(HashNodes.isCompareByIdentity(hash));
        }
    }

    @CoreMethod(names={"compare_by_identity"}, raiseIfFrozenSelf=true)
    public static abstract class CompareByIdentityNode
    extends CoreMethodArrayArgumentsNode {
        public CompareByIdentityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject compareByIdentity(RubyBasicObject hash) {
            HashNodes.setCompareByIdentity(hash, true);
            return hash;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public RubyBasicObject emptyNull(RubyBasicObject hash) {
            return hash;
        }

        @Specialization(guards={"!isNullHash(hash)"})
        public RubyBasicObject empty(RubyBasicObject hash) {
            assert (HashNodes.verifyStore(hash));
            HashNodes.setStore(hash, null, 0, null, null);
            assert (HashNodes.verifyStore(hash));
            return hash;
        }
    }

    @CoreMethod(names={"[]="}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class SetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SetNode setNode;

        public SetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setNull(VirtualFrame frame, RubyBasicObject hash, Object key, Object value) {
            if (this.setNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.setNode = (SetNode)this.insert(SetNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null, null, null, null));
            }
            return this.setNode.executeSet(frame, hash, key, value, HashNodes.isCompareByIdentity(hash));
        }
    }

    @CoreMethod(names={"_get_or_undefined"}, required=1)
    public static abstract class GetOrUndefinedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GetIndexNode getIndexNode;

        public GetOrUndefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.getIndexNode = HashNodesFactory.GetIndexNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
            this.getIndexNode.setUndefinedValue(context.getCoreLibrary().getRubiniusUndefined());
        }

        @Specialization
        public Object getOrUndefined(VirtualFrame frame, RubyBasicObject hash, Object key) {
            return this.getIndexNode.executeGet(frame, hash, key);
        }
    }

    @CoreMethod(names={"[]"}, required=1)
    @ImportStatic(value={HashGuards.class})
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private HashNode hashNode;
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode equalNode;
        @Node.Child
        private CallDispatchHeadNode callDefaultNode;
        @Node.Child
        private LookupEntryNode lookupEntryNode;
        private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile notInHashProfile = BranchProfile.create();
        private final BranchProfile useDefaultProfile = BranchProfile.create();
        @CompilerDirectives.CompilationFinal
        private Object undefinedValue;

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = new HashNode(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
            this.callDefaultNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupEntryNode = new LookupEntryNode(context, sourceSection);
        }

        public abstract Object executeGet(VirtualFrame var1, RubyBasicObject var2, Object var3);

        @Specialization(guards={"isNullHash(hash)"})
        public Object getNull(VirtualFrame frame, RubyBasicObject hash, Object key) {
            this.hashNode.hash(frame, key);
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        @ExplodeLoop
        @Specialization(guards={"isPackedHash(hash)"})
        public Object getPackedArray(VirtualFrame frame, RubyBasicObject hash, Object key) {
            int hashed = this.hashNode.hash(frame, key);
            Object[] store = (Object[])HashNodes.getStore(hash);
            int size = HashNodes.getSize(hash);
            for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                boolean equal;
                if (n >= size || hashed != PackedArrayStrategy.getHashed(store, n) || !(equal = this.byIdentityProfile.profile(HashNodes.isCompareByIdentity(hash)) ? this.equalNode.executeReferenceEqual(frame, key, PackedArrayStrategy.getKey(store, n)) : this.eqlNode.callBoolean(frame, key, "eql?", null, PackedArrayStrategy.getKey(store, n)))) continue;
                return PackedArrayStrategy.getValue(store, n);
            }
            this.notInHashProfile.enter();
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            this.useDefaultProfile.enter();
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        @Specialization(guards={"isBucketHash(hash)"})
        public Object getBuckets(VirtualFrame frame, RubyBasicObject hash, Object key) {
            HashLookupResult hashLookupResult = this.lookupEntryNode.lookup(frame, hash, key);
            if (hashLookupResult.getEntry() != null) {
                return hashLookupResult.getEntry().getValue();
            }
            this.notInHashProfile.enter();
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            this.useDefaultProfile.enter();
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        public void setUndefinedValue(Object undefinedValue) {
            this.undefinedValue = undefinedValue;
        }
    }

    @CoreMethod(names={"[]"}, constructor=true, argumentsAsArray=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ConstructNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private HashNode hashNode;

        public ConstructNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = new HashNode(context, sourceSection);
        }

        @ExplodeLoop
        @Specialization(guards={"isSmallArrayOfPairs(args)"})
        public Object construct(VirtualFrame frame, RubyClass hashClass, Object[] args) {
            RubyBasicObject array = (RubyBasicObject)args[0];
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int size = ArrayNodes.getSize(array);
            Object[] newStore = PackedArrayStrategy.createStore();
            for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                if (n >= size) continue;
                Object pair = store[n];
                if (!RubyGuards.isRubyArray(pair)) {
                    return this.constructFallback(frame, hashClass, args);
                }
                RubyBasicObject pairArray = (RubyBasicObject)pair;
                if (!(ArrayNodes.getStore(pairArray) instanceof Object[])) {
                    return this.constructFallback(frame, hashClass, args);
                }
                Object[] pairStore = (Object[])ArrayNodes.getStore(pairArray);
                Object key = pairStore[0];
                Object value = pairStore[1];
                int hashed = this.hashNode.hash(frame, key);
                PackedArrayStrategy.setHashedKeyValue(newStore, n, hashed, key, value);
            }
            return HashNodes.createHash(hashClass, newStore, size);
        }

        @Specialization
        public Object constructFallback(VirtualFrame frame, RubyClass hashClass, Object[] args) {
            return this.ruby(frame, "_constructor_fallback(*args)", "args", ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), args));
        }

        public static boolean isSmallArrayOfPairs(Object[] args) {
            if (args.length != 1) {
                return false;
            }
            Object arg = args[0];
            if (!RubyGuards.isRubyArray(arg)) {
                return false;
            }
            RubyBasicObject array = (RubyBasicObject)arg;
            if (!(ArrayNodes.getStore(array) instanceof Object[])) {
                return false;
            }
            Object[] store = (Object[])ArrayNodes.getStore(array);
            return store.length <= PackedArrayStrategy.MAX_ENTRIES;
        }
    }

    public static class HashType
    extends BasicObjectType {
    }
}

