/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayDropTailNode
extends RubyNode {
    final int index;

    public ArrayDropTailNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)"})
    public RubyBasicObject getHeadNull(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        return this.createEmptyArray();
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public RubyBasicObject getHeadIntegerFixnum(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((int[])ArrayNodes.getStore(array), 0, ArrayNodes.getSize(array) - this.index), ArrayNodes.getSize(array) - this.index);
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public RubyBasicObject geHeadLongFixnum(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        int size = ArrayNodes.getSize(array) - this.index;
        return this.createArray(ArrayUtils.extractRange((long[])ArrayNodes.getStore(array), 0, size), size);
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public RubyBasicObject getHeadFloat(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        int size = ArrayNodes.getSize(array) - this.index;
        return this.createArray(ArrayUtils.extractRange((double[])ArrayNodes.getStore(array), 0, size), size);
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public RubyBasicObject getHeadObject(RubyBasicObject array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        int size = ArrayNodes.getSize(array) - this.index;
        return this.createArray(ArrayUtils.extractRange((Object[])ArrayNodes.getStore(array), 0, size), size);
    }
}

