/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.cast.ProcOrNullNode;
import org.jruby.truffle.nodes.cast.ProcOrNullNodeGen;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.core.UnboundMethodNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.methods.CallMethodNode;
import org.jruby.truffle.nodes.methods.CallMethodNodeGen;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.nodes.objects.ClassNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.object.BasicObjectType;

@CoreClass(name="Method")
public abstract class MethodNodes {
    public static final MethodType METHOD_TYPE = new MethodType();
    private static final HiddenKey RECEIVER_IDENTIFIER = new HiddenKey("receiver");
    public static final Property RECEIVER_PROPERTY;
    private static final HiddenKey METHOD_IDENTIFIER;
    public static final Property METHOD_PROPERTY;
    private static final DynamicObjectFactory METHOD_FACTORY;

    public static RubyBasicObject createMethod(RubyClass rubyClass, Object receiver, InternalMethod method) {
        return new RubyBasicObject(rubyClass, METHOD_FACTORY.newInstance(new Object[]{receiver, method}));
    }

    public static Object getReceiver(RubyBasicObject method) {
        assert (method.getDynamicObject().getShape().hasProperty((Object)RECEIVER_IDENTIFIER));
        return RECEIVER_PROPERTY.get(method.getDynamicObject(), true);
    }

    public static InternalMethod getMethod(RubyBasicObject method) {
        assert (method.getDynamicObject().getShape().hasProperty((Object)METHOD_IDENTIFIER));
        return (InternalMethod)METHOD_PROPERTY.get(method.getDynamicObject(), true);
    }

    static {
        METHOD_IDENTIFIER = new HiddenKey("method");
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        RECEIVER_PROPERTY = Property.create((Object)RECEIVER_IDENTIFIER, (Location)allocator.locationForType(Object.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        METHOD_PROPERTY = Property.create((Object)METHOD_IDENTIFIER, (Location)allocator.locationForType(InternalMethod.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        Shape shape = RubyBasicObject.LAYOUT.createShape((ObjectType)METHOD_TYPE).addProperty(RECEIVER_PROPERTY).addProperty(METHOD_PROPERTY);
        METHOD_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodArrayArgumentsNode {
        public ToProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toProc(RubyBasicObject methodObject) {
            InternalMethod method = MethodNodes.getMethod(methodObject);
            return ProcNodes.createRubyProc(this.getContext().getCoreLibrary().getProcClass(), ProcNodes.Type.LAMBDA, method.getSharedMethodInfo(), method.getCallTarget(), method.getCallTarget(), method.getCallTarget(), method.getDeclarationFrame(), method, MethodNodes.getReceiver(methodObject), null);
        }
    }

    @CoreMethod(names={"unbind"})
    public static abstract class UnbindNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;

        public UnbindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject unbind(VirtualFrame frame, RubyBasicObject method) {
            RubyClass receiverClass = this.classNode.executeGetClass(frame, MethodNodes.getReceiver(method));
            return UnboundMethodNodes.createUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodClass(), receiverClass, MethodNodes.getMethod(method));
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        public SourceLocationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object sourceLocation(RubyBasicObject method) {
            CompilerDirectives.transferToInterpreter();
            SourceSection sourceSection = MethodNodes.getMethod(method).getSharedMethodInfo().getSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.nil();
            }
            RubyBasicObject file = this.createString(sourceSection.getSource().getName());
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), file, sourceSection.getStartLine());
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends CoreMethodArrayArgumentsNode {
        public ReceiverNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object receiver(RubyBasicObject method) {
            return MethodNodes.getReceiver(method);
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        public ParametersNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject parameters(RubyBasicObject method) {
            ArgsNode argsNode = (ArgsNode)MethodNodes.getMethod(method).getSharedMethodInfo().getParseTree().findFirstChild(ArgsNode.class);
            ArgumentDescriptor[] argsDesc = Helpers.argsNodeToArgumentDescriptors((ArgsNode)argsNode);
            return this.getContext().toTruffle(Helpers.argumentDescriptorsToParameters((Ruby)this.getContext().getRuntime(), (ArgumentDescriptor[])argsDesc, (boolean)true));
        }
    }

    @CoreMethod(names={"owner"})
    public static abstract class OwnerNode
    extends CoreMethodArrayArgumentsNode {
        public OwnerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyModule owner(RubyBasicObject method) {
            return MethodNodes.getMethod(method).getDeclaringModule();
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject name(RubyBasicObject method) {
            CompilerDirectives.transferToInterpreter();
            return this.getSymbol(MethodNodes.getMethod(method).getName());
        }
    }

    @CoreMethod(names={"call"}, needsBlock=true, argumentsAsArray=true)
    public static abstract class CallNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        ProcOrNullNode procOrNullNode;
        @Node.Child
        CallMethodNode callMethodNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.procOrNullNode = ProcOrNullNodeGen.create(context, sourceSection, null);
            this.callMethodNode = CallMethodNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        protected Object call(VirtualFrame frame, RubyBasicObject method, Object[] arguments, Object block) {
            InternalMethod internalMethod = MethodNodes.getMethod(method);
            Object[] frameArguments = this.packArguments(method, internalMethod, arguments, block);
            return this.callMethodNode.executeCallMethod(frame, internalMethod, frameArguments);
        }

        private Object[] packArguments(RubyBasicObject method, InternalMethod internalMethod, Object[] arguments, Object block) {
            return RubyArguments.pack(internalMethod, internalMethod.getDeclarationFrame(), MethodNodes.getReceiver(method), this.procOrNullNode.executeProcOrNull(block), arguments);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int arity(RubyBasicObject method) {
            return MethodNodes.getMethod(method).getSharedMethodInfo().getArity().getArityNumber();
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        protected BasicObjectNodes.ReferenceEqualNode referenceEqualNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        protected boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        @Specialization(guards={"isRubyMethod(b)"})
        public boolean equal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.areSame(frame, MethodNodes.getReceiver(a), MethodNodes.getReceiver(b)) && MethodNodes.getMethod(a) == MethodNodes.getMethod(b);
        }

        @Specialization(guards={"!isRubyMethod(b)"})
        public boolean equal(RubyBasicObject a, Object b) {
            return false;
        }
    }

    public static class MethodType
    extends BasicObjectType {
    }
}

