/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyProc;

public class AtExitManager {
    private final RubyContext context;
    private final Deque<RubyProc> runOnExit = new ConcurrentLinkedDeque<RubyProc>();
    private final Deque<RubyProc> runOnExitAlways = new ConcurrentLinkedDeque<RubyProc>();

    public AtExitManager(RubyContext context) {
        this.context = context;
    }

    public void add(RubyProc block, boolean always) {
        if (always) {
            this.runOnExitAlways.push(block);
        } else {
            this.runOnExit.push(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean normalExit) {
        try {
            if (normalExit) {
                this.runExitHooks(this.runOnExit);
            }
        }
        finally {
            this.runExitHooks(this.runOnExitAlways);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runExitHooks(Deque<RubyProc> stack) {
        block5: while (true) {
            RubyProc block;
            try {
                block = stack.pop();
            }
            catch (NoSuchElementException e) {
                return;
            }
            try {
                block.rootCall(new Object[0]);
                continue;
            }
            catch (RaiseException e) {
                RubyException rubyException = e.getRubyException();
                String[] arr$ = Backtrace.DISPLAY_FORMATTER.format(this.context, rubyException, rubyException.getBacktrace());
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block5;
                    String line = arr$[i$];
                    System.err.println(line);
                    ++i$;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

