/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import org.jcodings.Encoding;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;

public class SymbolCodeRangeableWrapper
implements CodeRangeable {
    private final RubyBasicObject symbol;

    public SymbolCodeRangeableWrapper(RubyBasicObject symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return SymbolNodes.getString(this.symbol);
    }

    public int getCodeRange() {
        return SymbolNodes.getCodeRange(this.symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public int scanForCodeRange() {
        ByteList byteList = SymbolNodes.getByteList(this.symbol);
        int cr = SymbolNodes.getCodeRange(this.symbol);
        if (cr == 0) {
            cr = StringSupport.codeRangeScan((Encoding)byteList.getEncoding(), (ByteList)byteList);
            SymbolNodes.setCodeRange(this.symbol, cr);
        }
        return cr;
    }

    public boolean isCodeRangeValid() {
        return SymbolNodes.getCodeRange(this.symbol) == 32;
    }

    public void setCodeRange(int codeRange) {
        SymbolNodes.setCodeRange(this.symbol, codeRange);
    }

    public void clearCodeRange() {
        SymbolNodes.setCodeRange(this.symbol, 0);
    }

    public void keepCodeRange() {
        if (SymbolNodes.getCodeRange(this.symbol) == 48) {
            SymbolNodes.setCodeRange(this.symbol, 0);
        }
    }

    public void modify() {
        throw new UnsupportedOperationException();
    }

    public void modify(int length) {
        throw new UnsupportedOperationException();
    }

    public void modifyAndKeepCodeRange() {
        throw new UnsupportedOperationException();
    }

    public Encoding checkEncoding(CodeRangeable other) {
        return SymbolNodes.getByteList(this.symbol).getEncoding();
    }

    public ByteList getByteList() {
        return SymbolNodes.getByteList(this.symbol);
    }
}

