/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccessFactory;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.ArrayForeignAccessFactory;
import org.jruby.truffle.runtime.core.BasicForeignAccessFactory;
import org.jruby.truffle.runtime.core.HashForeignAccessFactory;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.StringForeignAccessFactory;
import org.jruby.truffle.runtime.object.BasicObjectType;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.util.ByteList;

public class RubyBasicObject
implements TruffleObject {
    public static final HiddenKey OBJECT_ID_IDENTIFIER = new HiddenKey("object_id");
    public static final HiddenKey TAINTED_IDENTIFIER = new HiddenKey("tainted?");
    public static final HiddenKey FROZEN_IDENTIFIER = new HiddenKey("frozen?");
    public static final Layout LAYOUT = Layout.createLayout((EnumSet)Layout.INT_TO_LONG);
    public static final Shape EMPTY_SHAPE = LAYOUT.createShape((ObjectType)new BasicObjectType());
    private final DynamicObject dynamicObject;
    @CompilerDirectives.CompilationFinal
    private RubyClass logicalClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass metaClass;

    public RubyBasicObject(RubyClass rubyClass) {
        this(rubyClass.getContext(), rubyClass);
    }

    public RubyBasicObject(RubyClass rubyClass, DynamicObject dynamicObject) {
        this(rubyClass.getContext(), rubyClass, dynamicObject);
    }

    protected RubyBasicObject(RubyContext context, RubyClass rubyClass) {
        this(context, rubyClass, LAYOUT.newInstance(EMPTY_SHAPE));
    }

    private RubyBasicObject(RubyContext context, RubyClass rubyClass, DynamicObject dynamicObject) {
        this.dynamicObject = dynamicObject;
        if (rubyClass == null && this instanceof RubyClass) {
            rubyClass = (RubyClass)this;
        }
        this.unsafeSetLogicalClass(rubyClass);
    }

    protected void unsafeSetLogicalClass(RubyClass newLogicalClass) {
        assert (this.logicalClass == null);
        this.unsafeChangeLogicalClass(newLogicalClass);
    }

    public void unsafeChangeLogicalClass(RubyClass newLogicalClass) {
        this.logicalClass = newLogicalClass;
        this.metaClass = newLogicalClass;
    }

    public RubyClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @CompilerDirectives.TruffleBoundary
    public long verySlowGetObjectID() {
        Property property = this.dynamicObject.getShape().getProperty((Object)OBJECT_ID_IDENTIFIER);
        if (property != null) {
            return (Long)property.get(this.dynamicObject, false);
        }
        long objectID = this.getContext().getNextObjectID();
        this.dynamicObject.define((Object)OBJECT_ID_IDENTIFIER, (Object)objectID, 0);
        return objectID;
    }

    public Object getInstanceVariable(String name) {
        Object value = RubyBasicObject.getInstanceVariable(this, name);
        if (value == null) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return value;
    }

    public boolean isFieldDefined(String name) {
        return RubyBasicObject.isFieldDefined(this, name);
    }

    public ForeignAccessFactory getForeignAccessFactory() {
        if (RubyGuards.isRubyArray(this)) {
            return new ArrayForeignAccessFactory(this.getContext());
        }
        if (RubyGuards.isRubyHash(this)) {
            return new HashForeignAccessFactory(this.getContext());
        }
        if (RubyGuards.isRubyString(this)) {
            return new StringForeignAccessFactory(this.getContext());
        }
        return new BasicForeignAccessFactory(this.getContext());
    }

    public final void visitObjectGraph(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        if (visitor.visit(this)) {
            this.getMetaClass().visitObjectGraph(visitor);
            for (Object instanceVariable : RubyBasicObject.getInstanceVariables(this).values()) {
                if (!(instanceVariable instanceof RubyBasicObject)) continue;
                ((RubyBasicObject)instanceVariable).visitObjectGraph(visitor);
            }
            this.visitObjectGraphChildren(visitor);
        }
    }

    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        block4: {
            block3: {
                if (!RubyGuards.isRubyArray(this)) break block3;
                for (Object object : ArrayNodes.slowToArray(this)) {
                    if (!(object instanceof RubyBasicObject)) continue;
                    ((RubyBasicObject)object).visitObjectGraph(visitor);
                }
                break block4;
            }
            if (!RubyGuards.isRubyHash(this)) break block4;
            for (Map.Entry<Object, Object> keyValue : HashNodes.iterableKeyValues(this)) {
                if (keyValue.getKey() instanceof RubyBasicObject) {
                    ((RubyBasicObject)keyValue.getKey()).visitObjectGraph(visitor);
                }
                if (!(keyValue.getValue() instanceof RubyBasicObject)) continue;
                ((RubyBasicObject)keyValue.getValue()).visitObjectGraph(visitor);
            }
        }
    }

    public boolean isNumeric() {
        return ModuleOperations.assignableTo(this.getMetaClass(), this.getContext().getCoreLibrary().getNumericClass());
    }

    public RubyContext getContext() {
        return this.logicalClass.getContext();
    }

    public Shape getObjectLayout() {
        return this.dynamicObject.getShape();
    }

    public BasicObjectType getObjectType() {
        return (BasicObjectType)this.dynamicObject.getShape().getObjectType();
    }

    public RubyClass getLogicalClass() {
        return this.logicalClass;
    }

    public DynamicObject getDynamicObject() {
        return this.dynamicObject;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation((String)"RubyBasicObject#toString should only be used for debugging");
        if (this instanceof RubyString) {
            return Helpers.decodeByteList((Ruby)this.getContext().getRuntime(), (ByteList)StringNodes.getByteList((RubyString)this));
        }
        if (RubyGuards.isRubySymbol(this)) {
            return SymbolNodes.getString(this);
        }
        return String.format("RubyBasicObject@%x<logicalClass=%s>", System.identityHashCode(this), this.logicalClass.getName());
    }

    @CompilerDirectives.TruffleBoundary
    public static void setInstanceVariable(RubyBasicObject receiver, Object name, Object value) {
        Shape shape = receiver.getDynamicObject().getShape();
        Property property = shape.getProperty(name);
        if (property != null) {
            property.setGeneric(receiver.getDynamicObject(), value, null);
        } else {
            receiver.getDynamicObject().define(name, value, 0);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void setInstanceVariables(RubyBasicObject receiver, Map<Object, Object> instanceVariables) {
        for (Map.Entry<Object, Object> entry : instanceVariables.entrySet()) {
            RubyBasicObject.setInstanceVariable(receiver, entry.getKey(), entry.getValue());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getInstanceVariable(RubyBasicObject receiver, Object name) {
        Shape shape = receiver.getDynamicObject().getShape();
        Property property = shape.getProperty(name);
        if (property != null) {
            return property.get(receiver.getDynamicObject(), false);
        }
        return receiver.getContext().getCoreLibrary().getNilObject();
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<Object, Object> getInstanceVariables(RubyBasicObject receiver) {
        Shape shape = receiver.getDynamicObject().getShape();
        LinkedHashMap<Object, Object> vars = new LinkedHashMap<Object, Object>();
        List properties = shape.getPropertyList();
        for (Property property : properties) {
            vars.put((String)property.getKey(), property.get(receiver.getDynamicObject(), false));
        }
        return vars;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object[] getFieldNames(RubyBasicObject receiver) {
        List keys = receiver.getDynamicObject().getShape().getKeyList();
        return keys.toArray(new Object[keys.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isFieldDefined(RubyBasicObject receiver, String name) {
        return receiver.getDynamicObject().getShape().hasProperty((Object)name);
    }

    public static class BasicObjectAllocator
    implements Allocator {
        @Override
        @CompilerDirectives.TruffleBoundary
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyBasicObject(rubyClass);
        }
    }
}

