/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes.read;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.pack.nodes.SourceNode;
import org.jruby.truffle.pack.nodes.type.ToStringNode;
import org.jruby.truffle.pack.nodes.type.ToStringNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteByteNode;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadStringNode
extends PackNode {
    private final boolean convertNumbersToStrings;
    private final String conversionMethod;
    private final boolean inspectOnConversionFailure;
    private final Object valueOnNil;
    @Node.Child
    private ToStringNode toStringNode;

    public ReadStringNode(RubyContext context, boolean convertNumbersToStrings, String conversionMethod, boolean inspectOnConversionFailure, Object valueOnNil) {
        super(context);
        this.convertNumbersToStrings = convertNumbersToStrings;
        this.conversionMethod = conversionMethod;
        this.inspectOnConversionFailure = inspectOnConversionFailure;
        this.valueOnNil = valueOnNil;
    }

    @Specialization(guards={"isNull(source)"})
    public long read(VirtualFrame frame, Object source) {
        CompilerDirectives.transferToInterpreter();
        this.advanceSourcePosition(frame);
        throw new IllegalStateException();
    }

    @Specialization
    public Object read(VirtualFrame frame, int[] source) {
        return this.readAndConvert(frame, source[this.advanceSourcePosition(frame)]);
    }

    @Specialization
    public Object read(VirtualFrame frame, long[] source) {
        return this.readAndConvert(frame, source[this.advanceSourcePosition(frame)]);
    }

    @Specialization
    public Object read(VirtualFrame frame, double[] source) {
        return this.readAndConvert(frame, source[this.advanceSourcePosition(frame)]);
    }

    @Specialization
    public Object read(VirtualFrame frame, Object[] source) {
        return this.readAndConvert(frame, source[this.advanceSourcePosition(frame)]);
    }

    private Object readAndConvert(VirtualFrame frame, Object value) {
        if (this.toStringNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toStringNode = (ToStringNode)this.insert(ToStringNodeGen.create(this.getContext(), this.convertNumbersToStrings, this.conversionMethod, this.inspectOnConversionFailure, this.valueOnNil, new WriteByteNode(this.getContext(), 0)));
        }
        return this.toStringNode.executeToString(frame, value);
    }
}

