/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.literal.RangeLiteralNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyRange;

@GeneratedBy(value=RangeLiteralNode.class)
public final class RangeLiteralNodeGen
extends RangeLiteralNode
implements SpecializedNode {
    @Node.Child
    private RubyNode begin_;
    @Node.Child
    private RubyNode end_;
    @CompilerDirectives.CompilationFinal
    private Class<?> beginType_;
    @CompilerDirectives.CompilationFinal
    private Class<?> endType_;
    @Node.Child
    private BaseNode_ specialization_;

    private RangeLiteralNodeGen(RubyContext context, SourceSection sourceSection, boolean excludeEnd, RubyNode begin, RubyNode end) {
        super(context, sourceSection, excludeEnd);
        this.begin_ = begin;
        this.end_ = end;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeRubyBasicObject(frameValue);
    }

    @Override
    public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeIntegerFixnumRange(frameValue);
    }

    @Override
    public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeLongFixnumRange(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static RubyRange.IntegerFixnumRange expectIntegerFixnumRange(Object value) throws UnexpectedResultException {
        if (value instanceof RubyRange.IntegerFixnumRange) {
            return (RubyRange.IntegerFixnumRange)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static RubyRange.LongFixnumRange expectLongFixnumRange(Object value) throws UnexpectedResultException {
        if (value instanceof RubyRange.LongFixnumRange) {
            return (RubyRange.LongFixnumRange)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static RubyBasicObject expectRubyBasicObject(Object value) throws UnexpectedResultException {
        if (value instanceof RubyBasicObject) {
            return (RubyBasicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static RangeLiteralNode create(RubyContext context, SourceSection sourceSection, boolean excludeEnd, RubyNode begin, RubyNode end) {
        return new RangeLiteralNodeGen(context, sourceSection, excludeEnd, begin, end);
    }

    @GeneratedBy(methodName="doRange(VirtualFrame, Object, Object)", value=RangeLiteralNode.class)
    private static final class Range4Node_
    extends BaseNode_ {
        Range4Node_(RangeLiteralNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            return this.root.doRange(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root) {
            return new Range4Node_(root);
        }
    }

    @GeneratedBy(methodName="doRange(long, long)", value=RangeLiteralNode.class)
    private static final class Range3Node_
    extends BaseNode_ {
        private final Class<?> beginImplicitType;
        private final Class<?> endImplicitType;

        Range3Node_(RangeLiteralNodeGen root, Object beginValue, Object endValue) {
            super(root, 4);
            this.beginImplicitType = RubyTypesGen.getImplicitLongClass(beginValue);
            this.endImplicitType = RubyTypesGen.getImplicitLongClass(endValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.beginImplicitType == ((Range3Node_)other).beginImplicitType && this.endImplicitType == ((Range3Node_)other).endImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeLongFixnumRange(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            long endValue_;
            long beginValue_;
            try {
                beginValue_ = this.executeBeginLong_((Frame)frameValue, this.beginImplicitType);
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.executeEnd_((Frame)frameValue);
                return RangeLiteralNodeGen.expectLongFixnumRange(this.getNext().execute_(frameValue, ex.getResult(), endValue));
            }
            try {
                endValue_ = this.executeEndLong_((Frame)frameValue, this.endImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return RangeLiteralNodeGen.expectLongFixnumRange(this.getNext().execute_(frameValue, beginValue_, ex.getResult()));
            }
            return this.root.doRange(beginValue_, endValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return this.executeLongFixnumRange(frameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (RubyTypesGen.isImplicitLong(beginValue, this.beginImplicitType) && RubyTypesGen.isImplicitLong(endValue, this.endImplicitType)) {
                long beginValue_ = RubyTypesGen.asImplicitLong(beginValue, this.beginImplicitType);
                long endValue_ = RubyTypesGen.asImplicitLong(endValue, this.endImplicitType);
                return this.root.doRange(beginValue_, endValue_);
            }
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root, Object beginValue, Object endValue) {
            return new Range3Node_(root, beginValue, endValue);
        }
    }

    @GeneratedBy(methodName="doRange(long, int)", value=RangeLiteralNode.class)
    private static final class Range2Node_
    extends BaseNode_ {
        private final Class<?> beginImplicitType;

        Range2Node_(RangeLiteralNodeGen root, Object beginValue) {
            super(root, 3);
            this.beginImplicitType = RubyTypesGen.getImplicitLongClass(beginValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.beginImplicitType == ((Range2Node_)other).beginImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeLongFixnumRange(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            int endValue_;
            long beginValue_;
            try {
                beginValue_ = this.executeBeginLong_((Frame)frameValue, this.beginImplicitType);
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.executeEnd_((Frame)frameValue);
                return RangeLiteralNodeGen.expectLongFixnumRange(this.getNext().execute_(frameValue, ex.getResult(), endValue));
            }
            try {
                endValue_ = this.root.end_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RangeLiteralNodeGen.expectLongFixnumRange(this.getNext().execute_(frameValue, beginValue_, ex.getResult()));
            }
            return this.root.doRange(beginValue_, endValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return this.executeLongFixnumRange(frameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (RubyTypesGen.isImplicitLong(beginValue, this.beginImplicitType) && endValue instanceof Integer) {
                long beginValue_ = RubyTypesGen.asImplicitLong(beginValue, this.beginImplicitType);
                int endValue_ = (Integer)endValue;
                return this.root.doRange(beginValue_, endValue_);
            }
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root, Object beginValue) {
            return new Range2Node_(root, beginValue);
        }
    }

    @GeneratedBy(methodName="doRange(int, long)", value=RangeLiteralNode.class)
    private static final class Range1Node_
    extends BaseNode_ {
        private final Class<?> endImplicitType;

        Range1Node_(RangeLiteralNodeGen root, Object endValue) {
            super(root, 2);
            this.endImplicitType = RubyTypesGen.getImplicitLongClass(endValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.endImplicitType == ((Range1Node_)other).endImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeLongFixnumRange(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            long endValue_;
            int beginValue_;
            try {
                beginValue_ = this.root.begin_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.executeEnd_((Frame)frameValue);
                return RangeLiteralNodeGen.expectLongFixnumRange(this.getNext().execute_(frameValue, ex.getResult(), endValue));
            }
            try {
                endValue_ = this.executeEndLong_((Frame)frameValue, this.endImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return RangeLiteralNodeGen.expectLongFixnumRange(this.getNext().execute_(frameValue, beginValue_, ex.getResult()));
            }
            return this.root.doRange(beginValue_, endValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return this.executeLongFixnumRange(frameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (beginValue instanceof Integer && RubyTypesGen.isImplicitLong(endValue, this.endImplicitType)) {
                int beginValue_ = (Integer)beginValue;
                long endValue_ = RubyTypesGen.asImplicitLong(endValue, this.endImplicitType);
                return this.root.doRange(beginValue_, endValue_);
            }
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root, Object endValue) {
            return new Range1Node_(root, endValue);
        }
    }

    @GeneratedBy(methodName="doRange(int, int)", value=RangeLiteralNode.class)
    private static final class Range0Node_
    extends BaseNode_ {
        Range0Node_(RangeLiteralNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeIntegerFixnumRange(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            int endValue_;
            int beginValue_;
            try {
                beginValue_ = this.root.begin_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.executeEnd_((Frame)frameValue);
                return RangeLiteralNodeGen.expectIntegerFixnumRange(this.getNext().execute_(frameValue, ex.getResult(), endValue));
            }
            try {
                endValue_ = this.root.end_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RangeLiteralNodeGen.expectIntegerFixnumRange(this.getNext().execute_(frameValue, beginValue_, ex.getResult()));
            }
            return this.root.doRange(beginValue_, endValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return this.executeIntegerFixnumRange(frameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (beginValue instanceof Integer && endValue instanceof Integer) {
                int beginValue_ = (Integer)beginValue;
                int endValue_ = (Integer)endValue;
                return this.root.doRange(beginValue_, endValue_);
            }
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root) {
            return new Range0Node_(root);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(RangeLiteralNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object beginValue, Object endValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, beginValue, endValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(RangeLiteralNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            return this.uninitialized((Frame)frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final RangeLiteralNodeGen root;

        BaseNode_(RangeLiteralNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.begin_, this.root.end_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object beginValue, Object endValue) {
            return this.execute_((VirtualFrame)frameValue, beginValue, endValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

        public Object execute(VirtualFrame frameValue) {
            Object beginValue_ = this.executeBegin_((Frame)frameValue);
            Object endValue_ = this.executeEnd_((Frame)frameValue);
            return this.execute_(frameValue, beginValue_, endValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return RangeLiteralNodeGen.expectRubyBasicObject(this.execute(frameValue));
        }

        public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            return RangeLiteralNodeGen.expectIntegerFixnumRange(this.executeRubyBasicObject(frameValue));
        }

        public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            return RangeLiteralNodeGen.expectLongFixnumRange(this.executeRubyBasicObject(frameValue));
        }

        protected final SpecializationNode createNext(Frame frameValue, Object beginValue, Object endValue) {
            if (beginValue instanceof Integer) {
                if (endValue instanceof Integer) {
                    return Range0Node_.create(this.root);
                }
                if (RubyTypesGen.isImplicitLong(endValue)) {
                    return Range1Node_.create(this.root, endValue);
                }
            }
            if (RubyTypesGen.isImplicitLong(beginValue)) {
                if (endValue instanceof Integer) {
                    return Range2Node_.create(this.root, beginValue);
                }
                if (RubyTypesGen.isImplicitLong(endValue)) {
                    return Range3Node_.create(this.root, beginValue, endValue);
                }
            }
            return Range4Node_.create(this.root);
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeBegin_(Frame frameValue) {
            Object object;
            Class beginType_ = this.root.beginType_;
            if (beginType_ == Integer.TYPE) {
                return this.root.begin_.executeInteger((VirtualFrame)frameValue);
            }
            if (beginType_ == Long.TYPE) {
                return this.root.begin_.executeLong((VirtualFrame)frameValue);
            }
            if (beginType_ != null) return this.root.begin_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.begin_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.beginType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.beginType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.beginType_ = _type;
            return object;
        }

        protected final long executeBeginLong_(Frame frameValue, Class<?> beginImplicitType) throws UnexpectedResultException {
            if (beginImplicitType == Long.TYPE) {
                return this.root.begin_.executeLong((VirtualFrame)frameValue);
            }
            if (beginImplicitType == Integer.TYPE) {
                return RubyTypes.int2long(this.root.begin_.executeInteger((VirtualFrame)frameValue));
            }
            Object beginValue_ = this.executeBegin_(frameValue);
            throw new UnexpectedResultException(beginValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeEnd_(Frame frameValue) {
            Object object;
            Class endType_ = this.root.endType_;
            if (endType_ == Integer.TYPE) {
                return this.root.end_.executeInteger((VirtualFrame)frameValue);
            }
            if (endType_ == Long.TYPE) {
                return this.root.end_.executeLong((VirtualFrame)frameValue);
            }
            if (endType_ != null) return this.root.end_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.end_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.endType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.endType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.endType_ = _type;
            return object;
        }

        protected final long executeEndLong_(Frame frameValue, Class<?> endImplicitType) throws UnexpectedResultException {
            if (endImplicitType == Long.TYPE) {
                return this.root.end_.executeLong((VirtualFrame)frameValue);
            }
            if (endImplicitType == Integer.TYPE) {
                return RubyTypes.int2long(this.root.end_.executeInteger((VirtualFrame)frameValue));
            }
            Object endValue_ = this.executeEnd_(frameValue);
            throw new UnexpectedResultException(endValue_);
        }
    }
}

