/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.hash.Entry;

public abstract class HashGuards {
    public static boolean isNullHash(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return HashNodes.getStore(hash) == null;
    }

    public static boolean isPackedHash(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return !HashGuards.isNullHash(hash) && !HashGuards.isBucketHash(hash);
    }

    public static boolean isBucketHash(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return HashNodes.getStore(hash) instanceof Entry[];
    }

    public static boolean isEmptyHash(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return HashNodes.getSize(hash) == 0;
    }

    public static boolean isCompareByIdentity(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return HashNodes.isCompareByIdentity(hash);
    }

    public static boolean hasDefaultValue(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return HashNodes.getDefaultValue(hash) != null;
    }

    public static boolean hasDefaultBlock(RubyBasicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return HashNodes.getDefaultBlock(hash) != null;
    }
}

