/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Map;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.BucketsStrategy;

public class ConcatHashLiteralNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;

    public ConcatHashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] children) {
        super(context, sourceSection);
        this.children = children;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        ArrayList<Map.Entry<Object, Object>> keyValues = new ArrayList<Map.Entry<Object, Object>>();
        for (RubyNode child : this.children) {
            try {
                for (Map.Entry<Object, Object> keyValue : HashNodes.iterableKeyValues(child.executeRubyHash(frame))) {
                    keyValues.add(keyValue);
                }
            }
            catch (UnexpectedResultException e) {
                throw new UnsupportedOperationException(((Object)((Object)child)).getClass() + " " + e.getResult().getClass());
            }
        }
        return BucketsStrategy.create(this.getContext().getCoreLibrary().getHashClass(), keyValues, false);
    }
}

