/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="requiredCapacity", type=RubyNode.class)})
public abstract class EnsureCapacityArrayNode
extends RubyNode {
    private final ConditionProfile allocateProfile = ConditionProfile.createCountingProfile();

    public EnsureCapacityArrayNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeEnsureCapacity(VirtualFrame var1, RubyBasicObject var2, int var3);

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public boolean ensureCapacityInt(RubyBasicObject array, int requiredCapacity) {
        int[] store = (int[])ArrayNodes.getStore(array);
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            ArrayNodes.setStore(array, Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)), ArrayNodes.getSize(array));
            return true;
        }
        return false;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public boolean ensureCapacityLong(RubyBasicObject array, int requiredCapacity) {
        long[] store = (long[])ArrayNodes.getStore(array);
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            ArrayNodes.setStore(array, Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)), ArrayNodes.getSize(array));
            return true;
        }
        return false;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public boolean ensureCapacityDouble(RubyBasicObject array, int requiredCapacity) {
        double[] store = (double[])ArrayNodes.getStore(array);
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            ArrayNodes.setStore(array, Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)), ArrayNodes.getSize(array));
            return true;
        }
        return false;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public boolean ensureCapacityObject(RubyBasicObject array, int requiredCapacity) {
        Object[] store = (Object[])ArrayNodes.getStore(array);
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            ArrayNodes.setStore(array, Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)), ArrayNodes.getSize(array));
            return true;
        }
        return false;
    }
}

