/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.array.ArrayWriteNormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayWriteNormalizedNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="value", type=RubyNode.class)})
public abstract class ArrayWriteDenormalizedNode
extends RubyNode {
    @Node.Child
    private ArrayWriteNormalizedNode writeNode;

    public ArrayWriteDenormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeWrite(VirtualFrame var1, RubyBasicObject var2, int var3, Object var4);

    @Specialization(guards={"isRubyArray(array)"})
    public Object write(VirtualFrame frame, RubyBasicObject array, int index, Object value) {
        if (this.writeNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.writeNode = (ArrayWriteNormalizedNode)this.insert(ArrayWriteNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
        }
        int normalizedIndex = ArrayNodes.normalizeIndex(array, index);
        return this.writeNode.executeWrite(frame, array, normalizedIndex, value);
    }
}

