/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="length", type=RubyNode.class)})
public abstract class ArrayReadSliceNormalizedNode
extends RubyNode {
    public ArrayReadSliceNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeReadSlice(VirtualFrame var1, RubyBasicObject var2, int var3, int var4);

    @Specialization(guards={"isRubyArray(array)", "!indexInBounds(array, index)"})
    public RubyBasicObject readIndexOutOfBounds(RubyBasicObject array, int index, int length) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)", "!lengthPositive(length)"})
    public RubyBasicObject readNegativeLength(RubyBasicObject array, int index, int length) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "isNullArray(array)"})
    public RubyBasicObject readNull(RubyBasicObject array, int index, int length) {
        return ArrayNodes.createEmptyArray(array.getLogicalClass());
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "isIntArray(array)"})
    public RubyBasicObject readIntInBounds(RubyBasicObject array, int index, int length) {
        return ArrayNodes.createArray(array.getLogicalClass(), Arrays.copyOfRange((int[])ArrayNodes.getStore(array), index, index + length), length);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "isLongArray(array)"})
    public RubyBasicObject readLongInBounds(RubyBasicObject array, int index, int length) {
        return ArrayNodes.createArray(array.getLogicalClass(), Arrays.copyOfRange((long[])ArrayNodes.getStore(array), index, index + length), length);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "isDoubleArray(array)"})
    public RubyBasicObject readDoubleInBounds(RubyBasicObject array, int index, int length) {
        return ArrayNodes.createArray(array.getLogicalClass(), Arrays.copyOfRange((double[])ArrayNodes.getStore(array), index, index + length), length);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "isObjectArray(array)"})
    public RubyBasicObject readObjectInBounds(RubyBasicObject array, int index, int length) {
        return ArrayNodes.createArray(array.getLogicalClass(), Arrays.copyOfRange((Object[])ArrayNodes.getStore(array), index, index + length), length);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "isIntArray(array)"})
    public RubyBasicObject readIntOutOfBounds(RubyBasicObject array, int index, int length) {
        int clampedLength = Math.min(ArrayNodes.getSize(array), index + length) - index;
        return ArrayNodes.createArray(array.getLogicalClass(), Arrays.copyOfRange((int[])ArrayNodes.getStore(array), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "isLongArray(array)"})
    public RubyBasicObject readLongOutOfBounds(RubyBasicObject array, int index, int length) {
        int clampedLength = Math.min(ArrayNodes.getSize(array), index + length) - index;
        return ArrayNodes.createArray(array.getLogicalClass(), Arrays.copyOfRange((long[])ArrayNodes.getStore(array), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "isDoubleArray(array)"})
    public RubyBasicObject readDoubleOutOfBounds(RubyBasicObject array, int index, int length) {
        int clampedLength = Math.min(ArrayNodes.getSize(array), index + length) - index;
        return ArrayNodes.createArray(array.getLogicalClass(), Arrays.copyOfRange((double[])ArrayNodes.getStore(array), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "isObjectArray(array)"})
    public RubyBasicObject readObjectOutOfBounds(RubyBasicObject array, int index, int length) {
        int clampedLength = Math.min(ArrayNodes.getSize(array), index + length) - index;
        return ArrayNodes.createArray(array.getLogicalClass(), Arrays.copyOfRange((Object[])ArrayNodes.getStore(array), index, index + clampedLength), clampedLength);
    }

    protected static boolean indexInBounds(RubyBasicObject array, int index) {
        return index >= 0 && index <= ArrayNodes.getSize(array);
    }

    protected static boolean lengthPositive(int length) {
        return length >= 0;
    }

    protected static boolean endInBounds(RubyBasicObject array, int index, int length) {
        return index + length < ArrayNodes.getSize(array);
    }
}

