/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyGC;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.cext.CExtManager;
import org.jruby.truffle.runtime.cext.CExtSubsystem;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.subsystems.SimpleShell;
import org.jruby.util.ByteList;
import org.jruby.util.Memo;

@CoreClass(name="Truffle::Primitive")
public abstract class TrufflePrimitiveNodes {

    @CoreMethod(names={"fixnum_lower"}, isModuleFunction=true, required=1)
    public static abstract class FixnumLowerPrimitiveNode
    extends UnaryCoreMethodNode {
        public FixnumLowerPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int lower(int value) {
            return value;
        }

        @Specialization(guards={"canLower(value)"})
        public int lower(long value) {
            return (int)value;
        }

        @Specialization(guards={"!canLower(value)"})
        public long lowerFails(long value) {
            return value;
        }

        protected static boolean canLower(long value) {
            return CoreLibrary.fitsIntoInteger(value);
        }
    }

    @CoreMethod(names={"install_rubinius_primitive"}, isModuleFunction=true, required=1)
    public static abstract class InstallRubiniusPrimitiveNode
    extends CoreMethodArrayArgumentsNode {
        public InstallRubiniusPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyMethod(rubyMethod)"})
        public Object installRubiniusPrimitive(RubyBasicObject rubyMethod) {
            String name = MethodNodes.getMethod(rubyMethod).getName();
            this.getContext().getRubiniusPrimitiveManager().installPrimitive(name, rubyMethod);
            return this.nil();
        }
    }

    @CoreMethod(names={"at_exit"}, isModuleFunction=true, needsBlock=true, required=1)
    public static abstract class AtExitSystemNode
    extends CoreMethodArrayArgumentsNode {
        public AtExitSystemNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object atExit(boolean always, RubyProc block) {
            this.getContext().getAtExitManager().add(block, always);
            return this.nil();
        }
    }

    @CoreMethod(names={"host_os"}, onSingleton=true)
    public static abstract class HostOSNode
    extends CoreMethodNode {
        public HostOSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject hostOS() {
            return this.createString(RbConfigLibrary.getOSName());
        }
    }

    @CoreMethod(names={"jruby_home_directory"}, onSingleton=true)
    public static abstract class JRubyHomeDirectoryNode
    extends CoreMethodNode {
        public JRubyHomeDirectoryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject jrubyHomeDirectory() {
            return this.createString(this.getContext().getRuntime().getJRubyHome());
        }
    }

    @CoreMethod(names={"debug_print"}, onSingleton=true, required=1)
    public static abstract class DebugPrintNode
    extends CoreMethodArrayArgumentsNode {
        public DebugPrintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject debugPrint(RubyString string) {
            System.err.println(string.toString());
            return this.nil();
        }
    }

    @CoreMethod(names={"cext_supported?"}, needsSelf=false, onSingleton=true)
    public static abstract class CExtSupportedNode
    extends CoreMethodArrayArgumentsNode {
        public CExtSupportedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean cExtSupported() {
            return CExtManager.getSubsystem() != null;
        }
    }

    @CoreMethod(names={"cext_load"}, onSingleton=true, needsSelf=false, required=3)
    public static abstract class CExtLoadNode
    extends CoreMethodArrayArgumentsNode {
        public CExtLoadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyArray(initFunctions)", "isRubyArray(cFlags)", "isRubyArray(files)"})
        public boolean cExtLoad(RubyBasicObject initFunctions, RubyBasicObject cFlags, RubyBasicObject files) {
            CExtSubsystem subsystem = CExtManager.getSubsystem();
            if (subsystem == null) {
                throw new UnsupportedOperationException();
            }
            subsystem.load(this.toStrings(initFunctions), this.toStrings(cFlags), this.toStrings(files));
            return true;
        }

        private String[] toStrings(RubyBasicObject array) {
            assert (RubyGuards.isRubyArray(array));
            String[] strings = new String[ArrayNodes.getSize(array)];
            int n = 0;
            for (Object object : ArrayNodes.slowToArray(array)) {
                if (object instanceof RubyString || RubyGuards.isRubySymbol(object)) {
                    strings[n] = object.toString();
                    ++n;
                    continue;
                }
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(object), this.getContext().getCoreLibrary().getStringClass(), this));
            }
            return strings;
        }
    }

    @CoreMethod(names={"detach"}, onSingleton=true, required=2)
    public static abstract class DetachNode
    extends CoreMethodArrayArgumentsNode {
        public DetachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject detach(RubyString file, int line) {
            this.getContext().getAttachmentsManager().detach(file.toString(), line);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"attach"}, onSingleton=true, required=2, needsBlock=true)
    public static abstract class AttachNode
    extends CoreMethodArrayArgumentsNode {
        public AttachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject attach(RubyString file, int line, RubyProc block) {
            this.getContext().getAttachmentsManager().attach(file.toString(), line, block);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"coverage_start"}, onSingleton=true)
    public static abstract class CoverageStartNode
    extends CoreMethodArrayArgumentsNode {
        public CoverageStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject coverageStart() {
            if (this.getContext().getCoverageTracker() == null) {
                throw new UnsupportedOperationException("coverage is disabled");
            }
            this.getContext().getCoverageTracker().install();
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"coverage_result"}, onSingleton=true)
    public static abstract class CoverageResultNode
    extends CoreMethodArrayArgumentsNode {
        public CoverageResultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject coverageResult() {
            if (this.getContext().getCoverageTracker() == null) {
                throw new UnsupportedOperationException("coverage is disabled");
            }
            HashMap<RubyBasicObject, RubyBasicObject> converted = new HashMap<RubyBasicObject, RubyBasicObject>();
            for (Map.Entry source : this.getContext().getCoverageTracker().getCounts().entrySet()) {
                Object[] store = this.lineCountsStore((Long[])source.getValue());
                RubyBasicObject array = this.createArray(store, store.length);
                converted.put(this.createString(((Source)source.getKey()).getPath()), array);
            }
            return BucketsStrategy.create(this.getContext().getCoreLibrary().getHashClass(), converted.entrySet(), false);
        }

        private Object[] lineCountsStore(Long[] array) {
            Object[] store = new Object[array.length];
            for (int n = 0; n < array.length; ++n) {
                store[n] = array[n] == null ? this.getContext().getCoreLibrary().getNilObject() : array[n];
            }
            return store;
        }
    }

    @CoreMethod(names={"simple_shell"}, onSingleton=true)
    public static abstract class SimpleShellNode
    extends CoreMethodArrayArgumentsNode {
        public SimpleShellNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject simpleShell() {
            new SimpleShell(this.getContext()).run(RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize(), this);
            return this.nil();
        }
    }

    @CoreMethod(names={"graal_version"}, onSingleton=true)
    public static abstract class GraalVersionNode
    extends CoreMethodArrayArgumentsNode {
        public GraalVersionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject graalVersion() {
            return this.createString(System.getProperty("graal.version", "unknown"));
        }
    }

    @CoreMethod(names={"substrate?"}, onSingleton=true)
    public static abstract class SubstrateNode
    extends CoreMethodArrayArgumentsNode {
        public SubstrateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean substrate() {
            return Ruby.isSubstrateVM();
        }
    }

    @CoreMethod(names={"graal?"}, onSingleton=true)
    public static abstract class GraalNode
    extends CoreMethodArrayArgumentsNode {
        public GraalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean graal() {
            return Truffle.getRuntime().getName().toLowerCase(Locale.ENGLISH).contains("graal");
        }
    }

    @CoreMethod(names={"dump_string"}, onSingleton=true, required=1)
    public static abstract class DumpStringNode
    extends CoreMethodArrayArgumentsNode {
        public DumpStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject dumpString(RubyString string) {
            StringBuilder builder = new StringBuilder();
            ByteList byteList = StringNodes.getByteList(string);
            for (int i = 0; i < byteList.length(); ++i) {
                builder.append(String.format("\\x%02x", byteList.get(i)));
            }
            return this.createString(builder.toString());
        }
    }

    @CoreMethod(names={"java_class_of"}, onSingleton=true, required=1)
    public static abstract class JavaClassOfNode
    extends CoreMethodArrayArgumentsNode {
        public JavaClassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject javaClassOf(Object value) {
            return this.createString(value.getClass().getSimpleName());
        }
    }

    @CoreMethod(names={"assert_not_compiled"}, onSingleton=true)
    public static abstract class AssertNotCompiledNode
    extends CoreMethodArrayArgumentsNode {
        public AssertNotCompiledNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject assertNotCompiled() {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("Truffle::Primitive.assert_not_compiled can only be called lexically", this));
        }
    }

    @CoreMethod(names={"assert_constant"}, onSingleton=true, required=1)
    public static abstract class AssertConstantNode
    extends CoreMethodArrayArgumentsNode {
        public AssertConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject assertConstant(Object value) {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("Truffle::Primitive.assert_constant can only be called lexically", this));
        }
    }

    @CoreMethod(names={"gc_time"}, onSingleton=true)
    public static abstract class GCTimeNode
    extends CoreMethodArrayArgumentsNode {
        public GCTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long gcTime() {
            return RubyGC.getCollectionTime();
        }
    }

    @CoreMethod(names={"gc_count"}, onSingleton=true)
    public static abstract class GCCountNode
    extends CoreMethodArrayArgumentsNode {
        public GCCountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int gcCount() {
            return RubyGC.getCollectionCount();
        }
    }

    @CoreMethod(names={"source_of_caller"}, onSingleton=true)
    public static abstract class SourceOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        public SourceOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject sourceOfCaller() {
            final Memo frameCount = new Memo((Object)0);
            String source = (String)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<String>(){

                public String visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getCallNode().getEncapsulatingSourceSection().getSource().getName();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            return this.createString(source);
        }
    }

    @CoreMethod(names={"binding_of_caller"}, onSingleton=true)
    public static abstract class BindingOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        public BindingOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBinding bindingOfCaller() {
            final Memo frameCount = new Memo((Object)0);
            MaterializedFrame frame = (MaterializedFrame)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<MaterializedFrame>(){

                public MaterializedFrame visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(frame.getArguments()), frame);
        }
    }
}

