/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.signal.SignalOperations;
import sun.misc.Signal;

@CoreClass(name="Process")
public abstract class ProcessNodes {
    public static final int CLOCK_MONOTONIC = 1;
    public static final int CLOCK_REALTIME = 2;

    @CoreMethod(names={"pid"}, onSingleton=true)
    public static abstract class PidNode
    extends CoreMethodArrayArgumentsNode {
        public PidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int pid() {
            return this.posix().getpid();
        }
    }

    @CoreMethod(names={"kill"}, onSingleton=true, required=2)
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        public KillNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(signalName)"})
        public int kill(RubyBasicObject signalName, int pid) {
            int self = this.posix().getpid();
            if (self == pid) {
                Signal signal = new Signal(SymbolNodes.getString(signalName));
                SignalOperations.raise(signal);
                return 1;
            }
            throw new UnsupportedOperationException();
        }
    }

    @CoreMethod(names={"clock_gettime"}, onSingleton=true, required=1, optional=1)
    public static abstract class ClockGetTimeNode
    extends CoreMethodArrayArgumentsNode {
        private final RubyBasicObject floatSecondSymbol;
        private final RubyBasicObject nanosecondSymbol;

        public ClockGetTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.floatSecondSymbol = context.getSymbol("float_second");
            this.nanosecondSymbol = context.getSymbol("nanosecond");
        }

        @Specialization(guards={"isMonotonic(clock_id)"})
        Object clock_gettime_monotonic(int clock_id, NotProvided unit) {
            return this.clock_gettime_monotonic(1, this.floatSecondSymbol);
        }

        @Specialization(guards={"isRealtime(clock_id)"})
        Object clock_gettime_realtime(int clock_id, NotProvided unit) {
            return this.clock_gettime_realtime(2, this.floatSecondSymbol);
        }

        @Specialization(guards={"isMonotonic(clock_id)", "isRubySymbol(unit)"})
        Object clock_gettime_monotonic(int clock_id, RubyBasicObject unit) {
            long time = System.nanoTime();
            return this.timeToUnit(time, unit);
        }

        @Specialization(guards={"isRealtime(clock_id)", "isRubySymbol(unit)"})
        Object clock_gettime_realtime(int clock_id, RubyBasicObject unit) {
            long time = System.currentTimeMillis() * 1000000L;
            return this.timeToUnit(time, unit);
        }

        Object timeToUnit(long time, RubyBasicObject unit) {
            assert (RubyGuards.isRubySymbol(unit));
            if (unit == this.nanosecondSymbol) {
                return time;
            }
            if (unit == this.floatSecondSymbol) {
                return (double)time / 1.0E9;
            }
            throw new UnsupportedOperationException(SymbolNodes.getString(unit));
        }

        static boolean isMonotonic(int clock_id) {
            return clock_id == 1;
        }

        static boolean isRealtime(int clock_id) {
            return clock_id == 2;
        }
    }
}

