/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes.write;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class WriteBinaryStringNode
extends PackNode {
    private final boolean pad;
    private final boolean padOnNil;
    private final int width;
    private final byte padding;
    private final boolean takeAll;
    private final boolean appendNull;

    public WriteBinaryStringNode(RubyContext context, boolean pad, boolean padOnNil, int width, byte padding, boolean takeAll, boolean appendNull) {
        super(context);
        this.pad = pad;
        this.padOnNil = padOnNil;
        this.width = width;
        this.padding = padding;
        this.takeAll = takeAll;
        this.appendNull = appendNull;
    }

    @Specialization(guards={"isNil(nil)"})
    public Object write(VirtualFrame frame, Object nil) {
        if (this.padOnNil) {
            for (int n = 0; n < this.width; ++n) {
                this.writeBytes(frame, this.padding);
            }
        }
        return null;
    }

    @Specialization
    public Object write(VirtualFrame frame, ByteList bytes) {
        int lengthFromBytes = this.takeAll ? bytes.length() : Math.min(this.width, bytes.length());
        if (this.pad) {
            int lengthFromPadding = this.width - lengthFromBytes;
            this.writeBytes(frame, bytes.getUnsafeBytes(), bytes.begin(), lengthFromBytes);
            for (int n = 0; n < lengthFromPadding; ++n) {
                this.writeBytes(frame, this.padding);
            }
        } else {
            this.writeBytes(frame, bytes.getUnsafeBytes(), bytes.begin(), lengthFromBytes);
        }
        if (this.appendNull) {
            this.writeBytes(frame, 0);
        }
        return null;
    }
}

