/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.supercall.AbstractGeneralSuperCallNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;

public class GeneralSuperReCallNode
extends AbstractGeneralSuperCallNode {
    private final boolean inBlock;
    private final boolean isSplatted;
    @Node.Children
    private final RubyNode[] reloadNodes;
    @Node.Child
    private RubyNode block;

    public GeneralSuperReCallNode(RubyContext context, SourceSection sourceSection, boolean inBlock, boolean isSplatted, RubyNode[] reloadNodes, RubyNode block) {
        super(context, sourceSection);
        this.inBlock = inBlock;
        this.isSplatted = isSplatted;
        this.reloadNodes = reloadNodes;
        this.block = block;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object blockObject;
        Object self = RubyArguments.getSelf(frame.getArguments());
        if (!this.guard(frame, self)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookup(frame);
        }
        Object[] originalArguments = this.inBlock ? RubyArguments.getDeclarationFrame(frame.getArguments()).getArguments() : frame.getArguments();
        Object[] superArguments = new Object[this.reloadNodes.length];
        for (int n = 0; n < superArguments.length; ++n) {
            superArguments[n] = this.reloadNodes[n].execute(frame);
        }
        if (this.isSplatted) {
            CompilerDirectives.transferToInterpreter();
            assert (superArguments.length == 1);
            assert (superArguments[0] instanceof RubyArray);
            superArguments = ArrayNodes.slowToArray((RubyArray)superArguments[0]);
        }
        if (this.block != null) {
            blockObject = this.block.execute(frame);
            if (blockObject == this.nil()) {
                blockObject = null;
            }
        } else {
            blockObject = RubyArguments.getBlock(originalArguments);
        }
        return this.callNode.call(frame, RubyArguments.pack(this.superMethod, RubyArguments.getDeclarationFrame(originalArguments), RubyArguments.getSelf(originalArguments), (RubyProc)blockObject, superArguments));
    }
}

