/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.supercall.AbstractGeneralSuperCallNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;

public class GeneralSuperCallNode
extends AbstractGeneralSuperCallNode {
    private final boolean isSplatted;
    @Node.Child
    private RubyNode block;
    @Node.Children
    private final RubyNode[] arguments;

    public GeneralSuperCallNode(RubyContext context, SourceSection sourceSection, RubyNode block, RubyNode[] arguments, boolean isSplatted) {
        super(context, sourceSection);
        assert (arguments != null);
        assert (!isSplatted || arguments.length == 1);
        this.block = block;
        this.arguments = arguments;
        this.isSplatted = isSplatted;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object blockTempObject;
        Object self = RubyArguments.getSelf(frame.getArguments());
        Object[] argumentsObjects = new Object[this.arguments.length];
        CompilerAsserts.compilationConstant((Object)this.arguments.length);
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        RubyProc blockObject = this.block != null ? ((blockTempObject = this.block.execute(frame)) == this.nil() ? null : (RubyProc)blockTempObject) : null;
        if (!this.guard(frame, self)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookup(frame);
        }
        if (this.isSplatted) {
            RubyArray argumentsArray = (RubyArray)argumentsObjects[0];
            return this.callNode.call(frame, RubyArguments.pack(this.superMethod, this.superMethod.getDeclarationFrame(), self, blockObject, ArrayNodes.slowToArray(argumentsArray)));
        }
        return this.callNode.call(frame, RubyArguments.pack(this.superMethod, this.superMethod.getDeclarationFrame(), self, blockObject, argumentsObjects));
    }
}

