/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.defined.DefinedWrapperNode;
import org.jruby.truffle.nodes.exceptions.RescueNode;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.RetryException;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public class TryNode
extends RubyNode {
    @Node.Child
    private ExceptionTranslatingNode tryPart;
    @Node.Children
    final RescueNode[] rescueParts;
    @Node.Child
    private RubyNode elsePart;
    @Node.Child
    private WriteInstanceVariableNode clearExceptionVariableNode;
    private final BranchProfile elseProfile = BranchProfile.create();
    private final BranchProfile controlFlowProfile = BranchProfile.create();
    private final BranchProfile raiseExceptionProfile = BranchProfile.create();

    public TryNode(RubyContext context, SourceSection sourceSection, ExceptionTranslatingNode tryPart, RescueNode[] rescueParts, RubyNode elsePart) {
        super(context, sourceSection);
        this.tryPart = tryPart;
        this.rescueParts = rescueParts;
        this.elsePart = elsePart;
        this.clearExceptionVariableNode = new WriteInstanceVariableNode(context, sourceSection, "$!", new LiteralNode(context, sourceSection, context.getThreadManager().getCurrentThread().getThreadLocals()), new DefinedWrapperNode(context, sourceSection, new LiteralNode(context, sourceSection, context.getCoreLibrary().getNilObject()), "nil"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        Object result;
        while (true) {
            try {
                result = this.tryPart.execute(frame);
            }
            catch (ControlFlowException exception) {
                this.controlFlowProfile.enter();
                throw exception;
            }
            catch (RaiseException exception) {
                this.raiseExceptionProfile.enter();
                try {
                    Object object = this.handleException(frame, exception);
                    return object;
                }
                catch (RetryException e) {
                    this.getContext().getSafepointManager().poll(this);
                    continue;
                }
            }
            finally {
                this.clearExceptionVariableNode.execute(frame);
                continue;
            }
            break;
        }
        this.elseProfile.enter();
        this.elsePart.executeVoid(frame);
        return result;
    }

    private Object handleException(VirtualFrame frame, RaiseException exception) {
        CompilerDirectives.transferToInterpreter();
        RubyBasicObject threadLocals = this.getContext().getThreadManager().getCurrentThread().getThreadLocals();
        RubyBasicObject.setInstanceVariable(threadLocals, "$!", exception.getRubyException());
        for (RescueNode rescue : this.rescueParts) {
            if (!rescue.canHandle(frame, exception.getRubyException())) continue;
            return rescue.execute(frame);
        }
        throw exception;
    }
}

