/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;

public class ConcatHashLiteralNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;

    public ConcatHashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] children) {
        super(context, sourceSection);
        this.children = children;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (RubyNode child : this.children) {
            try {
                keyValues.addAll(HashOperations.verySlowToKeyValues(child.executeRubyHash(frame)));
            }
            catch (UnexpectedResultException e) {
                throw new UnsupportedOperationException(((Object)((Object)child)).getClass() + " " + e.getResult().getClass());
            }
        }
        return HashOperations.verySlowFromEntries(this.getContext(), keyValues, false);
    }
}

