/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.MutexNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=MutexNodes.class)
public final class MutexNodesFactory {
    public static List<NodeFactory<? extends UnaryCoreMethodNode>> getFactories() {
        return Arrays.asList(LockNodeFactory.getInstance(), IsLockedNodeFactory.getInstance(), IsOwnedNodeFactory.getInstance(), TryLockNodeFactory.getInstance(), UnlockNodeFactory.getInstance());
    }

    @GeneratedBy(value=MutexNodes.UnlockNode.class)
    public static final class UnlockNodeFactory
    extends NodeFactoryBase<MutexNodes.UnlockNode> {
        private static UnlockNodeFactory unlockNodeFactoryInstance;

        private UnlockNodeFactory() {
            super(MutexNodes.UnlockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.UnlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return UnlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.UnlockNode> getInstance() {
            if (unlockNodeFactoryInstance == null) {
                unlockNodeFactoryInstance = new UnlockNodeFactory();
            }
            return unlockNodeFactoryInstance;
        }

        public static MutexNodes.UnlockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new UnlockNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.UnlockNode.class)
        public static final class UnlockNodeGen
        extends MutexNodes.UnlockNode {
            @Node.Child
            private RubyNode operand_;

            private UnlockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.unlock(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.TryLockNode.class)
    public static final class TryLockNodeFactory
    extends NodeFactoryBase<MutexNodes.TryLockNode> {
        private static TryLockNodeFactory tryLockNodeFactoryInstance;

        private TryLockNodeFactory() {
            super(MutexNodes.TryLockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.TryLockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return TryLockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.TryLockNode> getInstance() {
            if (tryLockNodeFactoryInstance == null) {
                tryLockNodeFactoryInstance = new TryLockNodeFactory();
            }
            return tryLockNodeFactoryInstance;
        }

        public static MutexNodes.TryLockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new TryLockNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.TryLockNode.class)
        public static final class TryLockNodeGen
        extends MutexNodes.TryLockNode {
            @Node.Child
            private RubyNode operand_;

            private TryLockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.tryLock(operandValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
    public static final class IsOwnedNodeFactory
    extends NodeFactoryBase<MutexNodes.IsOwnedNode> {
        private static IsOwnedNodeFactory isOwnedNodeFactoryInstance;

        private IsOwnedNodeFactory() {
            super(MutexNodes.IsOwnedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.IsOwnedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return IsOwnedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.IsOwnedNode> getInstance() {
            if (isOwnedNodeFactoryInstance == null) {
                isOwnedNodeFactoryInstance = new IsOwnedNodeFactory();
            }
            return isOwnedNodeFactoryInstance;
        }

        public static MutexNodes.IsOwnedNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new IsOwnedNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
        public static final class IsOwnedNodeGen
        extends MutexNodes.IsOwnedNode {
            @Node.Child
            private RubyNode operand_;

            private IsOwnedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isOwned(operandValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.IsLockedNode.class)
    public static final class IsLockedNodeFactory
    extends NodeFactoryBase<MutexNodes.IsLockedNode> {
        private static IsLockedNodeFactory isLockedNodeFactoryInstance;

        private IsLockedNodeFactory() {
            super(MutexNodes.IsLockedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.IsLockedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return IsLockedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.IsLockedNode> getInstance() {
            if (isLockedNodeFactoryInstance == null) {
                isLockedNodeFactoryInstance = new IsLockedNodeFactory();
            }
            return isLockedNodeFactoryInstance;
        }

        public static MutexNodes.IsLockedNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new IsLockedNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.IsLockedNode.class)
        public static final class IsLockedNodeGen
        extends MutexNodes.IsLockedNode {
            @Node.Child
            private RubyNode operand_;

            private IsLockedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isLocked(operandValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.LockNode.class)
    public static final class LockNodeFactory
    extends NodeFactoryBase<MutexNodes.LockNode> {
        private static LockNodeFactory lockNodeFactoryInstance;

        private LockNodeFactory() {
            super(MutexNodes.LockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.LockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return LockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.LockNode> getInstance() {
            if (lockNodeFactoryInstance == null) {
                lockNodeFactoryInstance = new LockNodeFactory();
            }
            return lockNodeFactoryInstance;
        }

        public static MutexNodes.LockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new LockNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.LockNode.class)
        public static final class LockNodeGen
        extends MutexNodes.LockNode {
            @Node.Child
            private RubyNode operand_;

            private LockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.lock(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }
}

