/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.ArrayList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.arguments.CheckArityNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.coerce.NameToJavaStringNode;
import org.jruby.truffle.nodes.coerce.NameToJavaStringNodeGen;
import org.jruby.truffle.nodes.coerce.NameToSymbolOrStringNodeGen;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.constants.GetConstantNode;
import org.jruby.truffle.nodes.constants.GetConstantNodeGen;
import org.jruby.truffle.nodes.constants.LookupConstantNodeGen;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.core.RaiseIfFrozenNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.UnboundMethodNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.methods.AddMethodNode;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.IdUtil;

@CoreClass(name="Module")
public abstract class ModuleNodes {

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class SetMethodVisibilityNode
    extends RubyNode {
        private final Visibility visibility;
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;

        public SetMethodVisibilityNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        public abstract RubyModule executeSetMethodVisibility(VirtualFrame var1, RubyModule var2, Object var3);

        @Specialization
        RubyModule setMethodVisibility(VirtualFrame frame, RubyModule module, Object name) {
            String methodName = this.nameToJavaStringNode.executeToJavaString(frame, name);
            InternalMethod method = module.deepMethodSearch(methodName);
            if (method == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(methodName, module, this));
            }
            if (this.visibility == Visibility.MODULE_FUNCTION) {
                module.addMethod(this, method.withVisibility(Visibility.PRIVATE));
                this.singletonClassNode.executeSingletonClass(frame, module).addMethod(this, method.withVisibility(Visibility.PUBLIC));
            } else {
                module.addMethod(this, method.withVisibility(this.visibility));
            }
            return module;
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="names")})
    public static abstract class SetVisibilityNode
    extends RubyNode {
        private final Visibility visibility;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public SetVisibilityNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, visibility, null, null);
        }

        public abstract RubyModule executeSetVisibility(VirtualFrame var1, RubyModule var2, Object[] var3);

        @Specialization
        RubyModule setVisibility(VirtualFrame frame, RubyModule module, Object[] names) {
            CompilerDirectives.transferToInterpreter();
            if (names.length == 0) {
                this.setCurrentVisibility(this.visibility);
            } else {
                for (Object name : names) {
                    this.setMethodVisibilityNode.executeSetMethodVisibility(frame, module, name);
                }
            }
            return module;
        }

        private void setCurrentVisibility(Visibility visibility) {
            CompilerDirectives.transferToInterpreter();
            Frame callerFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_WRITE, true);
            assert (callerFrame != null);
            assert (callerFrame.getFrameDescriptor() != null);
            FrameSlot visibilitySlot = callerFrame.getFrameDescriptor().findOrAddFrameSlot(RubyModule.VISIBILITY_FRAME_SLOT_ID, (Object)"visibility for frame", FrameSlotKind.Object);
            callerFrame.setObject(visibilitySlot, (Object)visibility);
        }
    }

    @CoreMethod(names={"undef_method"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class UndefMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;
        @Node.Child
        RaiseIfFrozenNode raiseIfFrozenNode;
        @Node.Child
        CallDispatchHeadNode methodUndefinedNode;

        public UndefMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
            this.raiseIfFrozenNode = new RaiseIfFrozenNode(new SelfNode(context, sourceSection));
            this.methodUndefinedNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public RubyModule undefMethods(VirtualFrame frame, RubyModule module, Object[] names) {
            for (Object name : names) {
                this.undefMethod(frame, module, this.nameToJavaStringNode.executeToJavaString(frame, name));
            }
            return module;
        }

        private void undefMethod(VirtualFrame frame, RubyModule module, String name) {
            this.raiseIfFrozenNode.execute(frame);
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().noMethodErrorOnModule(name, module, this));
            }
            module.undefMethod((Node)this, method);
            this.methodUndefinedNode.call(frame, module, "method_undefined", null, this.getContext().getSymbol(name));
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toS(RubyModule module) {
            CompilerDirectives.transferToInterpreter();
            return this.createString(module.getName());
        }
    }

    @CoreMethod(names={"remove_method"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class RemoveMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;
        @Node.Child
        RaiseIfFrozenNode raiseIfFrozenNode;
        @Node.Child
        CallDispatchHeadNode methodRemovedNode;

        public RemoveMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
            this.raiseIfFrozenNode = new RaiseIfFrozenNode(new SelfNode(context, sourceSection));
            this.methodRemovedNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public RubyModule removeMethods(VirtualFrame frame, RubyModule module, Object[] names) {
            for (Object name : names) {
                this.removeMethod(frame, module, this.nameToJavaStringNode.executeToJavaString(frame, name));
            }
            return module;
        }

        private void removeMethod(VirtualFrame frame, RubyModule module, String name) {
            this.raiseIfFrozenNode.execute(frame);
            CompilerDirectives.transferToInterpreter();
            if (!module.getMethods().containsKey(name)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorMethodNotDefinedIn(module, name, this));
            }
            module.removeMethod(name);
            this.methodRemovedNode.call(frame, module, "method_removed", null, this.getContext().getSymbol(name));
        }
    }

    @CoreMethod(names={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class RemoveConstNode
    extends CoreMethodNode {
        public RemoveConstNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        Object removeConstant(RubyModule module, String name) {
            RubyConstant oldConstant = module.removeConstant(this, name);
            if (oldConstant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorConstantNotDefined(module, name, this));
            }
            return oldConstant.getValue();
        }
    }

    @CoreMethod(names={"remove_class_variable"}, required=1)
    public static abstract class RemoveClassVariableNode
    extends CoreMethodArrayArgumentsNode {
        public RemoveClassVariableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyModule removeClassVariable(RubyModule module, RubyString name) {
            CompilerDirectives.transferToInterpreter();
            module.removeClassVariable(this, name.toString());
            return module;
        }

        @Specialization
        public RubyModule removeClassVariable(RubyModule module, RubySymbol name) {
            CompilerDirectives.transferToInterpreter();
            module.removeClassVariable(this, name.toString());
            return module;
        }
    }

    @CoreMethod(names={"protected"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class ProtectedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public ProtectedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PROTECTED, null, null);
        }

        @Specialization
        public RubyModule doProtected(VirtualFrame frame, RubyModule module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"public_constant"}, argumentsAsArray=true)
    public static abstract class PublicConstantNode
    extends CoreMethodArrayArgumentsNode {
        public PublicConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyModule publicConstant(RubyModule module, Object[] args) {
            CompilerDirectives.transferToInterpreter();
            for (Object name : args) {
                if (!(name instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                module.changeConstantVisibility(this, name.toString(), false);
            }
            return module;
        }
    }

    @CoreMethod(names={"private_constant"}, argumentsAsArray=true)
    public static abstract class PrivateConstantNode
    extends CoreMethodArrayArgumentsNode {
        public PrivateConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyModule privateConstant(RubyModule module, Object[] args) {
            CompilerDirectives.transferToInterpreter();
            for (Object name : args) {
                if (!(name instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                module.changeConstantVisibility(this, name.toString(), true);
            }
            return module;
        }
    }

    @CoreMethod(names={"instance_method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class InstanceMethodNode
    extends CoreMethodNode {
        public InstanceMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public RubyBasicObject instanceMethod(RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null || method.isUndefined()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, module, this));
            }
            return UnboundMethodNodes.createUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodClass(), module, method);
        }
    }

    @CoreMethod(names={"instance_methods"}, optional=1)
    public static abstract class InstanceMethodsNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject instanceMethods(RubyModule module, NotProvided argument) {
            return this.instanceMethods(module, true);
        }

        @Specialization
        public RubyBasicObject instanceMethods(RubyModule module, boolean includeAncestors) {
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), module.filterMethods(includeAncestors, RubyModule.MethodFilter.PUBLIC_PROTECTED).toArray());
        }
    }

    @CoreMethod(names={"public_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class PublicMethodDefinedNode
    extends CoreMethodNode {
        public PublicMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isPublicMethodDefined(RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility() == Visibility.PUBLIC;
        }
    }

    @CoreMethod(names={"public_instance_methods"}, optional=1)
    public static abstract class PublicInstanceMethodsNode
    extends CoreMethodArrayArgumentsNode {
        public PublicInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject publicInstanceMethods(RubyModule module, NotProvided includeAncestors) {
            return this.publicInstanceMethods(module, true);
        }

        @Specialization
        public RubyBasicObject publicInstanceMethods(RubyModule module, boolean includeAncestors) {
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), module.filterMethods(includeAncestors, RubyModule.MethodFilter.PUBLIC).toArray());
        }
    }

    @CoreMethod(names={"public_instance_method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class PublicInstanceMethodNode
    extends CoreMethodNode {
        public PublicInstanceMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public RubyBasicObject publicInstanceMethod(RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null || method.isUndefined()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, module, this));
            }
            if (method.getVisibility() != Visibility.PUBLIC) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateMethod(name, module, this));
            }
            return UnboundMethodNodes.createUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodClass(), module, method);
        }
    }

    @CoreMethod(names={"private_instance_methods"}, optional=1)
    public static abstract class PrivateInstanceMethodsNode
    extends CoreMethodArrayArgumentsNode {
        public PrivateInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject privateInstanceMethods(RubyModule module, NotProvided includeAncestors) {
            return this.privateInstanceMethods(module, true);
        }

        @Specialization
        public RubyBasicObject privateInstanceMethods(RubyModule module, boolean includeAncestors) {
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), module.filterMethods(includeAncestors, RubyModule.MethodFilter.PRIVATE).toArray());
        }
    }

    @CoreMethod(names={"protected_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ProtectedMethodDefinedNode
    extends CoreMethodNode {
        public ProtectedMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isProtectedMethodDefined(RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility().isProtected();
        }
    }

    @CoreMethod(names={"protected_instance_methods"}, optional=1)
    public static abstract class ProtectedInstanceMethodsNode
    extends CoreMethodArrayArgumentsNode {
        public ProtectedInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject protectedInstanceMethods(RubyModule module, NotProvided includeAncestors) {
            return this.protectedInstanceMethods(module, true);
        }

        @Specialization
        public RubyBasicObject protectedInstanceMethods(RubyModule module, boolean includeAncestors) {
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), module.filterMethods(includeAncestors, RubyModule.MethodFilter.PROTECTED).toArray());
        }
    }

    @CoreMethod(names={"private_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class PrivateMethodDefinedNode
    extends CoreMethodNode {
        public PrivateMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isPrivateMethodDefined(RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility().isPrivate();
        }
    }

    @CoreMethod(names={"private_class_method"}, argumentsAsArray=true)
    public static abstract class PrivateClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public PrivateClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, Visibility.PRIVATE, null, null);
        }

        @Specialization
        public RubyModule privateClassMethod(VirtualFrame frame, RubyModule module, Object[] names) {
            RubyClass singletonClass = this.singletonClassNode.executeSingletonClass(frame, module);
            for (Object name : names) {
                this.setMethodVisibilityNode.executeSetMethodVisibility(frame, singletonClass, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"private"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class PrivateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public PrivateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PRIVATE, null, null);
        }

        public abstract RubyModule executePrivate(VirtualFrame var1, RubyModule var2, Object[] var3);

        @Specialization
        public RubyModule doPrivate(VirtualFrame frame, RubyModule module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"public_class_method"}, argumentsAsArray=true)
    public static abstract class PublicClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public PublicClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, Visibility.PUBLIC, null, null);
        }

        @Specialization
        RubyModule publicClassMethod(VirtualFrame frame, RubyModule module, Object[] names) {
            RubyClass singletonClass = this.singletonClassNode.executeSingletonClass(frame, module);
            for (Object name : names) {
                this.setMethodVisibilityNode.executeSetMethodVisibility(frame, singletonClass, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"public"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class PublicNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public PublicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PUBLIC, null, null);
        }

        public abstract RubyModule executePublic(VirtualFrame var1, RubyModule var2, Object[] var3);

        @Specialization
        public RubyModule doPublic(VirtualFrame frame, RubyModule module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"nesting"}, onSingleton=true)
    public static abstract class NestingNode
    extends CoreMethodArrayArgumentsNode {
        public NestingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject nesting() {
            RubyModule enclosing;
            CompilerDirectives.transferToInterpreter();
            ArrayList<RubyModule> modules = new ArrayList<RubyModule>();
            InternalMethod method = RubyCallStack.getCallingMethod(this.getContext());
            RubyClass object = this.getContext().getCoreLibrary().getObjectClass();
            for (LexicalScope lexicalScope = method == null ? null : method.getSharedMethodInfo().getLexicalScope(); lexicalScope != null && (enclosing = lexicalScope.getLiveModule()) != object; lexicalScope = lexicalScope.getParent()) {
                modules.add(enclosing);
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), modules.toArray(new Object[modules.size()]));
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object name(RubyModule module) {
            CompilerDirectives.transferToInterpreter();
            if (!module.hasPartialName()) {
                return this.nil();
            }
            return this.createString(module.getName());
        }
    }

    @CoreMethod(names={"module_function"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class ModuleFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public ModuleFunctionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.MODULE_FUNCTION, null, null);
        }

        @Specialization
        public RubyModule moduleFunction(VirtualFrame frame, RubyModule module, Object[] names) {
            if (module instanceof RubyClass && !this.getContext().getCoreLibrary().isLoadingRubyCore()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("module_function must be called for modules", this));
            }
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"method_defined?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class MethodDefinedNode
    extends CoreMethodNode {
        public MethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isMethodDefined(RubyModule module, String name, NotProvided inherit) {
            return this.isMethodDefined(module, name, true);
        }

        @Specialization
        public boolean isMethodDefined(RubyModule module, String name, boolean inherit) {
            CompilerDirectives.transferToInterpreter();
            InternalMethod method = inherit ? ModuleOperations.lookupMethod(module, name) : module.getMethods().get(name);
            return method != null && !method.getVisibility().isPrivate();
        }
    }

    @CoreMethod(names={"included_modules"})
    public static abstract class IncludedModulesNode
    extends CoreMethodArrayArgumentsNode {
        public IncludedModulesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject includedModules(RubyModule module) {
            CompilerDirectives.transferToInterpreter();
            ArrayList<RubyModule> modules = new ArrayList<RubyModule>();
            for (RubyModule included : module.parentAncestors()) {
                if (!included.isOnlyAModule()) continue;
                modules.add(included);
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), modules.toArray(new Object[modules.size()]));
        }
    }

    @CoreMethod(names={"included"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class IncludedNode
    extends CoreMethodArrayArgumentsNode {
        public IncludedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject included(Object subclass) {
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isRubyClass(self)", "!isRubyClass(from)"})
        public Object initializeCopy(RubyModule self, RubyModule from) {
            CompilerDirectives.transferToInterpreter();
            self.initCopy(from);
            return this.nil();
        }

        @Specialization
        public Object initializeCopy(RubyClass self, RubyClass from) {
            CompilerDirectives.transferToInterpreter();
            if (from == this.getContext().getCoreLibrary().getBasicObjectClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't copy the root class", this));
            }
            if (from.isSingleton()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't copy singleton class", this));
            }
            self.initCopy(from);
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassExecNode classExecNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract RubyModule executeInitialize(VirtualFrame var1, RubyModule var2, RubyProc var3);

        void classEval(VirtualFrame frame, RubyModule module, RubyProc block) {
            if (this.classExecNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.classExecNode = (ClassExecNode)this.insert(ModuleNodesFactory.ClassExecNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            this.classExecNode.executeClassExec(frame, module, new Object[0], block);
        }

        @Specialization
        public RubyModule initialize(RubyModule module, NotProvided block) {
            return module;
        }

        @Specialization
        public RubyModule initialize(VirtualFrame frame, RubyModule module, RubyProc block) {
            this.classEval(frame, module, block);
            return module;
        }
    }

    @CoreMethod(names={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class ExtendObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public ExtendObjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject extendObject(VirtualFrame frame, RubyModule module, RubyBasicObject object) {
            if (module instanceof RubyClass) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorWrongArgumentType(module, "Module", this));
            }
            this.singletonClassNode.executeSingletonClass(frame, object).include(this, module);
            return module;
        }
    }

    @CoreMethod(names={"define_method"}, needsBlock=true, required=1, optional=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="proc"), @NodeChild(type=RubyNode.class, value="block")})
    public static abstract class DefineMethodNode
    extends CoreMethodNode {
        public DefineMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubySymbol defineMethod(RubyModule module, String name, NotProvided proc, NotProvided block) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("needs either proc or block", this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubySymbol defineMethod(RubyModule module, String name, NotProvided proc, RubyProc block) {
            return this.defineMethod(module, name, block, NotProvided.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubySymbol defineMethod(RubyModule module, String name, RubyProc proc, NotProvided block) {
            return this.defineMethod(module, name, proc);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyMethod(method)"})
        public RubySymbol defineMethod(RubyModule module, String name, RubyBasicObject method, NotProvided block) {
            module.addMethod(this, MethodNodes.getMethod(method).withName(name));
            return this.getContext().getSymbolTable().getSymbol(name);
        }

        @Specialization(guards={"isRubyUnboundMethod(method)"})
        public RubySymbol defineMethod(VirtualFrame frame, RubyModule module, String name, RubyBasicObject method, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            RubyModule origin = UnboundMethodNodes.getOrigin(method);
            if (!ModuleOperations.canBindMethodTo(origin, module)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("bind argument must be a subclass of " + origin.getName(), this));
            }
            return this.addMethod(module, name, UnboundMethodNodes.getMethod(method));
        }

        private RubySymbol defineMethod(RubyModule module, String name, RubyProc proc) {
            CompilerDirectives.transferToInterpreter();
            CallTarget modifiedCallTarget = proc.getCallTargetForLambdas();
            SharedMethodInfo info = proc.getSharedMethodInfo().withName(name);
            InternalMethod modifiedMethod = new InternalMethod(info, name, module, Visibility.PUBLIC, false, modifiedCallTarget, proc.getDeclarationFrame());
            return this.addMethod(module, name, modifiedMethod);
        }

        private RubySymbol addMethod(RubyModule module, String name, InternalMethod method) {
            method = method.withName(name);
            if (ModuleOperations.isMethodPrivateFromName(name)) {
                method = method.withVisibility(Visibility.PRIVATE);
            }
            module.addMethod(this, method);
            return this.getContext().getSymbolTable().getSymbol(name);
        }
    }

    @CoreMethod(names={"const_set"}, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class ConstSetNode
    extends CoreMethodNode {
        public ConstSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public Object setConstant(RubyModule module, String name, Object value) {
            CompilerDirectives.transferToInterpreter();
            if (!IdUtil.isValidConstantName19((String)name)) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("wrong constant name %s", name), name, this));
            }
            module.setConstant(this, name, value);
            return value;
        }
    }

    @CoreMethod(names={"const_missing"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ConstMissingNode
    extends CoreMethodNode {
        public ConstMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public Object methodMissing(RubyModule module, String name) {
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, name, this));
        }
    }

    @CoreMethod(names={"const_get"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class ConstGetNode
    extends CoreMethodNode {
        @Node.Child
        private GetConstantNode getConstantNode;

        public ConstGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.getConstantNode = GetConstantNodeGen.create(context, sourceSection, null, null, LookupConstantNodeGen.create(context, sourceSection, LexicalScope.NONE, null, null));
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public Object getConstant(VirtualFrame frame, RubyModule module, RubySymbol name, NotProvided inherit) {
            return this.getConstant(frame, module, name, true);
        }

        @Specialization(guards={"inherit"})
        public Object getConstant(VirtualFrame frame, RubyModule module, RubySymbol name, boolean inherit) {
            return this.getConstantNode.executeGetConstant(frame, module, name.toString());
        }

        @Specialization(guards={"!inherit"})
        public Object getConstantNoInherit(VirtualFrame frame, RubyModule module, RubySymbol name, boolean inherit) {
            return this.getConstantNoInherit(module, name.toString(), this);
        }

        @Specialization(guards={"!isScoped(name)"})
        public Object getConstant(VirtualFrame frame, RubyModule module, RubyString name, NotProvided inherit) {
            return this.getConstant(frame, module, name, true);
        }

        @Specialization(guards={"inherit", "!isScoped(name)"})
        public Object getConstant(VirtualFrame frame, RubyModule module, RubyString name, boolean inherit) {
            return this.getConstantNode.executeGetConstant(frame, module, name.toString());
        }

        @Specialization(guards={"!inherit", "!isScoped(name)"})
        public Object getConstantNoInherit(VirtualFrame frame, RubyModule module, RubyString name, boolean inherit) {
            return this.getConstantNoInherit(module, name.toString(), this);
        }

        @Specialization(guards={"isScoped(fullName)"})
        public Object getConstantScoped(VirtualFrame frame, RubyModule module, RubyString fullName, NotProvided inherit) {
            return this.getConstantScoped(frame, module, fullName, true);
        }

        @Specialization(guards={"isScoped(fullName)"})
        public Object getConstantScoped(VirtualFrame frame, RubyModule module, RubyString fullName, boolean inherit) {
            return this.getConstantScoped(module, fullName.toString(), inherit);
        }

        @CompilerDirectives.TruffleBoundary
        private Object getConstantNoInherit(RubyModule module, String name, Node currentNode) {
            RubyConstant constant = ModuleOperations.lookupConstantWithInherit(this.getContext(), module, name, false, currentNode);
            if (constant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, name, this));
            }
            return constant.getValue();
        }

        @CompilerDirectives.TruffleBoundary
        private Object getConstantScoped(RubyModule module, String fullName, boolean inherit) {
            RubyConstant constant = ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this);
            if (constant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, fullName, this));
            }
            return constant.getValue();
        }

        @CompilerDirectives.TruffleBoundary
        boolean isScoped(RubyString name) {
            return name.toString().contains("::");
        }
    }

    @CoreMethod(names={"const_defined?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class ConstDefinedNode
    extends CoreMethodNode {
        public ConstDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isConstDefined(RubyModule module, String name, NotProvided inherit) {
            return this.isConstDefined(module, name, true);
        }

        @Specialization
        public boolean isConstDefined(RubyModule module, String fullName, boolean inherit) {
            CompilerDirectives.transferToInterpreter();
            return ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this) != null;
        }
    }

    @CoreMethod(names={"constants"}, optional=1)
    public static abstract class ConstantsNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        BooleanCastNode booleanCastNode;

        public ConstantsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        private boolean booleanCast(VirtualFrame frame, Object value) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.booleanCastNode.executeBoolean(frame, value);
        }

        @Specialization
        public RubyBasicObject constants(RubyModule module, NotProvided inherit) {
            return this.constants(module, true);
        }

        @Specialization
        public RubyBasicObject constants(RubyModule module, boolean inherit) {
            CompilerDirectives.transferToInterpreter();
            ArrayList<RubySymbol> constantsArray = new ArrayList<RubySymbol>();
            Map<String, RubyConstant> constants = inherit ? ModuleOperations.getAllConstants(module) : module.getConstants();
            for (Map.Entry<String, RubyConstant> constant : constants.entrySet()) {
                if (constant.getValue().isPrivate()) continue;
                constantsArray.add(this.getContext().getSymbol(constant.getKey()));
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), constantsArray.toArray(new Object[constantsArray.size()]));
        }

        @Specialization(guards={"wasProvided(inherit)"})
        public RubyBasicObject constants(VirtualFrame frame, RubyModule module, Object inherit) {
            return this.constants(module, this.booleanCast(frame, inherit));
        }
    }

    @CoreMethod(names={"class_variables"})
    public static abstract class ClassVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public ClassVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject getClassVariables(RubyModule module) {
            CompilerDirectives.transferToInterpreter();
            RubyBasicObject array = ArrayNodes.createEmptyArray(module.getContext().getCoreLibrary().getArrayClass());
            for (String variable : ModuleOperations.getAllClassVariables(module).keySet()) {
                ArrayNodes.slowPush(array, RubySymbol.newSymbol(module.getContext(), variable));
            }
            return array;
        }
    }

    @CoreMethod(names={"class_variable_get"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ClassVariableGetNode
    extends CoreMethodNode {
        public ClassVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public Object getClassVariable(RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            RubyContext.checkClassVariableName(this.getContext(), name, this);
            Object value = ModuleOperations.lookupClassVariable(module, name);
            if (value == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedClassVariable(module, name, this));
            }
            return value;
        }
    }

    @CoreMethod(names={"class_variable_defined?"}, required=1)
    public static abstract class ClassVariableDefinedNode
    extends CoreMethodArrayArgumentsNode {
        public ClassVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isClassVariableDefined(RubyModule module, RubyString name) {
            CompilerDirectives.transferToInterpreter();
            return module.getClassVariables().containsKey(name.toString());
        }

        @Specialization
        public boolean isClassVariableDefined(RubyModule module, RubySymbol name) {
            CompilerDirectives.transferToInterpreter();
            return module.getClassVariables().containsKey(name.toString());
        }
    }

    @CoreMethod(names={"class_exec", "module_exec"}, argumentsAsArray=true, needsBlock=true)
    public static abstract class ClassExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public ClassExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context);
        }

        public abstract Object executeClassExec(VirtualFrame var1, RubyModule var2, Object[] var3, RubyProc var4);

        @Specialization
        public Object classExec(VirtualFrame frame, RubyModule self, Object[] args, RubyProc block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, self, args);
        }

        @Specialization
        public Object classExec(VirtualFrame frame, RubyModule self, Object[] args, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().noBlockGiven(this));
        }
    }

    @CoreMethod(names={"class_eval", "module_eval"}, optional=3, needsBlock=true)
    public static abstract class ClassEvalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yield;
        @Node.Child
        private KernelNodes.BindingNode bindingNode;
        @Node.Child
        private ToStrNode toStrNode;

        public ClassEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context);
        }

        protected RubyBinding getCallerBinding(VirtualFrame frame) {
            if (this.bindingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bindingNode = (KernelNodes.BindingNode)this.insert(KernelNodesFactory.BindingNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.bindingNode.executeRubyBinding(frame);
        }

        protected RubyBasicObject toStr(VirtualFrame frame, Object object) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.toStrNode.executeRubyString(frame, object);
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, NotProvided file, NotProvided line, NotProvided block) {
            return this.classEvalSource(frame, module, code, "(eval)");
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, RubyString file, NotProvided line, NotProvided block) {
            return this.classEvalSource(frame, module, code, file.toString());
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, RubyString file, int line, NotProvided block) {
            return this.classEvalSource(frame, module, code, file.toString());
        }

        @Specialization(guards={"wasProvided(code)"})
        public Object classEval(VirtualFrame frame, RubyModule module, Object code, NotProvided file, NotProvided line, NotProvided block) {
            return this.classEvalSource(frame, module, (RubyString)this.toStr(frame, code), file.toString());
        }

        @Specialization(guards={"wasProvided(file)"})
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, Object file, NotProvided line, NotProvided block) {
            return this.classEvalSource(frame, module, code, this.toStr(frame, file).toString());
        }

        private Object classEvalSource(VirtualFrame frame, RubyModule module, RubyString code, String file) {
            RubyBinding binding = this.getCallerBinding(frame);
            Encoding encoding = StringNodes.getByteList(code).getEncoding();
            CompilerDirectives.transferToInterpreter();
            Source source = Source.fromText((CharSequence)code.toString(), (String)file);
            return this.getContext().execute(source, encoding, TranslatorDriver.ParserContext.MODULE, module, binding.getFrame(), this, new NodeWrapper(){

                @Override
                public RubyNode wrap(RubyNode node) {
                    return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), Visibility.PUBLIC, "class_eval", node);
                }
            });
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule self, NotProvided code, NotProvided file, NotProvided line, RubyProc block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, self, new Object[0]);
        }

        @Specialization
        public Object classEval(RubyModule self, NotProvided code, NotProvided file, NotProvided line, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(0, 1, 2, this));
        }

        @Specialization(guards={"wasProvided(code)"})
        public Object classEval(RubyModule self, Object code, NotProvided file, NotProvided line, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(1, 0, this));
        }
    }

    @CoreMethod(names={"autoload?"}, required=1)
    public static abstract class AutoloadQueryNode
    extends CoreMethodArrayArgumentsNode {
        public AutoloadQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object autoloadQuery(RubyModule module, RubySymbol name) {
            return this.autoloadQuery(module, name.toString());
        }

        @Specialization
        public Object autoloadQuery(RubyModule module, RubyString name) {
            return this.autoloadQuery(module, name.toString());
        }

        private Object autoloadQuery(RubyModule module, String name) {
            RubyConstant constant = ModuleOperations.lookupConstant(this.getContext(), LexicalScope.NONE, module, name);
            if (constant == null || !constant.isAutoload()) {
                return this.nil();
            }
            return constant.getValue();
        }
    }

    @CoreMethod(names={"autoload"}, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="filename")})
    public static abstract class AutoloadNode
    extends CoreMethodNode {
        @Node.Child
        private StringNodes.EmptyNode emptyNode;
        private final ConditionProfile invalidConstantName = ConditionProfile.createBinaryProfile();
        private final ConditionProfile emptyFilename = ConditionProfile.createBinaryProfile();

        public AutoloadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.emptyNode = StringNodesFactory.EmptyNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        @CreateCast(value={"filename"})
        public RubyNode coerceFilenameToString(RubyNode filename) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), filename);
        }

        @Specialization
        public RubyBasicObject autoload(RubyModule module, RubySymbol name, RubyString filename) {
            return this.autoload(module, name.toString(), filename);
        }

        @Specialization
        public RubyBasicObject autoload(RubyModule module, RubyString name, RubyString filename) {
            return this.autoload(module, name.toString(), filename);
        }

        private RubyBasicObject autoload(RubyModule module, String name, RubyString filename) {
            if (this.invalidConstantName.profile(!IdUtil.isValidConstantName19((String)name))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("autoload must be constant name: %s", name), name, this));
            }
            if (this.emptyFilename.profile(this.emptyNode.empty(filename))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("empty file name", this));
            }
            module.setAutoloadConstant(this, name, filename);
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_writer"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrWriterNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrWriterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public RubyBasicObject attrWriter(VirtualFrame frame, RubyModule module, Object[] names) {
            for (Object name : names) {
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_reader"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrReaderNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;

        public AttrReaderNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
        }

        @Specialization
        public RubyBasicObject attrReader(VirtualFrame frame, RubyModule module, Object[] names) {
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_accessor"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrAccessorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrAccessorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public RubyBasicObject attrAccessor(VirtualFrame frame, RubyModule module, Object[] names) {
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public RubyBasicObject attr(VirtualFrame frame, RubyModule module, Object[] names) {
            boolean setter;
            CompilerDirectives.transferToInterpreter();
            if (names.length == 2 && names[1] instanceof Boolean) {
                setter = (Boolean)names[1];
                names = new Object[]{names[0]};
            } else {
                setter = false;
            }
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
                if (!setter) continue;
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class GenerateAccessorNode
    extends RubyNode {
        final boolean isGetter;
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;

        public GenerateAccessorNode(RubyContext context, SourceSection sourceSection, boolean isGetter) {
            super(context, sourceSection);
            this.isGetter = isGetter;
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
        }

        public abstract RubyBasicObject executeGenerateAccessor(VirtualFrame var1, RubyModule var2, Object var3);

        @Specialization
        public RubyBasicObject generateAccessor(VirtualFrame frame, RubyModule module, Object nameObject) {
            RubyNode accessInstanceVariable;
            String name = this.nameToJavaStringNode.executeToJavaString(frame, nameObject);
            CompilerDirectives.transferToInterpreter();
            FrameInstance callerFrame = Truffle.getRuntime().getCallerFrame();
            SourceSection sourceSection = callerFrame.getCallNode().getEncapsulatingSourceSection();
            Visibility visibility = AddMethodNode.getVisibility(callerFrame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
            Arity arity = this.isGetter ? Arity.NO_ARGUMENTS : Arity.ONE_REQUIRED;
            String ivar = "@" + name;
            String accessorName = this.isGetter ? name : name + "=";
            String indicativeName = name + "(attr_" + (this.isGetter ? "reader" : "writer") + ")";
            CheckArityNode checkArity = new CheckArityNode(this.getContext(), sourceSection, arity);
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, LexicalScope.NONE, arity, indicativeName, false, null, false);
            SelfNode self = new SelfNode(this.getContext(), sourceSection);
            if (this.isGetter) {
                accessInstanceVariable = new ReadInstanceVariableNode(this.getContext(), sourceSection, ivar, self, false);
            } else {
                ReadPreArgumentNode readArgument = new ReadPreArgumentNode(this.getContext(), sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
                accessInstanceVariable = new WriteInstanceVariableNode(this.getContext(), sourceSection, ivar, self, readArgument, false);
            }
            RubyNode sequence = SequenceNode.sequence(this.getContext(), sourceSection, checkArity, accessInstanceVariable);
            RubyRootNode rootNode = new RubyRootNode(this.getContext(), sourceSection, null, sharedMethodInfo, sequence);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            InternalMethod method = new InternalMethod(sharedMethodInfo, accessorName, module, visibility, false, (CallTarget)callTarget, null);
            module.addMethod(this, method);
            return this.nil();
        }
    }

    @CoreMethod(names={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class AppendFeaturesNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        TaintResultNode taintResultNode;

        public AppendFeaturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject appendFeatures(RubyModule features, RubyModule target) {
            if (features instanceof RubyClass) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("append_features must be called only on modules", this));
            }
            target.include(this, features);
            this.taintResultNode.maybeTaint(features, target);
            return this.nil();
        }
    }

    @CoreMethod(names={"ancestors"})
    public static abstract class AncestorsNode
    extends CoreMethodArrayArgumentsNode {
        public AncestorsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject ancestors(RubyModule self) {
            CompilerDirectives.transferToInterpreter();
            ArrayList<RubyModule> ancestors = new ArrayList<RubyModule>();
            for (RubyModule module : self.ancestors()) {
                ancestors.add(module);
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), ancestors.toArray(new Object[ancestors.size()]));
        }
    }

    @CoreMethod(names={"alias_method"}, required=2, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="newName"), @NodeChild(type=RubyNode.class, value="oldName")})
    public static abstract class AliasMethodNode
    extends CoreMethodNode {
        public AliasMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"newName"})
        public RubyNode coercetNewNameToString(RubyNode newName) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), newName);
        }

        @CreateCast(value={"oldName"})
        public RubyNode coerceOldNameToString(RubyNode oldName) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), oldName);
        }

        @Specialization
        public RubyModule aliasMethod(RubyModule module, String newName, String oldName) {
            CompilerDirectives.transferToInterpreter();
            module.alias(this, newName, oldName);
            return module;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsSubclassOfOrEqualToNode subclassNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        private Object isSubclass(VirtualFrame frame, RubyModule self, RubyModule other) {
            if (this.subclassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.subclassNode = (IsSubclassOfOrEqualToNode)this.insert(ModuleNodesFactory.IsSubclassOfOrEqualToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.subclassNode.executeIsSubclassOfOrEqualTo(frame, self, other);
        }

        private boolean booleanCast(VirtualFrame frame, Object value) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.booleanCastNode.executeBoolean(frame, value);
        }

        @Specialization
        public Object compare(VirtualFrame frame, RubyModule self, RubyModule other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other) {
                return 0;
            }
            Object isSubclass = this.isSubclass(frame, self, other);
            if (isSubclass == this.nil()) {
                return this.nil();
            }
            if (this.booleanCast(frame, isSubclass)) {
                return -1;
            }
            return 1;
        }

        @Specialization
        public Object compare(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            CompilerDirectives.transferToInterpreter();
            return this.nil();
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class IsSuperclassOfOrEqualToNode
    extends CoreMethodArrayArgumentsNode {
        public IsSuperclassOfOrEqualToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeIsSuperclassOfOrEqualTo(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSuperclassOfOrEqualTo(VirtualFrame frame, RubyModule self, RubyModule other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other || ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return this.nil();
        }

        @Specialization
        public Object isSuperclassOfOrEqualTo(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class IsSuperclassOfNode
    extends CoreMethodArrayArgumentsNode {
        public IsSuperclassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeIsSuperclassOf(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSuperclassOf(VirtualFrame frame, RubyModule self, RubyModule other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return this.nil();
        }

        @Specialization
        public Object isSuperclassOf(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class IsSubclassOfOrEqualToNode
    extends CoreMethodArrayArgumentsNode {
        public IsSubclassOfOrEqualToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeIsSubclassOfOrEqualTo(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSubclassOfOrEqualTo(VirtualFrame frame, RubyModule self, RubyModule other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other || ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return this.nil();
        }

        @Specialization
        public Object isSubclassOfOrEqualTo(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class IsSubclassOfNode
    extends CoreMethodArrayArgumentsNode {
        public IsSubclassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeIsSubclassOf(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSubclassOf(VirtualFrame frame, RubyModule self, RubyModule other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return this.nil();
        }

        @Specialization
        public Object isSubclassOf(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class ContainsInstanceNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public ContainsInstanceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public boolean containsInstance(RubyModule module, RubyBasicObject instance) {
            return this.includes(instance.getMetaClass(), module);
        }

        @Specialization(guards={"!isRubyBasicObject(instance)"})
        public boolean containsInstance(VirtualFrame frame, RubyModule module, Object instance) {
            return this.includes(this.metaClassNode.executeMetaClass(frame, instance), module);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean includes(RubyModule metaClass, RubyModule module) {
            return ModuleOperations.includesModule(metaClass, module);
        }
    }
}

