/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.FloatNodes;
import org.jruby.truffle.nodes.core.FloatNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToIntNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toIntNode;
    @Node.Child
    private FloatNodes.ToINode floatToIntNode;

    public ToIntNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public int doInt(VirtualFrame frame, Object object) {
        Object integerObject = this.executeIntOrLong(frame, object);
        if (integerObject instanceof Integer) {
            return (Integer)integerObject;
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException();
    }

    public abstract Object executeIntOrLong(VirtualFrame var1, Object var2);

    @Specialization
    public int coerceInt(int value) {
        return value;
    }

    @Specialization
    public long coerceLong(long value) {
        return value;
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public RubyBasicObject coerceRubyBignum(RubyBasicObject value) {
        return value;
    }

    @Specialization
    public Object coerceDouble(VirtualFrame frame, double value) {
        if (this.floatToIntNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.floatToIntNode = (FloatNodes.ToINode)this.insert(FloatNodesFactory.ToINodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
        }
        return this.floatToIntNode.executeToI(frame, value);
    }

    @Specialization
    public Object coerceBoolean(VirtualFrame frame, boolean value) {
        return this.coerceObject(frame, value);
    }

    @Specialization(guards={"!isRubyBignum(object)"})
    public Object coerceBasicObject(VirtualFrame frame, RubyBasicObject object) {
        return this.coerceObject(frame, object);
    }

    private Object coerceObject(VirtualFrame frame, Object object) {
        Object coerced;
        if (this.toIntNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toIntNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        try {
            coerced = this.toIntNode.call(frame, object, "to_int", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (e.getRubyException().getLogicalClass() == this.getContext().getCoreLibrary().getNoMethodErrorClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(object, "Integer", this));
            }
            throw e;
        }
        if (this.getContext().getCoreLibrary().getLogicalClass(coerced) == this.getContext().getCoreLibrary().getFixnumClass()) {
            return coerced;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorBadCoercion(object, "Integer", "to_int", coerced, this));
    }
}

