/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.RequiredKeywordArgumentValueNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.truffle.nodes.ReadNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.array.PrimitiveArrayNodeFactory;
import org.jruby.truffle.nodes.cast.ArrayCastNodeFactory;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.ArraySliceNodeFactory;
import org.jruby.truffle.nodes.literal.ArrayLiteralNode;
import org.jruby.truffle.nodes.literal.NilLiteralNode;
import org.jruby.truffle.nodes.methods.arguments.IsNilNode;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.MissingKeywordArgumentNode;
import org.jruby.truffle.nodes.methods.arguments.ReadBlockNode;
import org.jruby.truffle.nodes.methods.arguments.ReadKeywordArgumentNode;
import org.jruby.truffle.nodes.methods.arguments.ReadKeywordRestArgumentNode;
import org.jruby.truffle.nodes.methods.arguments.ReadOptionalArgumentNode;
import org.jruby.truffle.nodes.methods.arguments.ReadPostArgumentNode;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.methods.arguments.ReadRestArgumentNode;
import org.jruby.truffle.nodes.methods.locals.ReadLocalVariableNodeFactory;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.ParameterCollector;
import org.jruby.truffle.translator.Translator;

public class LoadArgumentsTranslator
extends Translator {
    private final boolean isBlock;
    private final BodyTranslator methodBodyTranslator;
    private final Deque<ArraySlot> arraySlotStack = new ArrayDeque<ArraySlot>();
    private int required;
    private int index;
    private int kwIndex;
    private int countKwArgs;
    private int indexFromEnd = 1;
    private State state;
    private boolean hasKeywordArguments;
    private List<String> excludedKeywords = new ArrayList<String>();
    private ArgsNode argsNode;

    public LoadArgumentsTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, Source source, boolean isBlock, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.isBlock = isBlock;
        this.methodBodyTranslator = methodBodyTranslator;
    }

    public RubyNode visitArgsNode(ArgsNode node) {
        this.argsNode = node;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.state = State.PRE;
            this.index = 0;
            for (Node arg : node.getPre().childNodes()) {
                sequence.add((RubyNode)((Object)arg.accept((NodeVisitor)this)));
                ++this.index;
                ++this.required;
            }
        }
        if (node.getOptArgs() != null) {
            this.state = State.OPT;
            this.index = this.argsNode.getPreCount();
            for (Node arg : node.getOptArgs().childNodes()) {
                sequence.add((RubyNode)((Object)arg.accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        boolean bl = this.hasKeywordArguments = node.hasKwargs() && node.getKeywords() != null;
        if (node.getRestArgNode() != null) {
            this.methodBodyTranslator.getEnvironment().hasRestParameter = true;
            sequence.add((RubyNode)((Object)node.getRestArgNode().accept((NodeVisitor)this)));
        }
        if (node.getPost() != null) {
            this.state = State.POST;
            this.index = -1;
            ArrayList children = new ArrayList(node.getPost().childNodes());
            Collections.reverse(children);
            for (Node arg : children) {
                sequence.add((RubyNode)((Object)arg.accept((NodeVisitor)this)));
                --this.index;
                ++this.required;
            }
        }
        if (this.hasKeywordArguments) {
            this.kwIndex = 0;
            this.countKwArgs = 0;
            for (Node arg : node.getKeywords().childNodes()) {
                ++this.countKwArgs;
            }
            for (Node arg : node.getKeywords().childNodes()) {
                sequence.add((RubyNode)((Object)arg.accept((NodeVisitor)this)));
                ++this.kwIndex;
            }
        }
        if (node.getKeyRest() != null) {
            sequence.add((RubyNode)((Object)node.getKeyRest().accept((NodeVisitor)this)));
        }
        if (node.getBlock() != null) {
            sequence.add((RubyNode)((Object)node.getBlock().accept((NodeVisitor)this)));
        }
        return SequenceNode.sequence(this.context, sourceSection, sequence);
    }

    public RubyNode visitKeywordRestArgNode(KeywordRestArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ReadKeywordRestArgumentNode readNode = new ReadKeywordRestArgumentNode(this.context, sourceSection, this.required, this.excludedKeywords.toArray(new String[this.excludedKeywords.size()]), -this.countKwArgs - 1);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)node.getName());
        return WriteLocalVariableNodeFactory.create(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitKeywordArgNode(KeywordArgNode node) {
        RubyNode defaultValue;
        String name;
        SourceSection sourceSection = this.translate(node.getPosition());
        Node firstChild = (Node)node.childNodes().get(0);
        if (firstChild instanceof LocalAsgnNode) {
            LocalAsgnNode localAsgnNode = (LocalAsgnNode)firstChild;
            name = localAsgnNode.getName();
            defaultValue = localAsgnNode.getValueNode() == null ? new NilLiteralNode(this.context, sourceSection) : (localAsgnNode.getValueNode() instanceof RequiredKeywordArgumentValueNode ? new MissingKeywordArgumentNode(this.context, sourceSection, name) : (RubyNode)((Object)localAsgnNode.getValueNode().accept((NodeVisitor)this)));
        } else if (firstChild instanceof DAsgnNode) {
            DAsgnNode dAsgnNode = (DAsgnNode)firstChild;
            name = dAsgnNode.getName();
            defaultValue = dAsgnNode.getValueNode() == null ? new NilLiteralNode(this.context, sourceSection) : (RubyNode)((Object)dAsgnNode.getValueNode().accept((NodeVisitor)this));
        } else {
            throw new UnsupportedOperationException("unsupported keyword arg " + node);
        }
        this.excludedKeywords.add(name);
        ReadKeywordArgumentNode readNode = new ReadKeywordArgumentNode(this.context, sourceSection, this.required, name, defaultValue, this.kwIndex - this.countKwArgs);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)name);
        return WriteLocalVariableNodeFactory.create(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitArgumentNode(ArgumentNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode readNode = this.readArgument(sourceSection);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return WriteLocalVariableNodeFactory.create(this.context, sourceSection, slot, readNode);
    }

    private RubyNode readArgument(SourceSection sourceSection) {
        if (this.useArray()) {
            return PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.loadArray(sourceSection), this.index);
        }
        if (this.state == State.PRE) {
            return new ReadPreArgumentNode(this.context, sourceSection, this.index, this.isBlock ? MissingArgumentBehaviour.NIL : MissingArgumentBehaviour.RUNTIME_ERROR);
        }
        if (this.state == State.POST) {
            return new ReadPostArgumentNode(this.context, sourceSection, this.index);
        }
        throw new IllegalStateException();
    }

    public RubyNode visitRestArgNode(RestArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.argsNode == null) {
            throw new IllegalStateException("No arguments node visited");
        }
        int from = this.argsNode.getPreCount() + this.argsNode.getOptionalArgsCount();
        int to = -this.argsNode.getPostCount();
        RubyNode readNode = this.useArray() ? ArraySliceNodeFactory.create(this.context, sourceSection, from, to, this.loadArray(sourceSection)) : new ReadRestArgumentNode(this.context, sourceSection, from, to, this.hasKeywordArguments);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return WriteLocalVariableNodeFactory.create(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitBlockArgNode(BlockArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ReadBlockNode readNode = new ReadBlockNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return WriteLocalVariableNodeFactory.create(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitOptArgNode(OptArgNode node) {
        return (RubyNode)((Object)node.getValue().accept((NodeVisitor)this));
    }

    public RubyNode visitLocalAsgnNode(LocalAsgnNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    public RubyNode visitDAsgnNode(DAsgnNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    private RubyNode translateLocalAssignment(ISourcePosition sourcePosition, String name, Node valueNode) {
        RubyNode readNode;
        SourceSection sourceSection = this.translate(sourcePosition);
        if (this.indexFromEnd == 1) {
            if (valueNode instanceof NilImplicitNode) {
                readNode = this.useArray() ? PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.loadArray(sourceSection), this.index) : this.readArgument(sourceSection);
            } else {
                RubyNode defaultValue = (RubyNode)((Object)valueNode.accept((NodeVisitor)this));
                if (this.argsNode == null) {
                    throw new IllegalStateException("No arguments node visited");
                }
                int minimum = this.index + 1 + this.argsNode.getPostCount();
                if (this.argsNode.hasKwargs()) {
                    ++minimum;
                }
                readNode = new ReadOptionalArgumentNode(this.context, sourceSection, this.index, minimum, defaultValue);
            }
        } else {
            readNode = ArraySliceNodeFactory.create(this.context, sourceSection, this.index, this.indexFromEnd, this.loadArray(sourceSection));
        }
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)name);
        return WriteLocalVariableNodeFactory.create(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitArrayNode(ArrayNode node) {
        return (RubyNode)((Object)((Node)node.childNodes().get(0)).accept((NodeVisitor)this));
    }

    public RubyNode visitMultipleAsgnNode(MultipleAsgn19Node node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        int arrayIndex = this.index;
        String arrayName = this.methodBodyTranslator.getEnvironment().allocateLocalTemp("destructure");
        FrameSlot arraySlot = this.methodBodyTranslator.getEnvironment().declareVar(arrayName);
        this.pushArraySlot(arraySlot);
        List childNodes = node.childNodes() == null || node.childNodes().get(0) == null ? Collections.emptyList() : ((Node)node.childNodes().get(0)).childNodes();
        ArrayList<RubyNode> notNilSequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.index = 0;
            for (Node child : node.getPre().childNodes()) {
                notNilSequence.add((RubyNode)((Object)child.accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        if (node.getRest() != null) {
            this.index = node.getPreCount();
            this.indexFromEnd = -node.getPostCount();
            notNilSequence.add((RubyNode)((Object)node.getRest().accept((NodeVisitor)this)));
            this.indexFromEnd = 1;
        }
        if (node.getPost() != null) {
            this.index = -1;
            ArrayList children = new ArrayList(node.getPost().childNodes());
            Collections.reverse(children);
            for (Node child : children) {
                notNilSequence.add((RubyNode)((Object)child.accept((NodeVisitor)this)));
                --this.index;
            }
        }
        RubyNode notNil = SequenceNode.sequence(this.context, sourceSection, notNilSequence);
        this.popArraySlot(arraySlot);
        ArrayList<RubyNode> nilSequence = new ArrayList<RubyNode>();
        ParameterCollector parametersToClearCollector = new ParameterCollector();
        if (node.getPre() != null) {
            for (Node child : node.getPre().childNodes()) {
                child.accept((NodeVisitor)parametersToClearCollector);
            }
        }
        if (node.getRest() != null) {
            if (node.getRest() instanceof INameNode) {
                String name = ((INameNode)node.getRest()).getName();
                nilSequence.add(((ReadNode)((Object)this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(name, sourceSection))).makeWriteNode(new ArrayLiteralNode.UninitialisedArrayLiteralNode(this.context, sourceSection, new RubyNode[0])));
            } else if (!(node.getRest() instanceof StarNode)) {
                throw new UnsupportedOperationException("unsupported rest node " + node.getRest());
            }
        }
        if (node.getPost() != null) {
            for (Node child : node.getPost().childNodes()) {
                child.accept((NodeVisitor)parametersToClearCollector);
            }
        }
        for (String parameterToClear : parametersToClearCollector.getParameters()) {
            nilSequence.add(((ReadNode)((Object)this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(parameterToClear, sourceSection))).makeWriteNode(new NilLiteralNode(this.context, sourceSection)));
        }
        if (!childNodes.isEmpty()) {
            this.index = arrayIndex;
            nilSequence.add((RubyNode)((Object)((Node)childNodes.get(0)).accept((NodeVisitor)this)));
        }
        RubyNode nil = SequenceNode.sequence(this.context, sourceSection, nilSequence);
        return SequenceNode.sequence(this.context, sourceSection, WriteLocalVariableNodeFactory.create(this.context, sourceSection, arraySlot, ArrayCastNodeFactory.create(this.context, sourceSection, this.readArgument(sourceSection))), new IfNode(this.context, sourceSection, new IsNilNode(this.context, sourceSection, ReadLocalVariableNodeFactory.create(this.context, sourceSection, arraySlot)), nil, notNil == null ? new NilLiteralNode(this.context, sourceSection) : notNil));
    }

    protected RubyNode defaultVisit(Node node) {
        return (RubyNode)((Object)node.accept((NodeVisitor)this.methodBodyTranslator));
    }

    public void pushArraySlot(FrameSlot slot) {
        this.arraySlotStack.push(new ArraySlot(slot, this.index));
    }

    public void popArraySlot(FrameSlot slot) {
        this.index = this.arraySlotStack.pop().getPreviousIndex();
    }

    protected boolean useArray() {
        return !this.arraySlotStack.isEmpty();
    }

    protected RubyNode loadArray(SourceSection sourceSection) {
        return ReadLocalVariableNodeFactory.create(this.context, sourceSection, this.arraySlotStack.peek().getArraySlot());
    }

    @Override
    protected String getIdentifier() {
        return this.methodBodyTranslator.getIdentifier();
    }

    private static enum State {
        PRE,
        OPT,
        POST;

    }

    private static class ArraySlot {
        private FrameSlot arraySlot;
        private int previousIndex;

        public ArraySlot(FrameSlot arraySlot, int previousIndex) {
            this.arraySlot = arraySlot;
            this.previousIndex = previousIndex;
        }

        public FrameSlot getArraySlot() {
            return this.arraySlot;
        }

        public int getPreviousIndex() {
            return this.previousIndex;
        }
    }
}

