/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.SafepointAction;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

public class ObjectSpaceManager {
    private final RubyContext context;
    private final Map<RubyBasicObject, FinalizerReference> finalizerReferences = new WeakHashMap<RubyBasicObject, FinalizerReference>();
    private final ReferenceQueue<RubyBasicObject> finalizerQueue = new ReferenceQueue();
    private RubyThread finalizerThread;

    public ObjectSpaceManager(RubyContext context) {
        this.context = context;
    }

    public synchronized void defineFinalizer(RubyBasicObject object, RubyProc proc) {
        RubyNode.notDesignedForCompilation();
        FinalizerReference finalizerReference = this.finalizerReferences.get(object);
        if (finalizerReference == null) {
            finalizerReference = new FinalizerReference(object, this.finalizerQueue);
            this.finalizerReferences.put(object, finalizerReference);
        }
        finalizerReference.addFinalizer(proc);
        if (this.finalizerThread == null) {
            this.finalizerThread = new RubyThread(this.context.getCoreLibrary().getThreadClass(), this.context.getThreadManager());
            this.finalizerThread.initialize(this.context, null, "finalizer", new Runnable(){

                @Override
                public void run() {
                    ObjectSpaceManager.this.runFinalizers();
                }
            });
        }
    }

    public synchronized void undefineFinalizer(RubyBasicObject object) {
        RubyNode.notDesignedForCompilation();
        FinalizerReference finalizerReference = this.finalizerReferences.get(object);
        if (finalizerReference != null) {
            finalizerReference.clearFinalizers();
        }
    }

    private void runFinalizers() {
        while (true) {
            FinalizerReference finalizerReference = this.context.getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<FinalizerReference>(){

                @Override
                public FinalizerReference block() throws InterruptedException {
                    return (FinalizerReference)ObjectSpaceManager.this.finalizerQueue.remove();
                }
            });
            ObjectSpaceManager.runFinalizers(finalizerReference);
        }
    }

    private static void runFinalizers(FinalizerReference finalizerReference) {
        try {
            for (RubyProc proc : finalizerReference.getFinalizers()) {
                proc.rootCall(new Object[0]);
            }
        }
        catch (RaiseException raiseException) {
            // empty catch block
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Map<Long, RubyBasicObject> collectLiveObjects() {
        RubyNode.notDesignedForCompilation();
        final HashMap liveObjects = new HashMap();
        final ObjectGraphVisitor visitor = new ObjectGraphVisitor(){

            @Override
            public boolean visit(RubyBasicObject object) {
                return liveObjects.put(object.verySlowGetObjectID(), object) == null;
            }
        };
        this.context.getSafepointManager().pauseAllThreadsAndExecute(null, false, new SafepointAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RubyThread currentThread, Node currentNode) {
                Map map = liveObjects;
                synchronized (map) {
                    currentThread.visitObjectGraph(visitor);
                    ObjectSpaceManager.this.context.getCoreLibrary().getGlobalVariablesObject().visitObjectGraph(visitor);
                    ObjectSpaceManager.this.visitCallStack(visitor);
                }
            }
        });
        return Collections.unmodifiableMap(liveObjects);
    }

    private void visitCallStack(final ObjectGraphVisitor visitor) {
        FrameInstance currentFrame = Truffle.getRuntime().getCurrentFrame();
        if (currentFrame != null) {
            this.visitFrameInstance(currentFrame, visitor);
        }
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){

            public Void visitFrame(FrameInstance frameInstance) {
                ObjectSpaceManager.this.visitFrameInstance(frameInstance, visitor);
                return null;
            }
        });
    }

    public void visitFrameInstance(FrameInstance frameInstance, ObjectGraphVisitor visitor) {
        this.visitFrame(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true), visitor);
    }

    public void visitFrame(Frame frame, ObjectGraphVisitor visitor) {
        if (frame == null) {
            return;
        }
        for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
            Object value = frame.getValue(slot);
            if (!(value instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)value).visitObjectGraph(visitor);
        }
    }

    public static interface ObjectGraphVisitor {
        public boolean visit(RubyBasicObject var1);
    }

    private static class FinalizerReference
    extends WeakReference<RubyBasicObject> {
        public List<RubyProc> finalizers = new LinkedList<RubyProc>();

        public FinalizerReference(RubyBasicObject object, ReferenceQueue<? super RubyBasicObject> queue) {
            super(object, queue);
        }

        public void addFinalizer(RubyProc proc) {
            this.finalizers.add(proc);
        }

        public List<RubyProc> getFinalizers() {
            return this.finalizers;
        }

        public void clearFinalizers() {
            this.finalizers = new LinkedList<RubyProc>();
        }
    }
}

