/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.hash;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.RubyHash;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashSearchResult;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.util.cli.Options;

public class HashOperations {
    public static final int SMALL_HASH_SIZE = (Integer)Options.TRUFFLE_HASHES_SMALL.load();
    private static final int[] CAPACITIES = Arrays.copyOf(RubyHash.MRI_PRIMES, RubyHash.MRI_PRIMES.length - 1);
    private static final int SIGN_BIT_MASK = Integer.MAX_VALUE;

    public static int capacityGreaterThan(int size) {
        for (int capacity : CAPACITIES) {
            if (capacity <= size) continue;
            return capacity;
        }
        return CAPACITIES[CAPACITIES.length - 1];
    }

    public static org.jruby.truffle.runtime.core.RubyHash verySlowFromEntries(RubyContext context, List<KeyValue> entries, boolean byIdentity) {
        return HashOperations.verySlowFromEntries(context.getCoreLibrary().getHashClass(), entries, byIdentity);
    }

    @CompilerDirectives.TruffleBoundary
    public static org.jruby.truffle.runtime.core.RubyHash verySlowFromEntries(RubyClass hashClass, List<KeyValue> entries, boolean byIdentity) {
        RubyNode.notDesignedForCompilation();
        org.jruby.truffle.runtime.core.RubyHash hash = new org.jruby.truffle.runtime.core.RubyHash(hashClass, null, null, null, 0, null);
        HashOperations.verySlowSetKeyValues(hash, entries, byIdentity);
        return hash;
    }

    public static void dump(org.jruby.truffle.runtime.core.RubyHash hash) {
        Entry entry;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(hash.getSize());
        builder.append("](");
        Entry[] arr$ = (Entry[])hash.getStore();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            builder.append("(");
            for (Entry entry2 = arr$[i$]; entry2 != null; entry2 = entry2.getNextInLookup()) {
                builder.append("[");
                builder.append(entry2.getKey());
                builder.append(",");
                builder.append(entry2.getValue());
                builder.append("]");
            }
            builder.append(")");
        }
        builder.append(")~>(");
        for (entry = hash.getFirstInSequence(); entry != null; entry = entry.getNextInSequence()) {
            builder.append("[");
            builder.append(entry.getKey());
            builder.append(",");
            builder.append(entry.getValue());
            builder.append("]");
        }
        builder.append(")<~(");
        for (entry = hash.getLastInSequence(); entry != null; entry = entry.getPreviousInSequence()) {
            builder.append("[");
            builder.append(entry.getKey());
            builder.append(",");
            builder.append(entry.getValue());
            builder.append("]");
        }
        builder.append(")");
        System.err.println(builder);
    }

    @CompilerDirectives.TruffleBoundary
    public static List<KeyValue> verySlowToKeyValues(org.jruby.truffle.runtime.core.RubyHash hash) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        if (hash.getStore() instanceof Entry[]) {
            for (Entry entry = hash.getFirstInSequence(); entry != null; entry = entry.getNextInSequence()) {
                keyValues.add(new KeyValue(entry.getKey(), entry.getValue()));
            }
        } else if (hash.getStore() instanceof Object[]) {
            for (int n = 0; n < hash.getSize(); ++n) {
                keyValues.add(new KeyValue(((Object[])hash.getStore())[n * 2], ((Object[])hash.getStore())[n * 2 + 1]));
            }
        } else if (hash.getStore() != null) {
            throw new UnsupportedOperationException();
        }
        return keyValues;
    }

    @CompilerDirectives.TruffleBoundary
    public static HashSearchResult verySlowFindBucket(org.jruby.truffle.runtime.core.RubyHash hash, Object key, boolean byIdentity) {
        int hashed;
        Object hashValue = DebugOperations.send(hash.getContext(), key, "hash", null, new Object[0]);
        if (hashValue instanceof Integer) {
            hashed = (Integer)hashValue;
        } else if (hashValue instanceof Long) {
            hashed = (int)((Long)hashValue).longValue();
        } else {
            throw new UnsupportedOperationException();
        }
        Entry[] entries = (Entry[])hash.getStore();
        int bucketIndex = (hashed & Integer.MAX_VALUE) % entries.length;
        Entry previousEntry = null;
        for (Entry entry = entries[bucketIndex]; entry != null; entry = entry.getNextInLookup()) {
            String method = byIdentity ? "equal?" : "eql?";
            if (((Boolean)DebugOperations.send(hash.getContext(), key, method, null, entry.getKey())).booleanValue()) {
                return new HashSearchResult(bucketIndex, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashSearchResult(bucketIndex, previousEntry, null);
    }

    public static void setAtBucket(org.jruby.truffle.runtime.core.RubyHash hash, HashSearchResult hashSearchResult, Object key, Object value) {
        if (hashSearchResult.getEntry() == null) {
            Entry entry = new Entry(key, value);
            if (hashSearchResult.getPreviousEntry() == null) {
                ((Entry[])hash.getStore())[hashSearchResult.getIndex()] = entry;
            } else {
                hashSearchResult.getPreviousEntry().setNextInLookup(entry);
            }
            if (hash.getFirstInSequence() == null) {
                hash.setFirstInSequence(entry);
                hash.setLastInSequence(entry);
            } else {
                hash.getLastInSequence().setNextInSequence(entry);
                entry.setPreviousInSequence(hash.getLastInSequence());
                hash.setLastInSequence(entry);
            }
        } else {
            Entry entry = hashSearchResult.getEntry();
            entry.setKey(key);
            entry.setValue(value);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean verySlowSetInBuckets(org.jruby.truffle.runtime.core.RubyHash hash, Object key, Object value, boolean byIdentity) {
        if (!byIdentity && key instanceof RubyString) {
            key = DebugOperations.send(hash.getContext(), DebugOperations.send(hash.getContext(), key, "dup", null, new Object[0]), "freeze", null, new Object[0]);
        }
        HashSearchResult hashSearchResult = HashOperations.verySlowFindBucket(hash, key, byIdentity);
        HashOperations.setAtBucket(hash, hashSearchResult, key, value);
        return hashSearchResult.getEntry() == null;
    }

    @CompilerDirectives.TruffleBoundary
    public static void verySlowSetKeyValues(org.jruby.truffle.runtime.core.RubyHash hash, List<KeyValue> keyValues, boolean byIdentity) {
        int size = keyValues.size();
        hash.setStore(new Entry[HashOperations.capacityGreaterThan(size)], 0, null, null);
        int actualSize = 0;
        for (KeyValue keyValue : keyValues) {
            if (!HashOperations.verySlowSetInBuckets(hash, keyValue.getKey(), keyValue.getValue(), byIdentity)) continue;
            ++actualSize;
        }
        hash.setSize(actualSize);
    }

    public static int getIndex(int hashed, int entriesLength) {
        return (hashed & Integer.MAX_VALUE) % entriesLength;
    }
}

