/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.ModuleChain;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;

public class RubyModule
extends RubyBasicObject
implements ModuleChain {
    public static final Object VISIBILITY_FRAME_SLOT_ID = new Object();
    private final RubyContext context;
    @CompilerDirectives.CompilationFinal
    protected ModuleChain parentModule;
    private String name;
    private final Map<String, InternalMethod> methods = new ConcurrentHashMap<String, InternalMethod>();
    private final Map<String, RubyConstant> constants = new ConcurrentHashMap<String, RubyConstant>();
    private final Map<String, Object> classVariables = new ConcurrentHashMap<String, Object>();
    private final CyclicAssumption unmodifiedAssumption;
    private final Set<RubyModule> dependents = Collections.newSetFromMap(new WeakHashMap());
    private final Set<RubyModule> lexicalDependents = Collections.newSetFromMap(new WeakHashMap());

    public static void debugModuleChain(RubyModule module) {
        for (ModuleChain chain = module; chain != null; chain = chain.getParentModule()) {
            System.err.print(chain.getClass());
            RubyModule real = chain.getActualModule();
            System.err.print(" " + real.getName());
            System.err.println();
        }
    }

    public RubyModule(RubyContext context, RubyModule lexicalParent, String name, Node currentNode) {
        this(context, context.getCoreLibrary().getModuleClass(), lexicalParent, name, currentNode);
    }

    protected RubyModule(RubyContext context, RubyClass selfClass, RubyModule lexicalParent, String name, Node currentNode) {
        super(context, selfClass, LAYOUT.newInstance(context.getEmptyShape()));
        this.context = context;
        this.unmodifiedAssumption = new CyclicAssumption(name + " is unmodified");
        if (lexicalParent != null) {
            this.getAdoptedByLexicalParent(lexicalParent, name, currentNode);
        }
    }

    public void getAdoptedByLexicalParent(RubyModule lexicalParent, String name, Node currentNode) {
        lexicalParent.setConstantInternal(currentNode, name, this, false);
        lexicalParent.addLexicalDependent(this);
        if (this.name == null) {
            RubyClass classClass = this.logicalClass.getLogicalClass();
            RubyClass objectClass = classClass.getSuperClass().getSuperClass();
            if (lexicalParent == objectClass) {
                this.name = name;
                this.updateAnonymousChildrenModules();
            } else if (lexicalParent.hasName()) {
                this.name = lexicalParent.getName() + "::" + name;
                this.updateAnonymousChildrenModules();
            }
        }
    }

    private void updateAnonymousChildrenModules() {
        RubyNode.notDesignedForCompilation();
        for (Map.Entry<String, RubyConstant> entry : this.constants.entrySet()) {
            RubyModule module;
            RubyConstant constant = entry.getValue();
            if (!(constant.getValue() instanceof RubyModule) || (module = (RubyModule)constant.getValue()).hasName()) continue;
            module.getAdoptedByLexicalParent(this, entry.getKey(), null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void initCopy(RubyModule from) {
        this.parentModule = from.parentModule;
        if (this.parentModule != null) {
            this.parentModule.getActualModule().addDependent(this);
        }
        this.methods.putAll(from.methods);
        this.constants.putAll(from.constants);
        this.classVariables.putAll(from.classVariables);
    }

    public boolean isOnlyAModule() {
        return !(this instanceof RubyClass);
    }

    @CompilerDirectives.TruffleBoundary
    public void include(Node currentNode, RubyModule module) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        Stack<RubyModule> moduleAncestors = new Stack<RubyModule>();
        for (RubyModule ancestor : module.ancestors()) {
            moduleAncestors.push(ancestor);
        }
        while (!moduleAncestors.isEmpty()) {
            RubyModule mod = (RubyModule)moduleAncestors.pop();
            this.parentModule = new IncludedModule(mod, this.parentModule);
            mod.addDependent(this);
        }
        this.newVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public void setConstant(Node currentNode, String name, Object value) {
        RubyConstant currentConstant;
        if (this.getContext().getCoreLibrary().isLoadingRubyCore() && (currentConstant = this.constants.get(name)) != null) {
            return;
        }
        if (value instanceof RubyModule) {
            ((RubyModule)value).getAdoptedByLexicalParent(this, name, currentNode);
        } else {
            this.setConstantInternal(currentNode, name, value, false);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setAutoloadConstant(Node currentNode, String name, RubyString filename) {
        this.setConstantInternal(currentNode, name, filename, true);
    }

    private void setConstantInternal(Node currentNode, String name, Object value, boolean autoload) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        RubyConstant previous = this.constants.get(name);
        if (previous == null) {
            this.constants.put(name, new RubyConstant(this, value, false, autoload));
        } else {
            this.constants.put(name, new RubyConstant(this, value, previous.isPrivate(), autoload));
        }
        this.newLexicalVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public RubyConstant removeConstant(Node currentNode, String name) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        RubyConstant oldConstant = this.constants.remove(name);
        this.newLexicalVersion();
        return oldConstant;
    }

    @CompilerDirectives.TruffleBoundary
    public void setClassVariable(Node currentNode, String variableName, Object value) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        this.classVariables.put(variableName, value);
    }

    @CompilerDirectives.TruffleBoundary
    public void removeClassVariable(Node currentNode, String variableName) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        this.classVariables.remove(variableName);
    }

    @CompilerDirectives.TruffleBoundary
    public void addMethod(Node currentNode, InternalMethod method) {
        InternalMethod currentMethod;
        RubyNode.notDesignedForCompilation();
        assert (method != null);
        if (this.getContext().getCoreLibrary().isLoadingRubyCore() && (currentMethod = this.methods.get(method.getName())) != null && currentMethod.getSharedMethodInfo().getSourceSection() instanceof CoreSourceSection) {
            return;
        }
        this.checkFrozen(currentNode);
        this.methods.put(method.getName(), method.withDeclaringModule(this));
        this.newVersion();
        if (this.context.getCoreLibrary().isLoaded() && !method.isUndefined()) {
            DebugOperations.send(this.context, this, "method_added", null, this.context.getSymbolTable().getSymbol(method.getName()));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void removeMethod(Node currentNode, String methodName) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        this.methods.remove(methodName);
        this.newVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public void undefMethod(Node currentNode, String methodName) {
        RubyNode.notDesignedForCompilation();
        InternalMethod method = ModuleOperations.lookupMethod(this, methodName);
        if (method == null) {
            throw new UnsupportedOperationException();
        }
        this.undefMethod(currentNode, method);
    }

    @CompilerDirectives.TruffleBoundary
    public void undefMethod(Node currentNode, InternalMethod method) {
        RubyNode.notDesignedForCompilation();
        this.addMethod(currentNode, method.undefined());
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod deepMethodSearch(String name) {
        InternalMethod method = ModuleOperations.lookupMethod(this, name);
        if (method != null && !method.isUndefined()) {
            return method;
        }
        if (this.isOnlyAModule() && (method = ModuleOperations.lookupMethod(this.context.getCoreLibrary().getObjectClass(), name)) != null && !method.isUndefined()) {
            return method;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void alias(Node currentNode, String newName, String oldName) {
        RubyNode.notDesignedForCompilation();
        InternalMethod method = this.deepMethodSearch(oldName);
        if (method == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodErrorOnModule(oldName, this, currentNode));
        }
        this.addMethod(currentNode, method.withName(newName));
    }

    @CompilerDirectives.TruffleBoundary
    public void changeConstantVisibility(Node currentNode, String name, boolean isPrivate) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        RubyConstant rubyConstant = this.constants.get(name);
        if (rubyConstant == null) {
            throw new RaiseException(this.context.getCoreLibrary().nameErrorUninitializedConstant(this, name, currentNode));
        }
        rubyConstant.setPrivate(isPrivate);
        this.newLexicalVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public void appendFeatures(Node currentNode, RubyModule other) {
        RubyNode.notDesignedForCompilation();
        other.include(currentNode, this);
    }

    @Override
    public RubyContext getContext() {
        return this.context;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "#<" + this.logicalClass.getName() + ":0x" + Long.toHexString(this.verySlowGetObjectID()) + ">";
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String toString() {
        return super.toString() + "(" + this.getName() + ")";
    }

    public void newVersion() {
        RubyNode.notDesignedForCompilation();
        this.newVersion(new HashSet<RubyModule>(), false);
    }

    public void newLexicalVersion() {
        RubyNode.notDesignedForCompilation();
        this.newVersion(new HashSet<RubyModule>(), true);
    }

    private void newVersion(Set<RubyModule> alreadyInvalidated, boolean considerLexicalDependents) {
        if (alreadyInvalidated.contains(this)) {
            return;
        }
        this.unmodifiedAssumption.invalidate();
        alreadyInvalidated.add(this);
        for (RubyModule dependent : this.dependents) {
            dependent.newVersion(alreadyInvalidated, considerLexicalDependents);
        }
        if (considerLexicalDependents) {
            for (RubyModule dependent : this.lexicalDependents) {
                dependent.newVersion(alreadyInvalidated, considerLexicalDependents);
            }
        }
    }

    public void addDependent(RubyModule dependent) {
        RubyNode.notDesignedForCompilation();
        this.dependents.add(dependent);
    }

    public void addLexicalDependent(RubyModule lexicalChild) {
        RubyNode.notDesignedForCompilation();
        if (lexicalChild != this) {
            this.lexicalDependents.add(lexicalChild);
        }
    }

    public Assumption getUnmodifiedAssumption() {
        RubyNode.notDesignedForCompilation();
        return this.unmodifiedAssumption.getAssumption();
    }

    public Map<String, RubyConstant> getConstants() {
        return this.constants;
    }

    public Map<String, InternalMethod> getMethods() {
        return this.methods;
    }

    public Map<String, Object> getClassVariables() {
        return this.classVariables;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (RubyConstant constant : this.constants.values()) {
            if (!(constant.getValue() instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)constant.getValue()).visitObjectGraph(visitor);
        }
        for (Object classVariable : this.classVariables.values()) {
            if (!(classVariable instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)classVariable).visitObjectGraph(visitor);
        }
        for (InternalMethod method : this.methods.values()) {
            if (method.getDeclarationFrame() == null) continue;
            this.getContext().getObjectSpaceManager().visitFrame((Frame)method.getDeclarationFrame(), visitor);
        }
        for (RubyModule ancestor : this.ancestors()) {
            ancestor.visitObjectGraph(visitor);
        }
    }

    @Override
    public ModuleChain getParentModule() {
        return this.parentModule;
    }

    @Override
    public RubyModule getActualModule() {
        return this;
    }

    public Iterable<RubyModule> ancestors() {
        final RubyModule top = this;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                return new AncestorIterator(top);
            }
        };
    }

    public Iterable<RubyModule> parentAncestors() {
        final ModuleChain top = this.parentModule;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                return new AncestorIterator(top);
            }
        };
    }

    public Iterable<RubyModule> includedModules() {
        final ModuleChain top = this.parentModule;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                return new IncludedModulesIterator(top);
            }
        };
    }

    public Collection<RubySymbol> filterMethods(boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getAllMethods(this) : this.getMethods();
        Map<String, InternalMethod> methods = ModuleOperations.withoutUndefinedMethods(allMethods);
        HashSet<RubySymbol> filtered = new HashSet<RubySymbol>();
        for (InternalMethod method : methods.values()) {
            if (!filter.filter(method)) continue;
            filtered.add(this.getContext().getSymbolTable().getSymbol(method.getName()));
        }
        return filtered;
    }

    public static class ModuleAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyModule(context, null, null, currentNode);
        }
    }

    public static interface MethodFilter {
        public boolean filter(InternalMethod var1);
    }

    private class IncludedModulesIterator
    extends AncestorIterator {
        public IncludedModulesIterator(ModuleChain top) {
            super(top);
        }

        @Override
        public boolean hasNext() {
            return super.hasNext() && !(this.module instanceof RubyClass);
        }
    }

    private class AncestorIterator
    implements Iterator<RubyModule> {
        ModuleChain module;

        public AncestorIterator(ModuleChain top) {
            this.module = top;
        }

        @Override
        public boolean hasNext() {
            return this.module != null;
        }

        @Override
        public RubyModule next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ModuleChain mod = this.module;
            this.module = this.module.getParentModule();
            return mod.getActualModule();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class IncludedModule
    implements ModuleChain {
        private final RubyModule includedModule;
        private final ModuleChain parentModule;

        public IncludedModule(RubyModule includedModule, ModuleChain parentModule) {
            this.includedModule = includedModule;
            this.parentModule = parentModule;
        }

        @Override
        public ModuleChain getParentModule() {
            return this.parentModule;
        }

        @Override
        public RubyModule getActualModule() {
            return this.includedModule;
        }

        public String toString() {
            return super.toString() + "(" + this.includedModule + ")";
        }
    }
}

