/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.util.ByteList;

public class RubyEncoding
extends RubyBasicObject {
    private static RubyEncoding[] encodingList = new RubyEncoding[EncodingDB.getEncodings().size()];
    private static Map<String, RubyEncoding> lookup = new HashMap<String, RubyEncoding>();
    private final Encoding encoding;
    private final ByteList name;
    private final boolean dummy;

    @CompilerDirectives.TruffleBoundary
    public static synchronized RubyEncoding getEncoding(Encoding encoding) {
        return lookup.get(new String(encoding.getName(), StandardCharsets.UTF_8).toLowerCase(Locale.ENGLISH));
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyEncoding getEncoding(String name) {
        return lookup.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static RubyEncoding getEncoding(int index) {
        return encodingList[index];
    }

    @CompilerDirectives.TruffleBoundary
    public static void storeEncoding(int encodingListIndex, RubyEncoding encoding) {
        RubyEncoding.encodingList[encodingListIndex] = encoding;
        lookup.put(encoding.getName().toString().toLowerCase(Locale.ENGLISH), encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static void storeAlias(String aliasName, RubyEncoding encoding) {
        lookup.put(aliasName.toLowerCase(Locale.ENGLISH), encoding);
    }

    public static RubyEncoding newEncoding(RubyClass encodingClass, Encoding encoding, byte[] name, int p, int end, boolean dummy) {
        return new RubyEncoding(encodingClass, encoding, new ByteList(name, p, end), dummy);
    }

    private RubyEncoding(RubyClass encodingClass, Encoding encoding, ByteList name, boolean dummy) {
        super(encodingClass);
        this.encoding = encoding;
        this.name = name;
        this.dummy = dummy;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public ByteList getName() {
        return this.name;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public static RubyEncoding[] cloneEncodingList() {
        RubyEncoding[] clone = new RubyEncoding[encodingList.length];
        System.arraycopy(encodingList, 0, clone, 0, encodingList.length);
        return clone;
    }

    public String toString() {
        return this.getName().toString();
    }

    public static class EncodingAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            throw new UnsupportedOperationException();
        }
    }
}

