/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.Map;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.RubyOperations;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;

public class RubyBasicObject {
    public static final HiddenKey OBJECT_ID_IDENTIFIER = new HiddenKey("object_id");
    public static final HiddenKey TAINTED_IDENTIFIER = new HiddenKey("tainted?");
    public static final HiddenKey FROZEN_IDENTIFIER = new HiddenKey("frozen?");
    public static final Layout LAYOUT = Layout.createLayout((EnumSet)Layout.INT_TO_LONG);
    private final DynamicObject dynamicObject;
    @CompilerDirectives.CompilationFinal
    protected RubyClass logicalClass;
    @CompilerDirectives.CompilationFinal
    protected RubyClass metaClass;

    public RubyBasicObject(RubyClass rubyClass) {
        this(rubyClass, LAYOUT.newInstance(rubyClass.getContext().getEmptyShape()));
    }

    public RubyBasicObject(RubyClass rubyClass, DynamicObject dynamicObject) {
        this(rubyClass.getContext(), rubyClass, dynamicObject);
    }

    public RubyBasicObject(RubyContext context, RubyClass rubyClass, DynamicObject dynamicObject) {
        this.dynamicObject = dynamicObject;
        if (rubyClass != null) {
            this.unsafeSetLogicalClass(rubyClass);
        }
    }

    protected void unsafeSetLogicalClass(RubyClass newLogicalClass) {
        assert (this.logicalClass == null);
        this.unsafeChangeLogicalClass(newLogicalClass);
    }

    public void unsafeChangeLogicalClass(RubyClass newLogicalClass) {
        this.logicalClass = newLogicalClass;
        this.metaClass = newLogicalClass;
    }

    public boolean hasNoSingleton() {
        return false;
    }

    public boolean hasClassAsSingleton() {
        return false;
    }

    @Deprecated
    public void freeze() {
        DebugOperations.verySlowFreeze(this.getContext(), this);
    }

    @Deprecated
    public void checkFrozen(Node currentNode) {
        if (DebugOperations.verySlowIsFrozen(this.getContext(), this)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getLogicalClass().getName(), currentNode));
        }
    }

    public RubyClass getMetaClass() {
        return this.metaClass;
    }

    public RubyClass getSingletonClass(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.hasNoSingleton()) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantDefineSingleton(currentNode));
        }
        if (this.hasClassAsSingleton() || this.metaClass.isSingleton()) {
            return this.metaClass;
        }
        RubyClass logicalClass = this.metaClass;
        RubyModule attached = null;
        if (this instanceof RubyModule) {
            attached = (RubyModule)this;
        }
        this.metaClass = RubyClass.createSingletonClassOfObject(this.getContext(), logicalClass, attached, String.format("#<Class:#<%s:0x%x>>", logicalClass.getName(), this.verySlowGetObjectID()));
        if (DebugOperations.verySlowIsFrozen(this.getContext(), this)) {
            DebugOperations.verySlowFreeze(this.getContext(), this.metaClass);
        }
        return this.metaClass;
    }

    @CompilerDirectives.TruffleBoundary
    public long verySlowGetObjectID() {
        Property property = this.dynamicObject.getShape().getProperty((Object)OBJECT_ID_IDENTIFIER);
        if (property != null) {
            return (Long)property.get(this.dynamicObject, false);
        }
        long objectID = this.getContext().getNextObjectID();
        this.dynamicObject.define((Object)OBJECT_ID_IDENTIFIER, (Object)objectID, 0);
        return objectID;
    }

    @CompilerDirectives.TruffleBoundary
    public void setInstanceVariables(Map<Object, Object> instanceVariables) {
        RubyNode.notDesignedForCompilation();
        assert (instanceVariables != null);
        this.getOperations().setInstanceVariables(this, instanceVariables);
    }

    public Map<Object, Object> getInstanceVariables() {
        RubyNode.notDesignedForCompilation();
        return this.getOperations().getInstanceVariables(this);
    }

    public Object[] getFieldNames() {
        return this.getOperations().getFieldNames(this);
    }

    public Object getInstanceVariable(String name) {
        RubyNode.notDesignedForCompilation();
        Object value = this.getOperations().getInstanceVariable(this, name);
        if (value == null) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return value;
    }

    public boolean isFieldDefined(String name) {
        return this.getOperations().isFieldDefined(this, name);
    }

    public final void visitObjectGraph(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        if (visitor.visit(this)) {
            this.metaClass.visitObjectGraph(visitor);
            for (Object instanceVariable : this.getOperations().getInstanceVariables(this).values()) {
                if (!(instanceVariable instanceof RubyBasicObject)) continue;
                ((RubyBasicObject)instanceVariable).visitObjectGraph(visitor);
            }
            this.visitObjectGraphChildren(visitor);
        }
    }

    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
    }

    public boolean isNumeric() {
        return ModuleOperations.assignableTo(this.getMetaClass(), this.getContext().getCoreLibrary().getNumericClass());
    }

    public RubyContext getContext() {
        return this.logicalClass.getContext();
    }

    public Shape getObjectLayout() {
        return this.dynamicObject.getShape();
    }

    public RubyOperations getOperations() {
        return (RubyOperations)this.dynamicObject.getShape().getObjectType();
    }

    public RubyClass getLogicalClass() {
        return this.logicalClass;
    }

    public DynamicObject getDynamicObject() {
        return this.dynamicObject;
    }

    public static class BasicObjectAllocator
    implements Allocator {
        @Override
        @CompilerDirectives.TruffleBoundary
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyBasicObject(rubyClass);
        }
    }
}

