/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeFactory;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeFactory;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class DebugOperations {
    public static String inspect(RubyContext context, Object object) {
        CompilerAsserts.neverPartOfCompilation();
        Object inspected = DebugOperations.send(context, object, "inspect", null, new Object[0]);
        if (inspected == null) {
            return String.format("%s@%x", object.getClass().getSimpleName(), object.hashCode());
        }
        return inspected.toString();
    }

    public static Object send(RubyContext context, Object object, String methodName, RubyProc block, Object ... arguments) {
        CompilerAsserts.neverPartOfCompilation();
        InternalMethod method = ModuleOperations.lookupMethod(context.getCoreLibrary().getMetaClass(object), methodName);
        if (method == null) {
            return null;
        }
        return method.getCallTarget().call(RubyArguments.pack(method, method.getDeclarationFrame(), object, block, arguments));
    }

    public static void panic(RubyContext context, Node currentNode, String message) {
        CompilerDirectives.transferToInterpreter();
        System.err.println("=========================== JRuby+Truffle Debug Report ========================");
        if (message != null) {
            System.err.println();
            System.err.println("Stopped because: " + message);
        }
        System.err.println();
        System.err.println("    =========================== Ruby Bracktrace ===========================    ");
        System.err.println();
        try {
            for (String line : Backtrace.PANIC_FORMATTER.format(context, null, RubyCallStack.getBacktrace(currentNode))) {
                System.err.println(line);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.err.println();
        System.err.println("    ========================== AST Backtrace ==========================    ");
        System.err.println();
        try {
            DebugOperations.printASTBacktrace(currentNode);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.err.println();
        System.err.println("    =========================== Java Backtrace ============================    ");
        System.err.println();
        new Exception().printStackTrace();
        System.err.println();
        System.err.println("===============================================================================");
        System.exit(1);
    }

    public static void printBacktrace(RubyContext context, Node currentNode) {
        for (String line : Backtrace.DISPLAY_FORMATTER.format(context, null, RubyCallStack.getBacktrace(currentNode))) {
            System.err.println(line);
        }
    }

    public static void printASTBacktrace(Node currentNode) {
        if (currentNode != null) {
            DebugOperations.printMethodASTBacktrace(currentNode);
        }
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){

            public Object visitFrame(FrameInstance frameInstance) {
                DebugOperations.printMethodASTBacktrace(frameInstance.getCallNode());
                return null;
            }
        });
    }

    private static void printMethodASTBacktrace(Node currentNode) {
        ArrayList<Node> activeNodes = new ArrayList<Node>();
        activeNodes.addAll(NodeUtil.findAllParents((Node)currentNode, Node.class));
        activeNodes.add(currentNode);
        DebugOperations.printASTForBacktrace((Node)currentNode.getRootNode(), activeNodes, 0);
    }

    public static Object verySlowFreeze(RubyContext context, Object object) {
        final FreezeNode freezeNode = FreezeNodeFactory.create(context, null, null);
        new Node(){
            @Node.Child
            FreezeNode child;
            {
                this.child = freezeNode;
            }
        }.adoptChildren();
        return freezeNode.executeFreeze(object);
    }

    public static boolean verySlowIsFrozen(RubyContext context, Object object) {
        final IsFrozenNode isFrozenNode = IsFrozenNodeFactory.create(context, null, null);
        new Node(){
            @Node.Child
            IsFrozenNode child;
            {
                this.child = isFrozenNode;
            }
        }.adoptChildren();
        return isFrozenNode.executeIsFrozen(object);
    }

    public static boolean verySlowIsTainted(Object o) {
        if (o instanceof Boolean || o instanceof Integer || o instanceof Long || o instanceof Double || o instanceof RubySymbol) {
            return false;
        }
        RubyBasicObject object = (RubyBasicObject)o;
        Shape layout = object.getDynamicObject().getShape();
        Property property = layout.getProperty((Object)RubyBasicObject.TAINTED_IDENTIFIER);
        Location storageLocation = property.getLocation();
        return (Boolean)storageLocation.get(object.getDynamicObject(), layout);
    }

    private static void printASTForBacktrace(Node node, List<Node> activeNodes, int indentation) {
        for (int n = 0; n < indentation; ++n) {
            System.err.print("  ");
        }
        if (activeNodes.contains(node)) {
            System.err.print("-> ");
        } else {
            System.err.print("   ");
        }
        System.err.println(node);
        for (Node child : node.getChildren()) {
            if (child == null) continue;
            DebugOperations.printASTForBacktrace(child, activeNodes, indentation + 1);
        }
    }
}

