/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.Ruby;
import org.jruby.RubyTime;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.time.ReadTimeZoneNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.RubyDateFormatter;

public abstract class TimePrimitiveNodes {

    @RubiniusPrimitive(name="time_utc_offset")
    public static abstract class TimeUTCOffsetPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeUTCOffsetPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeUTCOffsetPrimitiveNode(TimeUTCOffsetPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object timeUTCOffset(org.jruby.truffle.runtime.core.RubyTime time) {
            Object offset = time.getOffset();
            if (offset != this.nil()) {
                return offset;
            }
            return time.getDateTime().getZone().getOffset(time.getDateTime().getMillis()) / 1000;
        }
    }

    @RubiniusPrimitive(name="time_env_zone")
    public static abstract class TimeEnvZonePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeEnvZonePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeEnvZonePrimitiveNode(TimeEnvZonePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object timeEnvZone(org.jruby.truffle.runtime.core.RubyTime time) {
            throw new UnsupportedOperationException("time_env_zone");
        }
    }

    @RubiniusPrimitive(name="time_set_nseconds")
    public static abstract class TimeSetNSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSetNSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSetNSecondsPrimitiveNode(TimeSetNSecondsPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long timeSetNSeconds(org.jruby.truffle.runtime.core.RubyTime time, int nanoseconds) {
            time.setDateTime(time.getDateTime().withMillisOfSecond(nanoseconds / 1000000));
            return nanoseconds;
        }
    }

    @RubiniusPrimitive(name="time_nseconds")
    public static abstract class TimeNSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeNSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeNSecondsPrimitiveNode(TimeNSecondsPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long timeNSeconds(org.jruby.truffle.runtime.core.RubyTime time) {
            return (long)time.getDateTime().getMillisOfSecond() * 1000000L;
        }
    }

    @RubiniusPrimitive(name="time_s_from_array", needsSelf=true)
    public static abstract class TimeSFromArrayPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSFromArrayPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSFromArrayPrimitiveNode(TimeSFromArrayPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, RubyNilClass sec, int min, int hour, int mday, int month, int year, RubyNilClass nsec, int isdst, boolean fromutc, Object utcoffset) {
            return this.timeSFromArray(frame, timeClass, 0, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, int sec, int min, int hour, int mday, int month, int year, RubyNilClass nsec, int isdst, boolean fromutc, Object utcoffset) {
            return this.buildTime(frame, timeClass, sec, min, hour, mday, month, year, 0, isdst, fromutc, utcoffset);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, long sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            return this.buildTime(frame, timeClass, (int)sec, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, int sec, int min, int hour, int mday, int month, int year, long nsec, int isdst, boolean fromutc, Object utcoffset) {
            return this.buildTime(frame, timeClass, sec, min, hour, mday, month, year, (int)nsec, isdst, fromutc, utcoffset);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime buildTime(VirtualFrame frame, RubyClass timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            DateTimeZone zone;
            if (sec < 0 || sec > 59 || min < 0 || min > 59 || hour < 0 || hour > 23 || mday < 1 || mday > 31 || month < 1 || month > 12) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorOutOfRange(this));
            }
            if (fromutc) {
                zone = DateTimeZone.UTC;
            } else if (utcoffset == this.nil()) {
                String tz = DebugOperations.send(this.getContext(), this.getContext().getCoreLibrary().getENV(), "[]", null, this.getContext().makeString("TZ")).toString();
                zone = RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)tz);
            } else if (utcoffset instanceof Integer) {
                zone = DateTimeZone.forOffsetMillis((int)((Integer)utcoffset * 1000));
            } else if (utcoffset instanceof Long) {
                zone = DateTimeZone.forOffsetMillis((int)((int)((Long)utcoffset).longValue() * 1000));
            } else if (utcoffset instanceof RubyBasicObject) {
                int millis = this.cast(this.ruby(frame, "(offset * 1000).to_i", "offset", utcoffset));
                zone = DateTimeZone.forOffsetMillis((int)millis);
            } else {
                throw new UnsupportedOperationException(String.format("%s %s %s %s", isdst, fromutc, utcoffset, utcoffset.getClass()));
            }
            if (isdst == -1) {
                DateTime dateTime = new DateTime(year, month, mday, hour, min, sec, nsec / 1000000, zone);
                return new org.jruby.truffle.runtime.core.RubyTime(timeClass, dateTime, utcoffset);
            }
            throw new UnsupportedOperationException(String.format("%s %s %s %s", isdst, fromutc, utcoffset, utcoffset.getClass()));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(RubyClass timeClass, RubyBasicObject sec, int min, int hour, int mday, int month, int year, RubyNilClass nsec, int isdst, boolean fromutc, Object utcoffset) {
            return null;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, double sec, int min, int hour, int mday, int month, int year, long nsec, int isdst, boolean fromutc, Object utcoffset) {
            return this.timeSFromArray(frame, timeClass, sec, min, hour, mday, month, year, (int)nsec, isdst, fromutc, utcoffset);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, double sec, int min, int hour, int mday, int month, int year, int nsec, long isdst, boolean fromutc, Object utcoffset) {
            return this.timeSFromArray(frame, timeClass, sec, min, hour, mday, month, year, nsec, (int)isdst, fromutc, utcoffset);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, double sec, int min, int hour, int mday, int month, int year, RubyNilClass nsec, int isdst, boolean fromutc, Object utcoffset) {
            int secondsWhole = (int)sec;
            int nanosecondsFractional = (int)(sec * 1.0E9 - (double)(secondsWhole * 1000000000));
            return this.buildTime(frame, timeClass, secondsWhole, min, hour, mday, month, year, nanosecondsFractional, isdst, fromutc, utcoffset);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, double sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            int secondsWhole = (int)sec;
            return this.buildTime(frame, timeClass, secondsWhole, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset);
        }

        private int cast(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Long) {
                return (int)((Long)value).longValue();
            }
            throw new UnsupportedOperationException("Can't cast " + value.getClass());
        }
    }

    @RubiniusPrimitive(name="time_strftime")
    public static abstract class TimeStrftimePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeStrftimePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeStrftimePrimitiveNode(TimeStrftimePrimitiveNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString timeStrftime(org.jruby.truffle.runtime.core.RubyTime time, RubyString format) {
            RubyDateFormatter rdf = this.getContext().getRuntime().getCurrentContext().getRubyDateFormatter();
            return this.getContext().makeString(rdf.formatToByteList(rdf.compilePattern(format.getBytes(), false), time.getDateTime(), 0L, null));
        }
    }

    @RubiniusPrimitive(name="time_decompose")
    public static abstract class TimeDecomposePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeDecomposePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeDecomposePrimitiveNode(TimeDecomposePrimitiveNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyArray timeDecompose(org.jruby.truffle.runtime.core.RubyTime time) {
            DateTime dateTime = time.getDateTime();
            int sec = dateTime.getSecondOfMinute();
            int min = dateTime.getMinuteOfHour();
            int hour = dateTime.getHourOfDay();
            int day = dateTime.getDayOfMonth();
            int month = dateTime.getMonthOfYear();
            int year = dateTime.getYear();
            int wday = dateTime.getDayOfWeek();
            if (wday == 7) {
                wday = 0;
            }
            int yday = dateTime.getDayOfYear();
            boolean isdst = false;
            String envTimeZoneString = DebugOperations.send(this.getContext(), this.getContext().getCoreLibrary().getENV(), "[]", null, this.getContext().makeString("TZ")).toString();
            String zoneString = RubyTime.zoneHelper((String)envTimeZoneString, (DateTime)dateTime, (boolean)false);
            RubyBasicObject zone = zoneString.matches(".*-\\d+") ? this.nil() : this.getContext().makeString(zoneString);
            Object[] decomposed = new Object[]{sec, min, hour, day, month, year, wday, yday, false, zone};
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), decomposed, decomposed.length);
        }
    }

    @RubiniusPrimitive(name="time_useconds")
    public static abstract class TimeUSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeUSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeUSecondsPrimitiveNode(TimeUSecondsPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long timeUSeconds(org.jruby.truffle.runtime.core.RubyTime time) {
            return (long)time.getDateTime().getMillisOfSecond() * 1000L;
        }
    }

    @RubiniusPrimitive(name="time_seconds")
    public static abstract class TimeSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSecondsPrimitiveNode(TimeSecondsPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long timeSeconds(org.jruby.truffle.runtime.core.RubyTime time) {
            return time.getDateTime().getMillis() / 1000L;
        }
    }

    @RubiniusPrimitive(name="time_s_specific", needsSelf=false)
    public static abstract class TimeSSpecificPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadTimeZoneNode readTimeZoneNode;

        public TimeSSpecificPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
        }

        public TimeSSpecificPrimitiveNode(TimeSSpecificPrimitiveNode prev) {
            super(prev);
            this.readTimeZoneNode = prev.readTimeZoneNode;
        }

        @Specialization(guards={"isTrue(arguments[2])"})
        public org.jruby.truffle.runtime.core.RubyTime timeSSpecificUTC(long seconds, long nanoseconds, boolean isUTC, RubyNilClass offset) {
            return this.timeSSpecificUTC((int)seconds, (int)nanoseconds, isUTC, offset);
        }

        @Specialization(guards={"isTrue(arguments[2])"})
        public org.jruby.truffle.runtime.core.RubyTime timeSSpecificUTC(long seconds, int nanoseconds, boolean isUTC, RubyNilClass offset) {
            return this.timeSSpecificUTC((int)seconds, nanoseconds, isUTC, offset);
        }

        @Specialization(guards={"isTrue(arguments[2])"})
        public org.jruby.truffle.runtime.core.RubyTime timeSSpecificUTC(int seconds, int nanoseconds, boolean isUTC, RubyNilClass offset) {
            long milliseconds = (long)seconds * 1000L + (long)(nanoseconds / 1000000);
            return new org.jruby.truffle.runtime.core.RubyTime(this.getContext().getCoreLibrary().getTimeClass(), this.time(milliseconds), this.nil());
        }

        @Specialization(guards={"!isTrue(arguments[2])"})
        public org.jruby.truffle.runtime.core.RubyTime timeSSpecific(VirtualFrame frame, long seconds, long nanoseconds, boolean isUTC, RubyNilClass offset) {
            return this.timeSSpecific(frame, (int)seconds, (int)nanoseconds, isUTC, offset);
        }

        @Specialization(guards={"!isTrue(arguments[2])"})
        public org.jruby.truffle.runtime.core.RubyTime timeSSpecific(VirtualFrame frame, long seconds, int nanoseconds, boolean isUTC, RubyNilClass offset) {
            return this.timeSSpecific(frame, (int)seconds, nanoseconds, isUTC, offset);
        }

        @Specialization(guards={"!isTrue(arguments[2])"})
        public org.jruby.truffle.runtime.core.RubyTime timeSSpecific(VirtualFrame frame, int seconds, int nanoseconds, boolean isUTC, RubyNilClass offset) {
            long milliseconds = (long)seconds * 1000L + (long)nanoseconds / 1000000L;
            return new org.jruby.truffle.runtime.core.RubyTime(this.getContext().getCoreLibrary().getTimeClass(), this.time(milliseconds, this.readTimeZoneNode.executeRubyString(frame)), offset);
        }

        @CompilerDirectives.TruffleBoundary
        public DateTime time(long milliseconds) {
            return new DateTime(milliseconds, DateTimeZone.UTC);
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime time(long milliseconds, RubyString timeZone) {
            return new DateTime(milliseconds, RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)timeZone.toString()));
        }
    }

    @RubiniusPrimitive(name="time_s_dup", needsSelf=false)
    public static abstract class TimeSDupPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSDupPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSDupPrimitiveNode(TimeSDupPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSDup(org.jruby.truffle.runtime.core.RubyTime other) {
            org.jruby.truffle.runtime.core.RubyTime time = new org.jruby.truffle.runtime.core.RubyTime(this.getContext().getCoreLibrary().getTimeClass(), other.getDateTime(), other.getOffset());
            return time;
        }
    }

    @RubiniusPrimitive(name="time_s_now")
    public static abstract class TimeSNowPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadTimeZoneNode readTimeZoneNode;

        public TimeSNowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
        }

        public TimeSNowPrimitiveNode(TimeSNowPrimitiveNode prev) {
            super(prev);
            this.readTimeZoneNode = prev.readTimeZoneNode;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSNow(VirtualFrame frame, RubyClass timeClass) {
            return new org.jruby.truffle.runtime.core.RubyTime(timeClass, this.now(this.readTimeZoneNode.executeRubyString(frame)), this.nil());
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime now(RubyString timeZone) {
            return DateTime.now((DateTimeZone)RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)timeZone.toString()));
        }
    }
}

